/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lakeformation.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.lakeformation.model.ResourceInfo;
import java.util.Date;

@SdkInternalApi
public class ResourceInfoMarshaller {
    private static final MarshallingInfo<String> RESOURCEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceArn").build();
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RoleArn").build();
    private static final MarshallingInfo<Date> LASTMODIFIED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastModified").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Boolean> WITHFEDERATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("WithFederation").build();
    private static final MarshallingInfo<Boolean> HYBRIDACCESSENABLED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HybridAccessEnabled").build();
    private static final ResourceInfoMarshaller instance = new ResourceInfoMarshaller();

    public static ResourceInfoMarshaller getInstance() {
        return instance;
    }

    public void marshall(ResourceInfo resourceInfo, ProtocolMarshaller protocolMarshaller) {
        if (resourceInfo == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)resourceInfo.getResourceArn(), RESOURCEARN_BINDING);
            protocolMarshaller.marshall((Object)resourceInfo.getRoleArn(), ROLEARN_BINDING);
            protocolMarshaller.marshall((Object)resourceInfo.getLastModified(), LASTMODIFIED_BINDING);
            protocolMarshaller.marshall((Object)resourceInfo.getWithFederation(), WITHFEDERATION_BINDING);
            protocolMarshaller.marshall((Object)resourceInfo.getHybridAccessEnabled(), HYBRIDACCESSENABLED_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

