/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisvideo.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.kinesisvideo.model.RecorderConfig;

@SdkInternalApi
public class RecorderConfigMarshaller {
    private static final MarshallingInfo<StructuredPojo> MEDIASOURCECONFIG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MediaSourceConfig").build();
    private static final MarshallingInfo<StructuredPojo> SCHEDULECONFIG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ScheduleConfig").build();
    private static final RecorderConfigMarshaller instance = new RecorderConfigMarshaller();

    public static RecorderConfigMarshaller getInstance() {
        return instance;
    }

    public void marshall(RecorderConfig recorderConfig, ProtocolMarshaller protocolMarshaller) {
        if (recorderConfig == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)recorderConfig.getMediaSourceConfig(), MEDIASOURCECONFIG_BINDING);
            protocolMarshaller.marshall((Object)recorderConfig.getScheduleConfig(), SCHEDULECONFIG_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

