/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisvideo;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.kinesisvideo.AmazonKinesisVideoArchivedMediaAsync;
import com.amazonaws.services.kinesisvideo.AmazonKinesisVideoArchivedMediaAsyncClientBuilder;
import com.amazonaws.services.kinesisvideo.AmazonKinesisVideoArchivedMediaClient;
import com.amazonaws.services.kinesisvideo.model.GetClipRequest;
import com.amazonaws.services.kinesisvideo.model.GetClipResult;
import com.amazonaws.services.kinesisvideo.model.GetDASHStreamingSessionURLRequest;
import com.amazonaws.services.kinesisvideo.model.GetDASHStreamingSessionURLResult;
import com.amazonaws.services.kinesisvideo.model.GetHLSStreamingSessionURLRequest;
import com.amazonaws.services.kinesisvideo.model.GetHLSStreamingSessionURLResult;
import com.amazonaws.services.kinesisvideo.model.GetImagesRequest;
import com.amazonaws.services.kinesisvideo.model.GetImagesResult;
import com.amazonaws.services.kinesisvideo.model.GetMediaForFragmentListRequest;
import com.amazonaws.services.kinesisvideo.model.GetMediaForFragmentListResult;
import com.amazonaws.services.kinesisvideo.model.ListFragmentsRequest;
import com.amazonaws.services.kinesisvideo.model.ListFragmentsResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonKinesisVideoArchivedMediaAsyncClient
extends AmazonKinesisVideoArchivedMediaClient
implements AmazonKinesisVideoArchivedMediaAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AmazonKinesisVideoArchivedMediaAsyncClientBuilder asyncBuilder() {
        return AmazonKinesisVideoArchivedMediaAsyncClientBuilder.standard();
    }

    AmazonKinesisVideoArchivedMediaAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AmazonKinesisVideoArchivedMediaAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<GetClipResult> getClipAsync(GetClipRequest request) {
        return this.getClipAsync(request, null);
    }

    @Override
    public Future<GetClipResult> getClipAsync(GetClipRequest request, final AsyncHandler<GetClipRequest, GetClipResult> asyncHandler) {
        final GetClipRequest finalRequest = (GetClipRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetClipResult>(){

            @Override
            public GetClipResult call() throws Exception {
                GetClipResult result = null;
                try {
                    result = AmazonKinesisVideoArchivedMediaAsyncClient.this.executeGetClip(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetDASHStreamingSessionURLResult> getDASHStreamingSessionURLAsync(GetDASHStreamingSessionURLRequest request) {
        return this.getDASHStreamingSessionURLAsync(request, null);
    }

    @Override
    public Future<GetDASHStreamingSessionURLResult> getDASHStreamingSessionURLAsync(GetDASHStreamingSessionURLRequest request, final AsyncHandler<GetDASHStreamingSessionURLRequest, GetDASHStreamingSessionURLResult> asyncHandler) {
        final GetDASHStreamingSessionURLRequest finalRequest = (GetDASHStreamingSessionURLRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetDASHStreamingSessionURLResult>(){

            @Override
            public GetDASHStreamingSessionURLResult call() throws Exception {
                GetDASHStreamingSessionURLResult result = null;
                try {
                    result = AmazonKinesisVideoArchivedMediaAsyncClient.this.executeGetDASHStreamingSessionURL(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetHLSStreamingSessionURLResult> getHLSStreamingSessionURLAsync(GetHLSStreamingSessionURLRequest request) {
        return this.getHLSStreamingSessionURLAsync(request, null);
    }

    @Override
    public Future<GetHLSStreamingSessionURLResult> getHLSStreamingSessionURLAsync(GetHLSStreamingSessionURLRequest request, final AsyncHandler<GetHLSStreamingSessionURLRequest, GetHLSStreamingSessionURLResult> asyncHandler) {
        final GetHLSStreamingSessionURLRequest finalRequest = (GetHLSStreamingSessionURLRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetHLSStreamingSessionURLResult>(){

            @Override
            public GetHLSStreamingSessionURLResult call() throws Exception {
                GetHLSStreamingSessionURLResult result = null;
                try {
                    result = AmazonKinesisVideoArchivedMediaAsyncClient.this.executeGetHLSStreamingSessionURL(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetImagesResult> getImagesAsync(GetImagesRequest request) {
        return this.getImagesAsync(request, null);
    }

    @Override
    public Future<GetImagesResult> getImagesAsync(GetImagesRequest request, final AsyncHandler<GetImagesRequest, GetImagesResult> asyncHandler) {
        final GetImagesRequest finalRequest = (GetImagesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetImagesResult>(){

            @Override
            public GetImagesResult call() throws Exception {
                GetImagesResult result = null;
                try {
                    result = AmazonKinesisVideoArchivedMediaAsyncClient.this.executeGetImages(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetMediaForFragmentListResult> getMediaForFragmentListAsync(GetMediaForFragmentListRequest request) {
        return this.getMediaForFragmentListAsync(request, null);
    }

    @Override
    public Future<GetMediaForFragmentListResult> getMediaForFragmentListAsync(GetMediaForFragmentListRequest request, final AsyncHandler<GetMediaForFragmentListRequest, GetMediaForFragmentListResult> asyncHandler) {
        final GetMediaForFragmentListRequest finalRequest = (GetMediaForFragmentListRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetMediaForFragmentListResult>(){

            @Override
            public GetMediaForFragmentListResult call() throws Exception {
                GetMediaForFragmentListResult result = null;
                try {
                    result = AmazonKinesisVideoArchivedMediaAsyncClient.this.executeGetMediaForFragmentList(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListFragmentsResult> listFragmentsAsync(ListFragmentsRequest request) {
        return this.listFragmentsAsync(request, null);
    }

    @Override
    public Future<ListFragmentsResult> listFragmentsAsync(ListFragmentsRequest request, final AsyncHandler<ListFragmentsRequest, ListFragmentsResult> asyncHandler) {
        final ListFragmentsRequest finalRequest = (ListFragmentsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListFragmentsResult>(){

            @Override
            public ListFragmentsResult call() throws Exception {
                ListFragmentsResult result = null;
                try {
                    result = AmazonKinesisVideoArchivedMediaAsyncClient.this.executeListFragments(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

