/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisvideo;

import com.amazonaws.SdkClientException;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.regions.AwsRegionProvider;
import com.amazonaws.regions.DefaultAwsRegionProviderChain;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.kinesisvideo.AmazonKinesisVideoPutMedia;
import com.amazonaws.services.kinesisvideo.AmazonKinesisVideoPutMediaClient;
import java.net.URI;

public final class AmazonKinesisVideoPutMediaClientBuilder {
    private static final AwsRegionProvider DEFAULT_REGION_PROVIDER = new DefaultAwsRegionProviderChain();
    private static final int DEFAULT_CONNECTION_TIMEOUT = 10000;
    private AWSCredentialsProvider credentialsProvider;
    private String region;
    private URI endpoint;
    private Integer connectionTimeoutInMillis;
    private Integer numberOfThreads;

    AmazonKinesisVideoPutMediaClientBuilder() {
    }

    public static AmazonKinesisVideoPutMediaClientBuilder standard() {
        return new AmazonKinesisVideoPutMediaClientBuilder();
    }

    public AWSCredentialsProvider getCredentials() {
        return this.credentialsProvider;
    }

    public void setCredentials(AWSCredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
    }

    public AmazonKinesisVideoPutMediaClientBuilder withCredentials(AWSCredentialsProvider credentialsProvider) {
        this.setCredentials(credentialsProvider);
        return this;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public AmazonKinesisVideoPutMediaClientBuilder withRegion(String region) {
        this.setRegion(region);
        return this;
    }

    public AmazonKinesisVideoPutMediaClientBuilder withRegion(Regions region) {
        this.setRegion(region.getName());
        return this;
    }

    public Integer getConnectionTimeoutInMillis() {
        return this.connectionTimeoutInMillis;
    }

    public void setConnectionTimeoutInMillis(Integer connectionTimeoutInMillis) {
        this.connectionTimeoutInMillis = connectionTimeoutInMillis;
    }

    public AmazonKinesisVideoPutMediaClientBuilder withConnectionTimeoutInMillis(Integer connectionTimeoutInMillis) {
        this.setConnectionTimeoutInMillis(connectionTimeoutInMillis);
        return this;
    }

    public URI getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(URI endpoint) {
        this.endpoint = endpoint;
    }

    public AmazonKinesisVideoPutMediaClientBuilder withEndpoint(URI endpoint) {
        this.setEndpoint(endpoint);
        return this;
    }

    public AmazonKinesisVideoPutMediaClientBuilder withEndpoint(String endpoint) {
        this.setEndpoint(URI.create(endpoint));
        return this;
    }

    public Integer getNumberOfThreads() {
        return this.numberOfThreads;
    }

    public void setNumberOfThreads(Integer numberOfThreads) {
        this.numberOfThreads = numberOfThreads;
    }

    public AmazonKinesisVideoPutMediaClientBuilder withNumberOfThreads(Integer numberOfThreads) {
        this.setNumberOfThreads(numberOfThreads);
        return this;
    }

    private String resolveRegion() {
        return this.region == null ? this.determineRegionFromRegionProvider() : this.region;
    }

    private String determineRegionFromRegionProvider() {
        try {
            return DEFAULT_REGION_PROVIDER.getRegion();
        }
        catch (SdkClientException e) {
            return null;
        }
    }

    private AWSCredentialsProvider resolveCredentialsProvider() {
        return this.credentialsProvider == null ? DefaultAWSCredentialsProviderChain.getInstance() : this.credentialsProvider;
    }

    private int resolveConnectionTimeoutInMillis() {
        return this.connectionTimeoutInMillis == null ? 10000 : this.connectionTimeoutInMillis;
    }

    public AmazonKinesisVideoPutMedia build() {
        return new AmazonKinesisVideoPutMediaClient(this.resolveRegion(), this.resolveCredentialsProvider(), this.resolveConnectionTimeoutInMillis(), this.endpoint, this.numberOfThreads);
    }
}

