/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisvideo;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.kinesisvideo.AmazonKinesisVideoArchivedMedia;
import com.amazonaws.services.kinesisvideo.AmazonKinesisVideoArchivedMediaClientBuilder;
import com.amazonaws.services.kinesisvideo.model.AmazonKinesisVideoException;
import com.amazonaws.services.kinesisvideo.model.GetDASHStreamingSessionURLRequest;
import com.amazonaws.services.kinesisvideo.model.GetDASHStreamingSessionURLResult;
import com.amazonaws.services.kinesisvideo.model.GetHLSStreamingSessionURLRequest;
import com.amazonaws.services.kinesisvideo.model.GetHLSStreamingSessionURLResult;
import com.amazonaws.services.kinesisvideo.model.GetMediaForFragmentListRequest;
import com.amazonaws.services.kinesisvideo.model.GetMediaForFragmentListResult;
import com.amazonaws.services.kinesisvideo.model.ListFragmentsRequest;
import com.amazonaws.services.kinesisvideo.model.ListFragmentsResult;
import com.amazonaws.services.kinesisvideo.model.transform.ClientLimitExceededExceptionUnmarshaller;
import com.amazonaws.services.kinesisvideo.model.transform.GetDASHStreamingSessionURLRequestProtocolMarshaller;
import com.amazonaws.services.kinesisvideo.model.transform.GetDASHStreamingSessionURLResultJsonUnmarshaller;
import com.amazonaws.services.kinesisvideo.model.transform.GetHLSStreamingSessionURLRequestProtocolMarshaller;
import com.amazonaws.services.kinesisvideo.model.transform.GetHLSStreamingSessionURLResultJsonUnmarshaller;
import com.amazonaws.services.kinesisvideo.model.transform.GetMediaForFragmentListRequestProtocolMarshaller;
import com.amazonaws.services.kinesisvideo.model.transform.GetMediaForFragmentListResultJsonUnmarshaller;
import com.amazonaws.services.kinesisvideo.model.transform.InvalidArgumentExceptionUnmarshaller;
import com.amazonaws.services.kinesisvideo.model.transform.InvalidCodecPrivateDataExceptionUnmarshaller;
import com.amazonaws.services.kinesisvideo.model.transform.ListFragmentsRequestProtocolMarshaller;
import com.amazonaws.services.kinesisvideo.model.transform.ListFragmentsResultJsonUnmarshaller;
import com.amazonaws.services.kinesisvideo.model.transform.MissingCodecPrivateDataExceptionUnmarshaller;
import com.amazonaws.services.kinesisvideo.model.transform.NoDataRetentionExceptionUnmarshaller;
import com.amazonaws.services.kinesisvideo.model.transform.NotAuthorizedExceptionUnmarshaller;
import com.amazonaws.services.kinesisvideo.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.kinesisvideo.model.transform.UnsupportedStreamMediaTypeExceptionUnmarshaller;
import com.amazonaws.transform.JsonBaseExceptionUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import com.amazonaws.util.ServiceClientHolderInputStream;
import java.io.InputStream;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AmazonKinesisVideoArchivedMediaClient
extends AmazonWebServiceClient
implements AmazonKinesisVideoArchivedMedia {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonKinesisVideoArchivedMedia.class);
    private static final String DEFAULT_SIGNING_NAME = "kinesisvideo";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("NotAuthorizedException").withExceptionUnmarshaller((JsonErrorUnmarshaller)NotAuthorizedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidCodecPrivateDataException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InvalidCodecPrivateDataExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidArgumentException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InvalidArgumentExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ClientLimitExceededException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ClientLimitExceededExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("NoDataRetentionException").withExceptionUnmarshaller((JsonErrorUnmarshaller)NoDataRetentionExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("UnsupportedStreamMediaTypeException").withExceptionUnmarshaller((JsonErrorUnmarshaller)UnsupportedStreamMediaTypeExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("MissingCodecPrivateDataException").withExceptionUnmarshaller((JsonErrorUnmarshaller)MissingCodecPrivateDataExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode(null).withExceptionUnmarshaller((JsonErrorUnmarshaller)new JsonBaseExceptionUnmarshaller(AmazonKinesisVideoException.class))));

    public static AmazonKinesisVideoArchivedMediaClientBuilder builder() {
        return AmazonKinesisVideoArchivedMediaClientBuilder.standard();
    }

    AmazonKinesisVideoArchivedMediaClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AmazonKinesisVideoArchivedMediaClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("kinesisvideo.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/kinesisvideo/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/kinesisvideo/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public GetDASHStreamingSessionURLResult getDASHStreamingSessionURL(GetDASHStreamingSessionURLRequest request) {
        request = (GetDASHStreamingSessionURLRequest)this.beforeClientExecution(request);
        return this.executeGetDASHStreamingSessionURL(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetDASHStreamingSessionURLResult executeGetDASHStreamingSessionURL(GetDASHStreamingSessionURLRequest getDASHStreamingSessionURLRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getDASHStreamingSessionURLRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetDASHStreamingSessionURLRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetDASHStreamingSessionURLRequestProtocolMarshaller(protocolFactory).marshall((GetDASHStreamingSessionURLRequest)super.beforeMarshalling((AmazonWebServiceRequest)getDASHStreamingSessionURLRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Kinesis Video Archived Media");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetDASHStreamingSessionURL");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetDASHStreamingSessionURLResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetDASHStreamingSessionURLResult getDASHStreamingSessionURLResult = (GetDASHStreamingSessionURLResult)response.getAwsResponse();
            return getDASHStreamingSessionURLResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetHLSStreamingSessionURLResult getHLSStreamingSessionURL(GetHLSStreamingSessionURLRequest request) {
        request = (GetHLSStreamingSessionURLRequest)this.beforeClientExecution(request);
        return this.executeGetHLSStreamingSessionURL(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetHLSStreamingSessionURLResult executeGetHLSStreamingSessionURL(GetHLSStreamingSessionURLRequest getHLSStreamingSessionURLRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getHLSStreamingSessionURLRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetHLSStreamingSessionURLRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetHLSStreamingSessionURLRequestProtocolMarshaller(protocolFactory).marshall((GetHLSStreamingSessionURLRequest)super.beforeMarshalling((AmazonWebServiceRequest)getHLSStreamingSessionURLRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Kinesis Video Archived Media");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetHLSStreamingSessionURL");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetHLSStreamingSessionURLResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetHLSStreamingSessionURLResult getHLSStreamingSessionURLResult = (GetHLSStreamingSessionURLResult)response.getAwsResponse();
            return getHLSStreamingSessionURLResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetMediaForFragmentListResult getMediaForFragmentList(GetMediaForFragmentListRequest request) {
        request = (GetMediaForFragmentListRequest)this.beforeClientExecution(request);
        return this.executeGetMediaForFragmentList(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetMediaForFragmentListResult executeGetMediaForFragmentList(GetMediaForFragmentListRequest getMediaForFragmentListRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getMediaForFragmentListRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetMediaForFragmentListRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetMediaForFragmentListRequestProtocolMarshaller(protocolFactory).marshall((GetMediaForFragmentListRequest)super.beforeMarshalling((AmazonWebServiceRequest)getMediaForFragmentListRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Kinesis Video Archived Media");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetMediaForFragmentList");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(false).withHasStreamingSuccessResponse(true), (Unmarshaller)new GetMediaForFragmentListResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ((GetMediaForFragmentListResult)response.getAwsResponse()).setPayload((InputStream)new ServiceClientHolderInputStream(((GetMediaForFragmentListResult)response.getAwsResponse()).getPayload(), (AmazonWebServiceClient)this));
            GetMediaForFragmentListResult getMediaForFragmentListResult = (GetMediaForFragmentListResult)response.getAwsResponse();
            return getMediaForFragmentListResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListFragmentsResult listFragments(ListFragmentsRequest request) {
        request = (ListFragmentsRequest)this.beforeClientExecution(request);
        return this.executeListFragments(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListFragmentsResult executeListFragments(ListFragmentsRequest listFragmentsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listFragmentsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListFragmentsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListFragmentsRequestProtocolMarshaller(protocolFactory).marshall((ListFragmentsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listFragmentsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Kinesis Video Archived Media");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListFragments");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListFragmentsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListFragmentsResult listFragmentsResult = (ListFragmentsResult)response.getAwsResponse();
            return listFragmentsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }
}

