/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisvideo.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.kinesisvideo.model.Fragment;
import java.util.Date;

@SdkInternalApi
public class FragmentMarshaller {
    private static final MarshallingInfo<String> FRAGMENTNUMBER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FragmentNumber").build();
    private static final MarshallingInfo<Long> FRAGMENTSIZEINBYTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FragmentSizeInBytes").build();
    private static final MarshallingInfo<Date> PRODUCERTIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProducerTimestamp").build();
    private static final MarshallingInfo<Date> SERVERTIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ServerTimestamp").build();
    private static final MarshallingInfo<Long> FRAGMENTLENGTHINMILLISECONDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FragmentLengthInMilliseconds").build();
    private static final FragmentMarshaller instance = new FragmentMarshaller();

    public static FragmentMarshaller getInstance() {
        return instance;
    }

    public void marshall(Fragment fragment, ProtocolMarshaller protocolMarshaller) {
        if (fragment == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)fragment.getFragmentNumber(), FRAGMENTNUMBER_BINDING);
            protocolMarshaller.marshall((Object)fragment.getFragmentSizeInBytes(), FRAGMENTSIZEINBYTES_BINDING);
            protocolMarshaller.marshall((Object)fragment.getProducerTimestamp(), PRODUCERTIMESTAMP_BINDING);
            protocolMarshaller.marshall((Object)fragment.getServerTimestamp(), SERVERTIMESTAMP_BINDING);
            protocolMarshaller.marshall((Object)fragment.getFragmentLengthInMilliseconds(), FRAGMENTLENGTHINMILLISECONDS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

