/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisanalyticsv2.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.kinesisanalyticsv2.model.PropertyGroup;
import com.amazonaws.services.kinesisanalyticsv2.model.transform.EnvironmentPropertiesMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class EnvironmentProperties
implements Serializable,
Cloneable,
StructuredPojo {
    private List<PropertyGroup> propertyGroups;

    public List<PropertyGroup> getPropertyGroups() {
        return this.propertyGroups;
    }

    public void setPropertyGroups(Collection<PropertyGroup> propertyGroups) {
        if (propertyGroups == null) {
            this.propertyGroups = null;
            return;
        }
        this.propertyGroups = new ArrayList<PropertyGroup>(propertyGroups);
    }

    public EnvironmentProperties withPropertyGroups(PropertyGroup ... propertyGroups) {
        if (this.propertyGroups == null) {
            this.setPropertyGroups(new ArrayList<PropertyGroup>(propertyGroups.length));
        }
        for (PropertyGroup ele : propertyGroups) {
            this.propertyGroups.add(ele);
        }
        return this;
    }

    public EnvironmentProperties withPropertyGroups(Collection<PropertyGroup> propertyGroups) {
        this.setPropertyGroups(propertyGroups);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPropertyGroups() != null) {
            sb.append("PropertyGroups: ").append(this.getPropertyGroups());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnvironmentProperties)) {
            return false;
        }
        EnvironmentProperties other = (EnvironmentProperties)obj;
        if (other.getPropertyGroups() == null ^ this.getPropertyGroups() == null) {
            return false;
        }
        return other.getPropertyGroups() == null || other.getPropertyGroups().equals(this.getPropertyGroups());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPropertyGroups() == null ? 0 : this.getPropertyGroups().hashCode());
        return hashCode;
    }

    public EnvironmentProperties clone() {
        try {
            return (EnvironmentProperties)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EnvironmentPropertiesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

