/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisanalyticsv2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.kinesisanalyticsv2.model.ApplicationConfiguration;
import com.amazonaws.services.kinesisanalyticsv2.model.ApplicationMode;
import com.amazonaws.services.kinesisanalyticsv2.model.CloudWatchLoggingOption;
import com.amazonaws.services.kinesisanalyticsv2.model.RuntimeEnvironment;
import com.amazonaws.services.kinesisanalyticsv2.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateApplicationRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String applicationName;
    private String applicationDescription;
    private String runtimeEnvironment;
    private String serviceExecutionRole;
    private ApplicationConfiguration applicationConfiguration;
    private List<CloudWatchLoggingOption> cloudWatchLoggingOptions;
    private List<Tag> tags;
    private String applicationMode;

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public CreateApplicationRequest withApplicationName(String applicationName) {
        this.setApplicationName(applicationName);
        return this;
    }

    public void setApplicationDescription(String applicationDescription) {
        this.applicationDescription = applicationDescription;
    }

    public String getApplicationDescription() {
        return this.applicationDescription;
    }

    public CreateApplicationRequest withApplicationDescription(String applicationDescription) {
        this.setApplicationDescription(applicationDescription);
        return this;
    }

    public void setRuntimeEnvironment(String runtimeEnvironment) {
        this.runtimeEnvironment = runtimeEnvironment;
    }

    public String getRuntimeEnvironment() {
        return this.runtimeEnvironment;
    }

    public CreateApplicationRequest withRuntimeEnvironment(String runtimeEnvironment) {
        this.setRuntimeEnvironment(runtimeEnvironment);
        return this;
    }

    public CreateApplicationRequest withRuntimeEnvironment(RuntimeEnvironment runtimeEnvironment) {
        this.runtimeEnvironment = runtimeEnvironment.toString();
        return this;
    }

    public void setServiceExecutionRole(String serviceExecutionRole) {
        this.serviceExecutionRole = serviceExecutionRole;
    }

    public String getServiceExecutionRole() {
        return this.serviceExecutionRole;
    }

    public CreateApplicationRequest withServiceExecutionRole(String serviceExecutionRole) {
        this.setServiceExecutionRole(serviceExecutionRole);
        return this;
    }

    public void setApplicationConfiguration(ApplicationConfiguration applicationConfiguration) {
        this.applicationConfiguration = applicationConfiguration;
    }

    public ApplicationConfiguration getApplicationConfiguration() {
        return this.applicationConfiguration;
    }

    public CreateApplicationRequest withApplicationConfiguration(ApplicationConfiguration applicationConfiguration) {
        this.setApplicationConfiguration(applicationConfiguration);
        return this;
    }

    public List<CloudWatchLoggingOption> getCloudWatchLoggingOptions() {
        return this.cloudWatchLoggingOptions;
    }

    public void setCloudWatchLoggingOptions(Collection<CloudWatchLoggingOption> cloudWatchLoggingOptions) {
        if (cloudWatchLoggingOptions == null) {
            this.cloudWatchLoggingOptions = null;
            return;
        }
        this.cloudWatchLoggingOptions = new ArrayList<CloudWatchLoggingOption>(cloudWatchLoggingOptions);
    }

    public CreateApplicationRequest withCloudWatchLoggingOptions(CloudWatchLoggingOption ... cloudWatchLoggingOptions) {
        if (this.cloudWatchLoggingOptions == null) {
            this.setCloudWatchLoggingOptions(new ArrayList<CloudWatchLoggingOption>(cloudWatchLoggingOptions.length));
        }
        for (CloudWatchLoggingOption ele : cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions.add(ele);
        }
        return this;
    }

    public CreateApplicationRequest withCloudWatchLoggingOptions(Collection<CloudWatchLoggingOption> cloudWatchLoggingOptions) {
        this.setCloudWatchLoggingOptions(cloudWatchLoggingOptions);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public CreateApplicationRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateApplicationRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public void setApplicationMode(String applicationMode) {
        this.applicationMode = applicationMode;
    }

    public String getApplicationMode() {
        return this.applicationMode;
    }

    public CreateApplicationRequest withApplicationMode(String applicationMode) {
        this.setApplicationMode(applicationMode);
        return this;
    }

    public CreateApplicationRequest withApplicationMode(ApplicationMode applicationMode) {
        this.applicationMode = applicationMode.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getApplicationName() != null) {
            sb.append("ApplicationName: ").append(this.getApplicationName()).append(",");
        }
        if (this.getApplicationDescription() != null) {
            sb.append("ApplicationDescription: ").append(this.getApplicationDescription()).append(",");
        }
        if (this.getRuntimeEnvironment() != null) {
            sb.append("RuntimeEnvironment: ").append(this.getRuntimeEnvironment()).append(",");
        }
        if (this.getServiceExecutionRole() != null) {
            sb.append("ServiceExecutionRole: ").append(this.getServiceExecutionRole()).append(",");
        }
        if (this.getApplicationConfiguration() != null) {
            sb.append("ApplicationConfiguration: ").append(this.getApplicationConfiguration()).append(",");
        }
        if (this.getCloudWatchLoggingOptions() != null) {
            sb.append("CloudWatchLoggingOptions: ").append(this.getCloudWatchLoggingOptions()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getApplicationMode() != null) {
            sb.append("ApplicationMode: ").append(this.getApplicationMode());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateApplicationRequest)) {
            return false;
        }
        CreateApplicationRequest other = (CreateApplicationRequest)obj;
        if (other.getApplicationName() == null ^ this.getApplicationName() == null) {
            return false;
        }
        if (other.getApplicationName() != null && !other.getApplicationName().equals(this.getApplicationName())) {
            return false;
        }
        if (other.getApplicationDescription() == null ^ this.getApplicationDescription() == null) {
            return false;
        }
        if (other.getApplicationDescription() != null && !other.getApplicationDescription().equals(this.getApplicationDescription())) {
            return false;
        }
        if (other.getRuntimeEnvironment() == null ^ this.getRuntimeEnvironment() == null) {
            return false;
        }
        if (other.getRuntimeEnvironment() != null && !other.getRuntimeEnvironment().equals(this.getRuntimeEnvironment())) {
            return false;
        }
        if (other.getServiceExecutionRole() == null ^ this.getServiceExecutionRole() == null) {
            return false;
        }
        if (other.getServiceExecutionRole() != null && !other.getServiceExecutionRole().equals(this.getServiceExecutionRole())) {
            return false;
        }
        if (other.getApplicationConfiguration() == null ^ this.getApplicationConfiguration() == null) {
            return false;
        }
        if (other.getApplicationConfiguration() != null && !other.getApplicationConfiguration().equals(this.getApplicationConfiguration())) {
            return false;
        }
        if (other.getCloudWatchLoggingOptions() == null ^ this.getCloudWatchLoggingOptions() == null) {
            return false;
        }
        if (other.getCloudWatchLoggingOptions() != null && !other.getCloudWatchLoggingOptions().equals(this.getCloudWatchLoggingOptions())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getApplicationMode() == null ^ this.getApplicationMode() == null) {
            return false;
        }
        return other.getApplicationMode() == null || other.getApplicationMode().equals(this.getApplicationMode());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getApplicationName() == null ? 0 : this.getApplicationName().hashCode());
        hashCode = 31 * hashCode + (this.getApplicationDescription() == null ? 0 : this.getApplicationDescription().hashCode());
        hashCode = 31 * hashCode + (this.getRuntimeEnvironment() == null ? 0 : this.getRuntimeEnvironment().hashCode());
        hashCode = 31 * hashCode + (this.getServiceExecutionRole() == null ? 0 : this.getServiceExecutionRole().hashCode());
        hashCode = 31 * hashCode + (this.getApplicationConfiguration() == null ? 0 : this.getApplicationConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getCloudWatchLoggingOptions() == null ? 0 : this.getCloudWatchLoggingOptions().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getApplicationMode() == null ? 0 : this.getApplicationMode().hashCode());
        return hashCode;
    }

    public CreateApplicationRequest clone() {
        return (CreateApplicationRequest)super.clone();
    }
}

