/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Describes whether snapshots are enabled for a Managed Service for Apache Flink application.
 * </p>
 * 
 * @see <a
 *      href="http://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/ApplicationSnapshotConfigurationDescription"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ApplicationSnapshotConfigurationDescription implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * Describes whether snapshots are enabled for a Managed Service for Apache Flink application.
     * </p>
     */
    private Boolean snapshotsEnabled;

    /**
     * <p>
     * Describes whether snapshots are enabled for a Managed Service for Apache Flink application.
     * </p>
     * 
     * @param snapshotsEnabled
     *        Describes whether snapshots are enabled for a Managed Service for Apache Flink application.
     */

    public void setSnapshotsEnabled(Boolean snapshotsEnabled) {
        this.snapshotsEnabled = snapshotsEnabled;
    }

    /**
     * <p>
     * Describes whether snapshots are enabled for a Managed Service for Apache Flink application.
     * </p>
     * 
     * @return Describes whether snapshots are enabled for a Managed Service for Apache Flink application.
     */

    public Boolean getSnapshotsEnabled() {
        return this.snapshotsEnabled;
    }

    /**
     * <p>
     * Describes whether snapshots are enabled for a Managed Service for Apache Flink application.
     * </p>
     * 
     * @param snapshotsEnabled
     *        Describes whether snapshots are enabled for a Managed Service for Apache Flink application.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ApplicationSnapshotConfigurationDescription withSnapshotsEnabled(Boolean snapshotsEnabled) {
        setSnapshotsEnabled(snapshotsEnabled);
        return this;
    }

    /**
     * <p>
     * Describes whether snapshots are enabled for a Managed Service for Apache Flink application.
     * </p>
     * 
     * @return Describes whether snapshots are enabled for a Managed Service for Apache Flink application.
     */

    public Boolean isSnapshotsEnabled() {
        return this.snapshotsEnabled;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getSnapshotsEnabled() != null)
            sb.append("SnapshotsEnabled: ").append(getSnapshotsEnabled());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ApplicationSnapshotConfigurationDescription == false)
            return false;
        ApplicationSnapshotConfigurationDescription other = (ApplicationSnapshotConfigurationDescription) obj;
        if (other.getSnapshotsEnabled() == null ^ this.getSnapshotsEnabled() == null)
            return false;
        if (other.getSnapshotsEnabled() != null && other.getSnapshotsEnabled().equals(this.getSnapshotsEnabled()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getSnapshotsEnabled() == null) ? 0 : getSnapshotsEnabled().hashCode());
        return hashCode;
    }

    @Override
    public ApplicationSnapshotConfigurationDescription clone() {
        try {
            return (ApplicationSnapshotConfigurationDescription) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.kinesisanalyticsv2.model.transform.ApplicationSnapshotConfigurationDescriptionMarshaller.getInstance().marshall(this,
                protocolMarshaller);
    }
}
