/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisanalytics.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.kinesisanalytics.model.S3ReferenceDataSource;

@SdkInternalApi
public class S3ReferenceDataSourceMarshaller {
    private static final MarshallingInfo<String> BUCKETARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BucketARN").build();
    private static final MarshallingInfo<String> FILEKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FileKey").build();
    private static final MarshallingInfo<String> REFERENCEROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReferenceRoleARN").build();
    private static final S3ReferenceDataSourceMarshaller instance = new S3ReferenceDataSourceMarshaller();

    public static S3ReferenceDataSourceMarshaller getInstance() {
        return instance;
    }

    public void marshall(S3ReferenceDataSource s3ReferenceDataSource, ProtocolMarshaller protocolMarshaller) {
        if (s3ReferenceDataSource == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)s3ReferenceDataSource.getBucketARN(), BUCKETARN_BINDING);
            protocolMarshaller.marshall((Object)s3ReferenceDataSource.getFileKey(), FILEKEY_BINDING);
            protocolMarshaller.marshall((Object)s3ReferenceDataSource.getReferenceRoleARN(), REFERENCEROLEARN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

