/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisfirehose.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.kinesisfirehose.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class TagDeliveryStreamRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String deliveryStreamName;
    private List<Tag> tags;

    public void setDeliveryStreamName(String deliveryStreamName) {
        this.deliveryStreamName = deliveryStreamName;
    }

    public String getDeliveryStreamName() {
        return this.deliveryStreamName;
    }

    public TagDeliveryStreamRequest withDeliveryStreamName(String deliveryStreamName) {
        this.setDeliveryStreamName(deliveryStreamName);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public TagDeliveryStreamRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public TagDeliveryStreamRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDeliveryStreamName() != null) {
            sb.append("DeliveryStreamName: ").append(this.getDeliveryStreamName()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TagDeliveryStreamRequest)) {
            return false;
        }
        TagDeliveryStreamRequest other = (TagDeliveryStreamRequest)obj;
        if (other.getDeliveryStreamName() == null ^ this.getDeliveryStreamName() == null) {
            return false;
        }
        if (other.getDeliveryStreamName() != null && !other.getDeliveryStreamName().equals(this.getDeliveryStreamName())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDeliveryStreamName() == null ? 0 : this.getDeliveryStreamName().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public TagDeliveryStreamRequest clone() {
        return (TagDeliveryStreamRequest)super.clone();
    }
}

