/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisanalytics;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.kinesisanalytics.AmazonKinesisAnalytics;
import com.amazonaws.services.kinesisanalytics.AmazonKinesisAnalyticsClientBuilder;
import com.amazonaws.services.kinesisanalytics.model.AddApplicationInputRequest;
import com.amazonaws.services.kinesisanalytics.model.AddApplicationInputResult;
import com.amazonaws.services.kinesisanalytics.model.AddApplicationOutputRequest;
import com.amazonaws.services.kinesisanalytics.model.AddApplicationOutputResult;
import com.amazonaws.services.kinesisanalytics.model.AddApplicationReferenceDataSourceRequest;
import com.amazonaws.services.kinesisanalytics.model.AddApplicationReferenceDataSourceResult;
import com.amazonaws.services.kinesisanalytics.model.AmazonKinesisAnalyticsException;
import com.amazonaws.services.kinesisanalytics.model.CodeValidationException;
import com.amazonaws.services.kinesisanalytics.model.ConcurrentModificationException;
import com.amazonaws.services.kinesisanalytics.model.CreateApplicationRequest;
import com.amazonaws.services.kinesisanalytics.model.CreateApplicationResult;
import com.amazonaws.services.kinesisanalytics.model.DeleteApplicationOutputRequest;
import com.amazonaws.services.kinesisanalytics.model.DeleteApplicationOutputResult;
import com.amazonaws.services.kinesisanalytics.model.DeleteApplicationReferenceDataSourceRequest;
import com.amazonaws.services.kinesisanalytics.model.DeleteApplicationReferenceDataSourceResult;
import com.amazonaws.services.kinesisanalytics.model.DeleteApplicationRequest;
import com.amazonaws.services.kinesisanalytics.model.DeleteApplicationResult;
import com.amazonaws.services.kinesisanalytics.model.DescribeApplicationRequest;
import com.amazonaws.services.kinesisanalytics.model.DescribeApplicationResult;
import com.amazonaws.services.kinesisanalytics.model.DiscoverInputSchemaRequest;
import com.amazonaws.services.kinesisanalytics.model.DiscoverInputSchemaResult;
import com.amazonaws.services.kinesisanalytics.model.InvalidApplicationConfigurationException;
import com.amazonaws.services.kinesisanalytics.model.InvalidArgumentException;
import com.amazonaws.services.kinesisanalytics.model.LimitExceededException;
import com.amazonaws.services.kinesisanalytics.model.ListApplicationsRequest;
import com.amazonaws.services.kinesisanalytics.model.ListApplicationsResult;
import com.amazonaws.services.kinesisanalytics.model.ResourceInUseException;
import com.amazonaws.services.kinesisanalytics.model.ResourceNotFoundException;
import com.amazonaws.services.kinesisanalytics.model.ResourceProvisionedThroughputExceededException;
import com.amazonaws.services.kinesisanalytics.model.StartApplicationRequest;
import com.amazonaws.services.kinesisanalytics.model.StartApplicationResult;
import com.amazonaws.services.kinesisanalytics.model.StopApplicationRequest;
import com.amazonaws.services.kinesisanalytics.model.StopApplicationResult;
import com.amazonaws.services.kinesisanalytics.model.UnableToDetectSchemaException;
import com.amazonaws.services.kinesisanalytics.model.UpdateApplicationRequest;
import com.amazonaws.services.kinesisanalytics.model.UpdateApplicationResult;
import com.amazonaws.services.kinesisanalytics.model.transform.AddApplicationInputRequestMarshaller;
import com.amazonaws.services.kinesisanalytics.model.transform.AddApplicationInputResultJsonUnmarshaller;
import com.amazonaws.services.kinesisanalytics.model.transform.AddApplicationOutputRequestMarshaller;
import com.amazonaws.services.kinesisanalytics.model.transform.AddApplicationOutputResultJsonUnmarshaller;
import com.amazonaws.services.kinesisanalytics.model.transform.AddApplicationReferenceDataSourceRequestMarshaller;
import com.amazonaws.services.kinesisanalytics.model.transform.AddApplicationReferenceDataSourceResultJsonUnmarshaller;
import com.amazonaws.services.kinesisanalytics.model.transform.CreateApplicationRequestMarshaller;
import com.amazonaws.services.kinesisanalytics.model.transform.CreateApplicationResultJsonUnmarshaller;
import com.amazonaws.services.kinesisanalytics.model.transform.DeleteApplicationOutputRequestMarshaller;
import com.amazonaws.services.kinesisanalytics.model.transform.DeleteApplicationOutputResultJsonUnmarshaller;
import com.amazonaws.services.kinesisanalytics.model.transform.DeleteApplicationReferenceDataSourceRequestMarshaller;
import com.amazonaws.services.kinesisanalytics.model.transform.DeleteApplicationReferenceDataSourceResultJsonUnmarshaller;
import com.amazonaws.services.kinesisanalytics.model.transform.DeleteApplicationRequestMarshaller;
import com.amazonaws.services.kinesisanalytics.model.transform.DeleteApplicationResultJsonUnmarshaller;
import com.amazonaws.services.kinesisanalytics.model.transform.DescribeApplicationRequestMarshaller;
import com.amazonaws.services.kinesisanalytics.model.transform.DescribeApplicationResultJsonUnmarshaller;
import com.amazonaws.services.kinesisanalytics.model.transform.DiscoverInputSchemaRequestMarshaller;
import com.amazonaws.services.kinesisanalytics.model.transform.DiscoverInputSchemaResultJsonUnmarshaller;
import com.amazonaws.services.kinesisanalytics.model.transform.ListApplicationsRequestMarshaller;
import com.amazonaws.services.kinesisanalytics.model.transform.ListApplicationsResultJsonUnmarshaller;
import com.amazonaws.services.kinesisanalytics.model.transform.StartApplicationRequestMarshaller;
import com.amazonaws.services.kinesisanalytics.model.transform.StartApplicationResultJsonUnmarshaller;
import com.amazonaws.services.kinesisanalytics.model.transform.StopApplicationRequestMarshaller;
import com.amazonaws.services.kinesisanalytics.model.transform.StopApplicationResultJsonUnmarshaller;
import com.amazonaws.services.kinesisanalytics.model.transform.UpdateApplicationRequestMarshaller;
import com.amazonaws.services.kinesisanalytics.model.transform.UpdateApplicationResultJsonUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AmazonKinesisAnalyticsClient
extends AmazonWebServiceClient
implements AmazonKinesisAnalytics {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonKinesisAnalytics.class);
    private static final String DEFAULT_SIGNING_NAME = "kinesisanalytics";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConcurrentModificationException").withModeledClass(ConcurrentModificationException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidApplicationConfigurationException").withModeledClass(InvalidApplicationConfigurationException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("UnableToDetectSchemaException").withModeledClass(UnableToDetectSchemaException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("CodeValidationException").withModeledClass(CodeValidationException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidArgumentException").withModeledClass(InvalidArgumentException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceInUseException").withModeledClass(ResourceInUseException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withModeledClass(ResourceNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceProvisionedThroughputExceededException").withModeledClass(ResourceProvisionedThroughputExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LimitExceededException").withModeledClass(LimitExceededException.class)).withBaseServiceExceptionClass(AmazonKinesisAnalyticsException.class));

    @Deprecated
    public AmazonKinesisAnalyticsClient() {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), configFactory.getConfig());
    }

    @Deprecated
    public AmazonKinesisAnalyticsClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration);
    }

    @Deprecated
    public AmazonKinesisAnalyticsClient(AWSCredentials awsCredentials) {
        this(awsCredentials, configFactory.getConfig());
    }

    @Deprecated
    public AmazonKinesisAnalyticsClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    @Deprecated
    public AmazonKinesisAnalyticsClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, configFactory.getConfig());
    }

    @Deprecated
    public AmazonKinesisAnalyticsClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, null);
    }

    @Deprecated
    public AmazonKinesisAnalyticsClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(clientConfiguration, requestMetricCollector);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    public static AmazonKinesisAnalyticsClientBuilder builder() {
        return AmazonKinesisAnalyticsClientBuilder.standard();
    }

    AmazonKinesisAnalyticsClient(AwsSyncClientParams clientParams) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("https://kinesisanalytics.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/kinesisanalytics/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/kinesisanalytics/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AddApplicationInputResult addApplicationInput(AddApplicationInputRequest addApplicationInputRequest) {
        ExecutionContext executionContext = this.createExecutionContext(addApplicationInputRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<AddApplicationInputRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new AddApplicationInputRequestMarshaller((SdkJsonMarshallerFactory)this.protocolFactory).marshall((AddApplicationInputRequest)super.beforeMarshalling((AmazonWebServiceRequest)addApplicationInputRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new AddApplicationInputResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            AddApplicationInputResult addApplicationInputResult = (AddApplicationInputResult)response.getAwsResponse();
            return addApplicationInputResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AddApplicationOutputResult addApplicationOutput(AddApplicationOutputRequest addApplicationOutputRequest) {
        ExecutionContext executionContext = this.createExecutionContext(addApplicationOutputRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<AddApplicationOutputRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new AddApplicationOutputRequestMarshaller((SdkJsonMarshallerFactory)this.protocolFactory).marshall((AddApplicationOutputRequest)super.beforeMarshalling((AmazonWebServiceRequest)addApplicationOutputRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new AddApplicationOutputResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            AddApplicationOutputResult addApplicationOutputResult = (AddApplicationOutputResult)response.getAwsResponse();
            return addApplicationOutputResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AddApplicationReferenceDataSourceResult addApplicationReferenceDataSource(AddApplicationReferenceDataSourceRequest addApplicationReferenceDataSourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(addApplicationReferenceDataSourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<AddApplicationReferenceDataSourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new AddApplicationReferenceDataSourceRequestMarshaller((SdkJsonMarshallerFactory)this.protocolFactory).marshall((AddApplicationReferenceDataSourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)addApplicationReferenceDataSourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new AddApplicationReferenceDataSourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            AddApplicationReferenceDataSourceResult addApplicationReferenceDataSourceResult = (AddApplicationReferenceDataSourceResult)response.getAwsResponse();
            return addApplicationReferenceDataSourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateApplicationResult createApplication(CreateApplicationRequest createApplicationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createApplicationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateApplicationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateApplicationRequestMarshaller((SdkJsonMarshallerFactory)this.protocolFactory).marshall((CreateApplicationRequest)super.beforeMarshalling((AmazonWebServiceRequest)createApplicationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateApplicationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateApplicationResult createApplicationResult = (CreateApplicationResult)response.getAwsResponse();
            return createApplicationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteApplicationResult deleteApplication(DeleteApplicationRequest deleteApplicationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteApplicationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteApplicationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteApplicationRequestMarshaller((SdkJsonMarshallerFactory)this.protocolFactory).marshall((DeleteApplicationRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteApplicationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteApplicationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteApplicationResult deleteApplicationResult = (DeleteApplicationResult)response.getAwsResponse();
            return deleteApplicationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteApplicationOutputResult deleteApplicationOutput(DeleteApplicationOutputRequest deleteApplicationOutputRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteApplicationOutputRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteApplicationOutputRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteApplicationOutputRequestMarshaller((SdkJsonMarshallerFactory)this.protocolFactory).marshall((DeleteApplicationOutputRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteApplicationOutputRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteApplicationOutputResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteApplicationOutputResult deleteApplicationOutputResult = (DeleteApplicationOutputResult)response.getAwsResponse();
            return deleteApplicationOutputResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteApplicationReferenceDataSourceResult deleteApplicationReferenceDataSource(DeleteApplicationReferenceDataSourceRequest deleteApplicationReferenceDataSourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteApplicationReferenceDataSourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteApplicationReferenceDataSourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteApplicationReferenceDataSourceRequestMarshaller((SdkJsonMarshallerFactory)this.protocolFactory).marshall((DeleteApplicationReferenceDataSourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteApplicationReferenceDataSourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteApplicationReferenceDataSourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteApplicationReferenceDataSourceResult deleteApplicationReferenceDataSourceResult = (DeleteApplicationReferenceDataSourceResult)response.getAwsResponse();
            return deleteApplicationReferenceDataSourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeApplicationResult describeApplication(DescribeApplicationRequest describeApplicationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeApplicationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeApplicationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeApplicationRequestMarshaller((SdkJsonMarshallerFactory)this.protocolFactory).marshall((DescribeApplicationRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeApplicationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeApplicationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeApplicationResult describeApplicationResult = (DescribeApplicationResult)response.getAwsResponse();
            return describeApplicationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DiscoverInputSchemaResult discoverInputSchema(DiscoverInputSchemaRequest discoverInputSchemaRequest) {
        ExecutionContext executionContext = this.createExecutionContext(discoverInputSchemaRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DiscoverInputSchemaRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DiscoverInputSchemaRequestMarshaller((SdkJsonMarshallerFactory)this.protocolFactory).marshall((DiscoverInputSchemaRequest)super.beforeMarshalling((AmazonWebServiceRequest)discoverInputSchemaRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DiscoverInputSchemaResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DiscoverInputSchemaResult discoverInputSchemaResult = (DiscoverInputSchemaResult)response.getAwsResponse();
            return discoverInputSchemaResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListApplicationsResult listApplications(ListApplicationsRequest listApplicationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listApplicationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListApplicationsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListApplicationsRequestMarshaller((SdkJsonMarshallerFactory)this.protocolFactory).marshall((ListApplicationsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listApplicationsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListApplicationsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListApplicationsResult listApplicationsResult = (ListApplicationsResult)response.getAwsResponse();
            return listApplicationsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartApplicationResult startApplication(StartApplicationRequest startApplicationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(startApplicationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StartApplicationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StartApplicationRequestMarshaller((SdkJsonMarshallerFactory)this.protocolFactory).marshall((StartApplicationRequest)super.beforeMarshalling((AmazonWebServiceRequest)startApplicationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StartApplicationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StartApplicationResult startApplicationResult = (StartApplicationResult)response.getAwsResponse();
            return startApplicationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StopApplicationResult stopApplication(StopApplicationRequest stopApplicationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(stopApplicationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StopApplicationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StopApplicationRequestMarshaller((SdkJsonMarshallerFactory)this.protocolFactory).marshall((StopApplicationRequest)super.beforeMarshalling((AmazonWebServiceRequest)stopApplicationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StopApplicationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StopApplicationResult stopApplicationResult = (StopApplicationResult)response.getAwsResponse();
            return stopApplicationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateApplicationResult updateApplication(UpdateApplicationRequest updateApplicationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateApplicationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateApplicationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateApplicationRequestMarshaller((SdkJsonMarshallerFactory)this.protocolFactory).marshall((UpdateApplicationRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateApplicationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateApplicationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateApplicationResult updateApplicationResult = (UpdateApplicationResult)response.getAwsResponse();
            return updateApplicationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }
}

