/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.kinesis.model.SequenceNumberRange;

public class SequenceNumberRangeJsonMarshaller {
    private static SequenceNumberRangeJsonMarshaller instance;

    public void marshall(SequenceNumberRange sequenceNumberRange, StructuredJsonGenerator jsonGenerator) {
        if (sequenceNumberRange == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (sequenceNumberRange.getStartingSequenceNumber() != null) {
                jsonGenerator.writeFieldName("StartingSequenceNumber").writeValue(sequenceNumberRange.getStartingSequenceNumber());
            }
            if (sequenceNumberRange.getEndingSequenceNumber() != null) {
                jsonGenerator.writeFieldName("EndingSequenceNumber").writeValue(sequenceNumberRange.getEndingSequenceNumber());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static SequenceNumberRangeJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new SequenceNumberRangeJsonMarshaller();
        }
        return instance;
    }
}

