/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisfirehose.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.kinesisfirehose.model.RedshiftDestinationUpdate;
import com.amazonaws.services.kinesisfirehose.model.transform.CloudWatchLoggingOptionsJsonMarshaller;
import com.amazonaws.services.kinesisfirehose.model.transform.CopyCommandJsonMarshaller;
import com.amazonaws.services.kinesisfirehose.model.transform.ProcessingConfigurationJsonMarshaller;
import com.amazonaws.services.kinesisfirehose.model.transform.RedshiftRetryOptionsJsonMarshaller;
import com.amazonaws.services.kinesisfirehose.model.transform.S3DestinationUpdateJsonMarshaller;

public class RedshiftDestinationUpdateJsonMarshaller {
    private static RedshiftDestinationUpdateJsonMarshaller instance;

    public void marshall(RedshiftDestinationUpdate redshiftDestinationUpdate, StructuredJsonGenerator jsonGenerator) {
        if (redshiftDestinationUpdate == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (redshiftDestinationUpdate.getRoleARN() != null) {
                jsonGenerator.writeFieldName("RoleARN").writeValue(redshiftDestinationUpdate.getRoleARN());
            }
            if (redshiftDestinationUpdate.getClusterJDBCURL() != null) {
                jsonGenerator.writeFieldName("ClusterJDBCURL").writeValue(redshiftDestinationUpdate.getClusterJDBCURL());
            }
            if (redshiftDestinationUpdate.getCopyCommand() != null) {
                jsonGenerator.writeFieldName("CopyCommand");
                CopyCommandJsonMarshaller.getInstance().marshall(redshiftDestinationUpdate.getCopyCommand(), jsonGenerator);
            }
            if (redshiftDestinationUpdate.getUsername() != null) {
                jsonGenerator.writeFieldName("Username").writeValue(redshiftDestinationUpdate.getUsername());
            }
            if (redshiftDestinationUpdate.getPassword() != null) {
                jsonGenerator.writeFieldName("Password").writeValue(redshiftDestinationUpdate.getPassword());
            }
            if (redshiftDestinationUpdate.getRetryOptions() != null) {
                jsonGenerator.writeFieldName("RetryOptions");
                RedshiftRetryOptionsJsonMarshaller.getInstance().marshall(redshiftDestinationUpdate.getRetryOptions(), jsonGenerator);
            }
            if (redshiftDestinationUpdate.getS3Update() != null) {
                jsonGenerator.writeFieldName("S3Update");
                S3DestinationUpdateJsonMarshaller.getInstance().marshall(redshiftDestinationUpdate.getS3Update(), jsonGenerator);
            }
            if (redshiftDestinationUpdate.getProcessingConfiguration() != null) {
                jsonGenerator.writeFieldName("ProcessingConfiguration");
                ProcessingConfigurationJsonMarshaller.getInstance().marshall(redshiftDestinationUpdate.getProcessingConfiguration(), jsonGenerator);
            }
            if (redshiftDestinationUpdate.getS3BackupMode() != null) {
                jsonGenerator.writeFieldName("S3BackupMode").writeValue(redshiftDestinationUpdate.getS3BackupMode());
            }
            if (redshiftDestinationUpdate.getS3BackupUpdate() != null) {
                jsonGenerator.writeFieldName("S3BackupUpdate");
                S3DestinationUpdateJsonMarshaller.getInstance().marshall(redshiftDestinationUpdate.getS3BackupUpdate(), jsonGenerator);
            }
            if (redshiftDestinationUpdate.getCloudWatchLoggingOptions() != null) {
                jsonGenerator.writeFieldName("CloudWatchLoggingOptions");
                CloudWatchLoggingOptionsJsonMarshaller.getInstance().marshall(redshiftDestinationUpdate.getCloudWatchLoggingOptions(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static RedshiftDestinationUpdateJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new RedshiftDestinationUpdateJsonMarshaller();
        }
        return instance;
    }
}

