/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.waiters;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.kinesis.AmazonKinesis;
import com.amazonaws.services.kinesis.model.DescribeStreamRequest;
import com.amazonaws.services.kinesis.waiters.DescribeStreamFunction;
import com.amazonaws.services.kinesis.waiters.StreamExists;
import com.amazonaws.services.kinesis.waiters.StreamNotExists;
import com.amazonaws.waiters.FixedDelayStrategy;
import com.amazonaws.waiters.MaxAttemptsRetryStrategy;
import com.amazonaws.waiters.PollingStrategy;
import com.amazonaws.waiters.SdkFunction;
import com.amazonaws.waiters.Waiter;
import com.amazonaws.waiters.WaiterAcceptor;
import com.amazonaws.waiters.WaiterBuilder;
import com.amazonaws.waiters.WaiterExecutorServiceFactory;
import java.util.concurrent.ExecutorService;

public class AmazonKinesisWaiters {
    private final AmazonKinesis client;
    private final ExecutorService executorService = WaiterExecutorServiceFactory.buildExecutorServiceForWaiter((String)"AmazonKinesisWaiters");

    @SdkInternalApi
    public AmazonKinesisWaiters(AmazonKinesis client) {
        this.client = client;
    }

    public Waiter<DescribeStreamRequest> streamExists() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeStreamFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new StreamExists.IsACTIVEMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(18), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(10))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeStreamRequest> streamNotExists() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeStreamFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new StreamNotExists.IsResourceNotFoundExceptionMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(18), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(10))).withExecutorService(this.executorService).build();
    }

    public void shutdown() {
        this.executorService.shutdown();
    }
}

