/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.kinesis.model.HashKeyRange;

public class HashKeyRangeJsonMarshaller {
    private static HashKeyRangeJsonMarshaller instance;

    public void marshall(HashKeyRange hashKeyRange, StructuredJsonGenerator jsonGenerator) {
        if (hashKeyRange == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (hashKeyRange.getStartingHashKey() != null) {
                jsonGenerator.writeFieldName("StartingHashKey").writeValue(hashKeyRange.getStartingHashKey());
            }
            if (hashKeyRange.getEndingHashKey() != null) {
                jsonGenerator.writeFieldName("EndingHashKey").writeValue(hashKeyRange.getEndingHashKey());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static HashKeyRangeJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new HashKeyRangeJsonMarshaller();
        }
        return instance;
    }
}

