/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisfirehose.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.kinesisfirehose.model.DescribeDeliveryStreamRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class DescribeDeliveryStreamRequestMarshaller
implements Marshaller<Request<DescribeDeliveryStreamRequest>, DescribeDeliveryStreamRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public DescribeDeliveryStreamRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<DescribeDeliveryStreamRequest> marshall(DescribeDeliveryStreamRequest describeDeliveryStreamRequest) {
        if (describeDeliveryStreamRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeDeliveryStreamRequest, "AmazonKinesisFirehose");
        request.addHeader("X-Amz-Target", "Firehose_20150804.DescribeDeliveryStream");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (describeDeliveryStreamRequest.getDeliveryStreamName() != null) {
                jsonGenerator.writeFieldName("DeliveryStreamName").writeValue(describeDeliveryStreamRequest.getDeliveryStreamName());
            }
            if (describeDeliveryStreamRequest.getLimit() != null) {
                jsonGenerator.writeFieldName("Limit").writeValue(describeDeliveryStreamRequest.getLimit().intValue());
            }
            if (describeDeliveryStreamRequest.getExclusiveStartDestinationId() != null) {
                jsonGenerator.writeFieldName("ExclusiveStartDestinationId").writeValue(describeDeliveryStreamRequest.getExclusiveStartDestinationId());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

