/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisanalytics.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.kinesisanalytics.model.InputUpdate;
import com.amazonaws.services.kinesisanalytics.model.transform.InputParallelismUpdateJsonMarshaller;
import com.amazonaws.services.kinesisanalytics.model.transform.InputSchemaUpdateJsonMarshaller;
import com.amazonaws.services.kinesisanalytics.model.transform.KinesisFirehoseInputUpdateJsonMarshaller;
import com.amazonaws.services.kinesisanalytics.model.transform.KinesisStreamsInputUpdateJsonMarshaller;

public class InputUpdateJsonMarshaller {
    private static InputUpdateJsonMarshaller instance;

    public void marshall(InputUpdate inputUpdate, StructuredJsonGenerator jsonGenerator) {
        if (inputUpdate == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (inputUpdate.getInputId() != null) {
                jsonGenerator.writeFieldName("InputId").writeValue(inputUpdate.getInputId());
            }
            if (inputUpdate.getNamePrefixUpdate() != null) {
                jsonGenerator.writeFieldName("NamePrefixUpdate").writeValue(inputUpdate.getNamePrefixUpdate());
            }
            if (inputUpdate.getKinesisStreamsInputUpdate() != null) {
                jsonGenerator.writeFieldName("KinesisStreamsInputUpdate");
                KinesisStreamsInputUpdateJsonMarshaller.getInstance().marshall(inputUpdate.getKinesisStreamsInputUpdate(), jsonGenerator);
            }
            if (inputUpdate.getKinesisFirehoseInputUpdate() != null) {
                jsonGenerator.writeFieldName("KinesisFirehoseInputUpdate");
                KinesisFirehoseInputUpdateJsonMarshaller.getInstance().marshall(inputUpdate.getKinesisFirehoseInputUpdate(), jsonGenerator);
            }
            if (inputUpdate.getInputSchemaUpdate() != null) {
                jsonGenerator.writeFieldName("InputSchemaUpdate");
                InputSchemaUpdateJsonMarshaller.getInstance().marshall(inputUpdate.getInputSchemaUpdate(), jsonGenerator);
            }
            if (inputUpdate.getInputParallelismUpdate() != null) {
                jsonGenerator.writeFieldName("InputParallelismUpdate");
                InputParallelismUpdateJsonMarshaller.getInstance().marshall(inputUpdate.getInputParallelismUpdate(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static InputUpdateJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new InputUpdateJsonMarshaller();
        }
        return instance;
    }
}

