/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisanalytics;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.kinesisanalytics.AmazonKinesisAnalytics;
import com.amazonaws.services.kinesisanalytics.AmazonKinesisAnalyticsClientBuilder;
import com.amazonaws.services.kinesisanalytics.model.AddApplicationCloudWatchLoggingOptionRequest;
import com.amazonaws.services.kinesisanalytics.model.AddApplicationCloudWatchLoggingOptionResult;
import com.amazonaws.services.kinesisanalytics.model.AddApplicationInputProcessingConfigurationRequest;
import com.amazonaws.services.kinesisanalytics.model.AddApplicationInputProcessingConfigurationResult;
import com.amazonaws.services.kinesisanalytics.model.AddApplicationInputRequest;
import com.amazonaws.services.kinesisanalytics.model.AddApplicationInputResult;
import com.amazonaws.services.kinesisanalytics.model.AddApplicationOutputRequest;
import com.amazonaws.services.kinesisanalytics.model.AddApplicationOutputResult;
import com.amazonaws.services.kinesisanalytics.model.AddApplicationReferenceDataSourceRequest;
import com.amazonaws.services.kinesisanalytics.model.AddApplicationReferenceDataSourceResult;
import com.amazonaws.services.kinesisanalytics.model.AmazonKinesisAnalyticsException;
import com.amazonaws.services.kinesisanalytics.model.CodeValidationException;
import com.amazonaws.services.kinesisanalytics.model.ConcurrentModificationException;
import com.amazonaws.services.kinesisanalytics.model.CreateApplicationRequest;
import com.amazonaws.services.kinesisanalytics.model.CreateApplicationResult;
import com.amazonaws.services.kinesisanalytics.model.DeleteApplicationCloudWatchLoggingOptionRequest;
import com.amazonaws.services.kinesisanalytics.model.DeleteApplicationCloudWatchLoggingOptionResult;
import com.amazonaws.services.kinesisanalytics.model.DeleteApplicationInputProcessingConfigurationRequest;
import com.amazonaws.services.kinesisanalytics.model.DeleteApplicationInputProcessingConfigurationResult;
import com.amazonaws.services.kinesisanalytics.model.DeleteApplicationOutputRequest;
import com.amazonaws.services.kinesisanalytics.model.DeleteApplicationOutputResult;
import com.amazonaws.services.kinesisanalytics.model.DeleteApplicationReferenceDataSourceRequest;
import com.amazonaws.services.kinesisanalytics.model.DeleteApplicationReferenceDataSourceResult;
import com.amazonaws.services.kinesisanalytics.model.DeleteApplicationRequest;
import com.amazonaws.services.kinesisanalytics.model.DeleteApplicationResult;
import com.amazonaws.services.kinesisanalytics.model.DescribeApplicationRequest;
import com.amazonaws.services.kinesisanalytics.model.DescribeApplicationResult;
import com.amazonaws.services.kinesisanalytics.model.DiscoverInputSchemaRequest;
import com.amazonaws.services.kinesisanalytics.model.DiscoverInputSchemaResult;
import com.amazonaws.services.kinesisanalytics.model.InvalidApplicationConfigurationException;
import com.amazonaws.services.kinesisanalytics.model.InvalidArgumentException;
import com.amazonaws.services.kinesisanalytics.model.LimitExceededException;
import com.amazonaws.services.kinesisanalytics.model.ListApplicationsRequest;
import com.amazonaws.services.kinesisanalytics.model.ListApplicationsResult;
import com.amazonaws.services.kinesisanalytics.model.ListTagsForResourceRequest;
import com.amazonaws.services.kinesisanalytics.model.ListTagsForResourceResult;
import com.amazonaws.services.kinesisanalytics.model.ResourceInUseException;
import com.amazonaws.services.kinesisanalytics.model.ResourceNotFoundException;
import com.amazonaws.services.kinesisanalytics.model.ResourceProvisionedThroughputExceededException;
import com.amazonaws.services.kinesisanalytics.model.ServiceUnavailableException;
import com.amazonaws.services.kinesisanalytics.model.StartApplicationRequest;
import com.amazonaws.services.kinesisanalytics.model.StartApplicationResult;
import com.amazonaws.services.kinesisanalytics.model.StopApplicationRequest;
import com.amazonaws.services.kinesisanalytics.model.StopApplicationResult;
import com.amazonaws.services.kinesisanalytics.model.TagResourceRequest;
import com.amazonaws.services.kinesisanalytics.model.TagResourceResult;
import com.amazonaws.services.kinesisanalytics.model.TooManyTagsException;
import com.amazonaws.services.kinesisanalytics.model.UnableToDetectSchemaException;
import com.amazonaws.services.kinesisanalytics.model.UnsupportedOperationException;
import com.amazonaws.services.kinesisanalytics.model.UntagResourceRequest;
import com.amazonaws.services.kinesisanalytics.model.UntagResourceResult;
import com.amazonaws.services.kinesisanalytics.model.UpdateApplicationRequest;
import com.amazonaws.services.kinesisanalytics.model.UpdateApplicationResult;
import com.amazonaws.services.kinesisanalytics.model.transform.AddApplicationCloudWatchLoggingOptionRequestProtocolMarshaller;
import com.amazonaws.services.kinesisanalytics.model.transform.AddApplicationCloudWatchLoggingOptionResultJsonUnmarshaller;
import com.amazonaws.services.kinesisanalytics.model.transform.AddApplicationInputProcessingConfigurationRequestProtocolMarshaller;
import com.amazonaws.services.kinesisanalytics.model.transform.AddApplicationInputProcessingConfigurationResultJsonUnmarshaller;
import com.amazonaws.services.kinesisanalytics.model.transform.AddApplicationInputRequestProtocolMarshaller;
import com.amazonaws.services.kinesisanalytics.model.transform.AddApplicationInputResultJsonUnmarshaller;
import com.amazonaws.services.kinesisanalytics.model.transform.AddApplicationOutputRequestProtocolMarshaller;
import com.amazonaws.services.kinesisanalytics.model.transform.AddApplicationOutputResultJsonUnmarshaller;
import com.amazonaws.services.kinesisanalytics.model.transform.AddApplicationReferenceDataSourceRequestProtocolMarshaller;
import com.amazonaws.services.kinesisanalytics.model.transform.AddApplicationReferenceDataSourceResultJsonUnmarshaller;
import com.amazonaws.services.kinesisanalytics.model.transform.CreateApplicationRequestProtocolMarshaller;
import com.amazonaws.services.kinesisanalytics.model.transform.CreateApplicationResultJsonUnmarshaller;
import com.amazonaws.services.kinesisanalytics.model.transform.DeleteApplicationCloudWatchLoggingOptionRequestProtocolMarshaller;
import com.amazonaws.services.kinesisanalytics.model.transform.DeleteApplicationCloudWatchLoggingOptionResultJsonUnmarshaller;
import com.amazonaws.services.kinesisanalytics.model.transform.DeleteApplicationInputProcessingConfigurationRequestProtocolMarshaller;
import com.amazonaws.services.kinesisanalytics.model.transform.DeleteApplicationInputProcessingConfigurationResultJsonUnmarshaller;
import com.amazonaws.services.kinesisanalytics.model.transform.DeleteApplicationOutputRequestProtocolMarshaller;
import com.amazonaws.services.kinesisanalytics.model.transform.DeleteApplicationOutputResultJsonUnmarshaller;
import com.amazonaws.services.kinesisanalytics.model.transform.DeleteApplicationReferenceDataSourceRequestProtocolMarshaller;
import com.amazonaws.services.kinesisanalytics.model.transform.DeleteApplicationReferenceDataSourceResultJsonUnmarshaller;
import com.amazonaws.services.kinesisanalytics.model.transform.DeleteApplicationRequestProtocolMarshaller;
import com.amazonaws.services.kinesisanalytics.model.transform.DeleteApplicationResultJsonUnmarshaller;
import com.amazonaws.services.kinesisanalytics.model.transform.DescribeApplicationRequestProtocolMarshaller;
import com.amazonaws.services.kinesisanalytics.model.transform.DescribeApplicationResultJsonUnmarshaller;
import com.amazonaws.services.kinesisanalytics.model.transform.DiscoverInputSchemaRequestProtocolMarshaller;
import com.amazonaws.services.kinesisanalytics.model.transform.DiscoverInputSchemaResultJsonUnmarshaller;
import com.amazonaws.services.kinesisanalytics.model.transform.ListApplicationsRequestProtocolMarshaller;
import com.amazonaws.services.kinesisanalytics.model.transform.ListApplicationsResultJsonUnmarshaller;
import com.amazonaws.services.kinesisanalytics.model.transform.ListTagsForResourceRequestProtocolMarshaller;
import com.amazonaws.services.kinesisanalytics.model.transform.ListTagsForResourceResultJsonUnmarshaller;
import com.amazonaws.services.kinesisanalytics.model.transform.StartApplicationRequestProtocolMarshaller;
import com.amazonaws.services.kinesisanalytics.model.transform.StartApplicationResultJsonUnmarshaller;
import com.amazonaws.services.kinesisanalytics.model.transform.StopApplicationRequestProtocolMarshaller;
import com.amazonaws.services.kinesisanalytics.model.transform.StopApplicationResultJsonUnmarshaller;
import com.amazonaws.services.kinesisanalytics.model.transform.TagResourceRequestProtocolMarshaller;
import com.amazonaws.services.kinesisanalytics.model.transform.TagResourceResultJsonUnmarshaller;
import com.amazonaws.services.kinesisanalytics.model.transform.UntagResourceRequestProtocolMarshaller;
import com.amazonaws.services.kinesisanalytics.model.transform.UntagResourceResultJsonUnmarshaller;
import com.amazonaws.services.kinesisanalytics.model.transform.UpdateApplicationRequestProtocolMarshaller;
import com.amazonaws.services.kinesisanalytics.model.transform.UpdateApplicationResultJsonUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AmazonKinesisAnalyticsClient
extends AmazonWebServiceClient
implements AmazonKinesisAnalytics {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonKinesisAnalytics.class);
    private static final String DEFAULT_SIGNING_NAME = "kinesisanalytics";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConcurrentModificationException").withModeledClass(ConcurrentModificationException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("UnableToDetectSchemaException").withModeledClass(UnableToDetectSchemaException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceInUseException").withModeledClass(ResourceInUseException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceProvisionedThroughputExceededException").withModeledClass(ResourceProvisionedThroughputExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LimitExceededException").withModeledClass(LimitExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidApplicationConfigurationException").withModeledClass(InvalidApplicationConfigurationException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("TooManyTagsException").withModeledClass(TooManyTagsException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("CodeValidationException").withModeledClass(CodeValidationException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidArgumentException").withModeledClass(InvalidArgumentException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withModeledClass(ResourceNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("UnsupportedOperationException").withModeledClass(UnsupportedOperationException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceUnavailableException").withModeledClass(ServiceUnavailableException.class)).withBaseServiceExceptionClass(AmazonKinesisAnalyticsException.class));

    @Deprecated
    public AmazonKinesisAnalyticsClient() {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), configFactory.getConfig());
    }

    @Deprecated
    public AmazonKinesisAnalyticsClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration);
    }

    @Deprecated
    public AmazonKinesisAnalyticsClient(AWSCredentials awsCredentials) {
        this(awsCredentials, configFactory.getConfig());
    }

    @Deprecated
    public AmazonKinesisAnalyticsClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.advancedConfig = AdvancedConfig.EMPTY;
        this.init();
    }

    @Deprecated
    public AmazonKinesisAnalyticsClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, configFactory.getConfig());
    }

    @Deprecated
    public AmazonKinesisAnalyticsClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, null);
    }

    @Deprecated
    public AmazonKinesisAnalyticsClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(clientConfiguration, requestMetricCollector);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.advancedConfig = AdvancedConfig.EMPTY;
        this.init();
    }

    public static AmazonKinesisAnalyticsClientBuilder builder() {
        return AmazonKinesisAnalyticsClientBuilder.standard();
    }

    AmazonKinesisAnalyticsClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AmazonKinesisAnalyticsClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("https://kinesisanalytics.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/kinesisanalytics/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/kinesisanalytics/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public AddApplicationCloudWatchLoggingOptionResult addApplicationCloudWatchLoggingOption(AddApplicationCloudWatchLoggingOptionRequest request) {
        request = (AddApplicationCloudWatchLoggingOptionRequest)this.beforeClientExecution(request);
        return this.executeAddApplicationCloudWatchLoggingOption(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final AddApplicationCloudWatchLoggingOptionResult executeAddApplicationCloudWatchLoggingOption(AddApplicationCloudWatchLoggingOptionRequest addApplicationCloudWatchLoggingOptionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(addApplicationCloudWatchLoggingOptionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<AddApplicationCloudWatchLoggingOptionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new AddApplicationCloudWatchLoggingOptionRequestProtocolMarshaller(protocolFactory).marshall((AddApplicationCloudWatchLoggingOptionRequest)super.beforeMarshalling((AmazonWebServiceRequest)addApplicationCloudWatchLoggingOptionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Kinesis Analytics");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"AddApplicationCloudWatchLoggingOption");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new AddApplicationCloudWatchLoggingOptionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            AddApplicationCloudWatchLoggingOptionResult addApplicationCloudWatchLoggingOptionResult = (AddApplicationCloudWatchLoggingOptionResult)response.getAwsResponse();
            return addApplicationCloudWatchLoggingOptionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public AddApplicationInputResult addApplicationInput(AddApplicationInputRequest request) {
        request = (AddApplicationInputRequest)this.beforeClientExecution(request);
        return this.executeAddApplicationInput(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final AddApplicationInputResult executeAddApplicationInput(AddApplicationInputRequest addApplicationInputRequest) {
        ExecutionContext executionContext = this.createExecutionContext(addApplicationInputRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<AddApplicationInputRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new AddApplicationInputRequestProtocolMarshaller(protocolFactory).marshall((AddApplicationInputRequest)super.beforeMarshalling((AmazonWebServiceRequest)addApplicationInputRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Kinesis Analytics");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"AddApplicationInput");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new AddApplicationInputResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            AddApplicationInputResult addApplicationInputResult = (AddApplicationInputResult)response.getAwsResponse();
            return addApplicationInputResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public AddApplicationInputProcessingConfigurationResult addApplicationInputProcessingConfiguration(AddApplicationInputProcessingConfigurationRequest request) {
        request = (AddApplicationInputProcessingConfigurationRequest)this.beforeClientExecution(request);
        return this.executeAddApplicationInputProcessingConfiguration(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final AddApplicationInputProcessingConfigurationResult executeAddApplicationInputProcessingConfiguration(AddApplicationInputProcessingConfigurationRequest addApplicationInputProcessingConfigurationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(addApplicationInputProcessingConfigurationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<AddApplicationInputProcessingConfigurationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new AddApplicationInputProcessingConfigurationRequestProtocolMarshaller(protocolFactory).marshall((AddApplicationInputProcessingConfigurationRequest)super.beforeMarshalling((AmazonWebServiceRequest)addApplicationInputProcessingConfigurationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Kinesis Analytics");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"AddApplicationInputProcessingConfiguration");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new AddApplicationInputProcessingConfigurationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            AddApplicationInputProcessingConfigurationResult addApplicationInputProcessingConfigurationResult = (AddApplicationInputProcessingConfigurationResult)response.getAwsResponse();
            return addApplicationInputProcessingConfigurationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public AddApplicationOutputResult addApplicationOutput(AddApplicationOutputRequest request) {
        request = (AddApplicationOutputRequest)this.beforeClientExecution(request);
        return this.executeAddApplicationOutput(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final AddApplicationOutputResult executeAddApplicationOutput(AddApplicationOutputRequest addApplicationOutputRequest) {
        ExecutionContext executionContext = this.createExecutionContext(addApplicationOutputRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<AddApplicationOutputRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new AddApplicationOutputRequestProtocolMarshaller(protocolFactory).marshall((AddApplicationOutputRequest)super.beforeMarshalling((AmazonWebServiceRequest)addApplicationOutputRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Kinesis Analytics");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"AddApplicationOutput");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new AddApplicationOutputResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            AddApplicationOutputResult addApplicationOutputResult = (AddApplicationOutputResult)response.getAwsResponse();
            return addApplicationOutputResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public AddApplicationReferenceDataSourceResult addApplicationReferenceDataSource(AddApplicationReferenceDataSourceRequest request) {
        request = (AddApplicationReferenceDataSourceRequest)this.beforeClientExecution(request);
        return this.executeAddApplicationReferenceDataSource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final AddApplicationReferenceDataSourceResult executeAddApplicationReferenceDataSource(AddApplicationReferenceDataSourceRequest addApplicationReferenceDataSourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(addApplicationReferenceDataSourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<AddApplicationReferenceDataSourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new AddApplicationReferenceDataSourceRequestProtocolMarshaller(protocolFactory).marshall((AddApplicationReferenceDataSourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)addApplicationReferenceDataSourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Kinesis Analytics");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"AddApplicationReferenceDataSource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new AddApplicationReferenceDataSourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            AddApplicationReferenceDataSourceResult addApplicationReferenceDataSourceResult = (AddApplicationReferenceDataSourceResult)response.getAwsResponse();
            return addApplicationReferenceDataSourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateApplicationResult createApplication(CreateApplicationRequest request) {
        request = (CreateApplicationRequest)this.beforeClientExecution(request);
        return this.executeCreateApplication(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateApplicationResult executeCreateApplication(CreateApplicationRequest createApplicationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createApplicationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateApplicationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateApplicationRequestProtocolMarshaller(protocolFactory).marshall((CreateApplicationRequest)super.beforeMarshalling((AmazonWebServiceRequest)createApplicationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Kinesis Analytics");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateApplication");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateApplicationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateApplicationResult createApplicationResult = (CreateApplicationResult)response.getAwsResponse();
            return createApplicationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteApplicationResult deleteApplication(DeleteApplicationRequest request) {
        request = (DeleteApplicationRequest)this.beforeClientExecution(request);
        return this.executeDeleteApplication(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteApplicationResult executeDeleteApplication(DeleteApplicationRequest deleteApplicationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteApplicationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteApplicationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteApplicationRequestProtocolMarshaller(protocolFactory).marshall((DeleteApplicationRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteApplicationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Kinesis Analytics");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteApplication");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteApplicationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteApplicationResult deleteApplicationResult = (DeleteApplicationResult)response.getAwsResponse();
            return deleteApplicationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteApplicationCloudWatchLoggingOptionResult deleteApplicationCloudWatchLoggingOption(DeleteApplicationCloudWatchLoggingOptionRequest request) {
        request = (DeleteApplicationCloudWatchLoggingOptionRequest)this.beforeClientExecution(request);
        return this.executeDeleteApplicationCloudWatchLoggingOption(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteApplicationCloudWatchLoggingOptionResult executeDeleteApplicationCloudWatchLoggingOption(DeleteApplicationCloudWatchLoggingOptionRequest deleteApplicationCloudWatchLoggingOptionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteApplicationCloudWatchLoggingOptionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteApplicationCloudWatchLoggingOptionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteApplicationCloudWatchLoggingOptionRequestProtocolMarshaller(protocolFactory).marshall((DeleteApplicationCloudWatchLoggingOptionRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteApplicationCloudWatchLoggingOptionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Kinesis Analytics");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteApplicationCloudWatchLoggingOption");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteApplicationCloudWatchLoggingOptionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteApplicationCloudWatchLoggingOptionResult deleteApplicationCloudWatchLoggingOptionResult = (DeleteApplicationCloudWatchLoggingOptionResult)response.getAwsResponse();
            return deleteApplicationCloudWatchLoggingOptionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteApplicationInputProcessingConfigurationResult deleteApplicationInputProcessingConfiguration(DeleteApplicationInputProcessingConfigurationRequest request) {
        request = (DeleteApplicationInputProcessingConfigurationRequest)this.beforeClientExecution(request);
        return this.executeDeleteApplicationInputProcessingConfiguration(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteApplicationInputProcessingConfigurationResult executeDeleteApplicationInputProcessingConfiguration(DeleteApplicationInputProcessingConfigurationRequest deleteApplicationInputProcessingConfigurationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteApplicationInputProcessingConfigurationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteApplicationInputProcessingConfigurationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteApplicationInputProcessingConfigurationRequestProtocolMarshaller(protocolFactory).marshall((DeleteApplicationInputProcessingConfigurationRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteApplicationInputProcessingConfigurationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Kinesis Analytics");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteApplicationInputProcessingConfiguration");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteApplicationInputProcessingConfigurationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteApplicationInputProcessingConfigurationResult deleteApplicationInputProcessingConfigurationResult = (DeleteApplicationInputProcessingConfigurationResult)response.getAwsResponse();
            return deleteApplicationInputProcessingConfigurationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteApplicationOutputResult deleteApplicationOutput(DeleteApplicationOutputRequest request) {
        request = (DeleteApplicationOutputRequest)this.beforeClientExecution(request);
        return this.executeDeleteApplicationOutput(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteApplicationOutputResult executeDeleteApplicationOutput(DeleteApplicationOutputRequest deleteApplicationOutputRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteApplicationOutputRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteApplicationOutputRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteApplicationOutputRequestProtocolMarshaller(protocolFactory).marshall((DeleteApplicationOutputRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteApplicationOutputRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Kinesis Analytics");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteApplicationOutput");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteApplicationOutputResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteApplicationOutputResult deleteApplicationOutputResult = (DeleteApplicationOutputResult)response.getAwsResponse();
            return deleteApplicationOutputResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteApplicationReferenceDataSourceResult deleteApplicationReferenceDataSource(DeleteApplicationReferenceDataSourceRequest request) {
        request = (DeleteApplicationReferenceDataSourceRequest)this.beforeClientExecution(request);
        return this.executeDeleteApplicationReferenceDataSource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteApplicationReferenceDataSourceResult executeDeleteApplicationReferenceDataSource(DeleteApplicationReferenceDataSourceRequest deleteApplicationReferenceDataSourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteApplicationReferenceDataSourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteApplicationReferenceDataSourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteApplicationReferenceDataSourceRequestProtocolMarshaller(protocolFactory).marshall((DeleteApplicationReferenceDataSourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteApplicationReferenceDataSourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Kinesis Analytics");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteApplicationReferenceDataSource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteApplicationReferenceDataSourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteApplicationReferenceDataSourceResult deleteApplicationReferenceDataSourceResult = (DeleteApplicationReferenceDataSourceResult)response.getAwsResponse();
            return deleteApplicationReferenceDataSourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeApplicationResult describeApplication(DescribeApplicationRequest request) {
        request = (DescribeApplicationRequest)this.beforeClientExecution(request);
        return this.executeDescribeApplication(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeApplicationResult executeDescribeApplication(DescribeApplicationRequest describeApplicationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeApplicationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeApplicationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeApplicationRequestProtocolMarshaller(protocolFactory).marshall((DescribeApplicationRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeApplicationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Kinesis Analytics");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeApplication");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeApplicationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeApplicationResult describeApplicationResult = (DescribeApplicationResult)response.getAwsResponse();
            return describeApplicationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DiscoverInputSchemaResult discoverInputSchema(DiscoverInputSchemaRequest request) {
        request = (DiscoverInputSchemaRequest)this.beforeClientExecution(request);
        return this.executeDiscoverInputSchema(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DiscoverInputSchemaResult executeDiscoverInputSchema(DiscoverInputSchemaRequest discoverInputSchemaRequest) {
        ExecutionContext executionContext = this.createExecutionContext(discoverInputSchemaRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DiscoverInputSchemaRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DiscoverInputSchemaRequestProtocolMarshaller(protocolFactory).marshall((DiscoverInputSchemaRequest)super.beforeMarshalling((AmazonWebServiceRequest)discoverInputSchemaRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Kinesis Analytics");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DiscoverInputSchema");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DiscoverInputSchemaResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DiscoverInputSchemaResult discoverInputSchemaResult = (DiscoverInputSchemaResult)response.getAwsResponse();
            return discoverInputSchemaResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListApplicationsResult listApplications(ListApplicationsRequest request) {
        request = (ListApplicationsRequest)this.beforeClientExecution(request);
        return this.executeListApplications(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListApplicationsResult executeListApplications(ListApplicationsRequest listApplicationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listApplicationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListApplicationsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListApplicationsRequestProtocolMarshaller(protocolFactory).marshall((ListApplicationsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listApplicationsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Kinesis Analytics");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListApplications");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListApplicationsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListApplicationsResult listApplicationsResult = (ListApplicationsResult)response.getAwsResponse();
            return listApplicationsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        request = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executeListTagsForResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTagsForResourceResult executeListTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTagsForResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTagsForResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTagsForResourceRequestProtocolMarshaller(protocolFactory).marshall((ListTagsForResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTagsForResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Kinesis Analytics");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListTagsForResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTagsForResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTagsForResourceResult listTagsForResourceResult = (ListTagsForResourceResult)response.getAwsResponse();
            return listTagsForResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StartApplicationResult startApplication(StartApplicationRequest request) {
        request = (StartApplicationRequest)this.beforeClientExecution(request);
        return this.executeStartApplication(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StartApplicationResult executeStartApplication(StartApplicationRequest startApplicationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(startApplicationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StartApplicationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StartApplicationRequestProtocolMarshaller(protocolFactory).marshall((StartApplicationRequest)super.beforeMarshalling((AmazonWebServiceRequest)startApplicationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Kinesis Analytics");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"StartApplication");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StartApplicationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StartApplicationResult startApplicationResult = (StartApplicationResult)response.getAwsResponse();
            return startApplicationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StopApplicationResult stopApplication(StopApplicationRequest request) {
        request = (StopApplicationRequest)this.beforeClientExecution(request);
        return this.executeStopApplication(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StopApplicationResult executeStopApplication(StopApplicationRequest stopApplicationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(stopApplicationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StopApplicationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StopApplicationRequestProtocolMarshaller(protocolFactory).marshall((StopApplicationRequest)super.beforeMarshalling((AmazonWebServiceRequest)stopApplicationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Kinesis Analytics");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"StopApplication");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StopApplicationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StopApplicationResult stopApplicationResult = (StopApplicationResult)response.getAwsResponse();
            return stopApplicationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        request = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executeTagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final TagResourceResult executeTagResource(TagResourceRequest tagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(tagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TagResourceRequestProtocolMarshaller(protocolFactory).marshall((TagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)tagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Kinesis Analytics");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"TagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new TagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            TagResourceResult tagResourceResult = (TagResourceResult)response.getAwsResponse();
            return tagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        request = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executeUntagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UntagResourceResult executeUntagResource(UntagResourceRequest untagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(untagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UntagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UntagResourceRequestProtocolMarshaller(protocolFactory).marshall((UntagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)untagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Kinesis Analytics");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UntagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UntagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UntagResourceResult untagResourceResult = (UntagResourceResult)response.getAwsResponse();
            return untagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateApplicationResult updateApplication(UpdateApplicationRequest request) {
        request = (UpdateApplicationRequest)this.beforeClientExecution(request);
        return this.executeUpdateApplication(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateApplicationResult executeUpdateApplication(UpdateApplicationRequest updateApplicationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateApplicationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateApplicationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateApplicationRequestProtocolMarshaller(protocolFactory).marshall((UpdateApplicationRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateApplicationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Kinesis Analytics");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateApplication");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateApplicationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateApplicationResult updateApplicationResult = (UpdateApplicationResult)response.getAwsResponse();
            return updateApplicationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }
}

