/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisanalytics.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.kinesisanalytics.model.RecordColumn;
import com.amazonaws.services.kinesisanalytics.model.SourceSchema;
import com.amazonaws.services.kinesisanalytics.model.transform.RecordColumnJsonMarshaller;
import com.amazonaws.services.kinesisanalytics.model.transform.RecordFormatJsonMarshaller;
import java.util.List;

public class SourceSchemaJsonMarshaller {
    private static SourceSchemaJsonMarshaller instance;

    public void marshall(SourceSchema sourceSchema, StructuredJsonGenerator jsonGenerator) {
        if (sourceSchema == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<RecordColumn> recordColumnsList;
            jsonGenerator.writeStartObject();
            if (sourceSchema.getRecordFormat() != null) {
                jsonGenerator.writeFieldName("RecordFormat");
                RecordFormatJsonMarshaller.getInstance().marshall(sourceSchema.getRecordFormat(), jsonGenerator);
            }
            if (sourceSchema.getRecordEncoding() != null) {
                jsonGenerator.writeFieldName("RecordEncoding").writeValue(sourceSchema.getRecordEncoding());
            }
            if ((recordColumnsList = sourceSchema.getRecordColumns()) != null) {
                jsonGenerator.writeFieldName("RecordColumns");
                jsonGenerator.writeStartArray();
                for (RecordColumn recordColumnsListValue : recordColumnsList) {
                    if (recordColumnsListValue == null) continue;
                    RecordColumnJsonMarshaller.getInstance().marshall(recordColumnsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static SourceSchemaJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new SourceSchemaJsonMarshaller();
        }
        return instance;
    }
}

