/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.kinesis.AmazonKinesis;
import com.amazonaws.services.kinesis.AmazonKinesisClientBuilder;
import com.amazonaws.services.kinesis.model.AddTagsToStreamRequest;
import com.amazonaws.services.kinesis.model.AddTagsToStreamResult;
import com.amazonaws.services.kinesis.model.AmazonKinesisException;
import com.amazonaws.services.kinesis.model.CreateStreamRequest;
import com.amazonaws.services.kinesis.model.CreateStreamResult;
import com.amazonaws.services.kinesis.model.DecreaseStreamRetentionPeriodRequest;
import com.amazonaws.services.kinesis.model.DecreaseStreamRetentionPeriodResult;
import com.amazonaws.services.kinesis.model.DeleteStreamRequest;
import com.amazonaws.services.kinesis.model.DeleteStreamResult;
import com.amazonaws.services.kinesis.model.DescribeLimitsRequest;
import com.amazonaws.services.kinesis.model.DescribeLimitsResult;
import com.amazonaws.services.kinesis.model.DescribeStreamRequest;
import com.amazonaws.services.kinesis.model.DescribeStreamResult;
import com.amazonaws.services.kinesis.model.DisableEnhancedMonitoringRequest;
import com.amazonaws.services.kinesis.model.DisableEnhancedMonitoringResult;
import com.amazonaws.services.kinesis.model.EnableEnhancedMonitoringRequest;
import com.amazonaws.services.kinesis.model.EnableEnhancedMonitoringResult;
import com.amazonaws.services.kinesis.model.ExpiredIteratorException;
import com.amazonaws.services.kinesis.model.GetRecordsRequest;
import com.amazonaws.services.kinesis.model.GetRecordsResult;
import com.amazonaws.services.kinesis.model.GetShardIteratorRequest;
import com.amazonaws.services.kinesis.model.GetShardIteratorResult;
import com.amazonaws.services.kinesis.model.IncreaseStreamRetentionPeriodRequest;
import com.amazonaws.services.kinesis.model.IncreaseStreamRetentionPeriodResult;
import com.amazonaws.services.kinesis.model.InvalidArgumentException;
import com.amazonaws.services.kinesis.model.KMSAccessDeniedException;
import com.amazonaws.services.kinesis.model.KMSDisabledException;
import com.amazonaws.services.kinesis.model.KMSInvalidStateException;
import com.amazonaws.services.kinesis.model.KMSNotFoundException;
import com.amazonaws.services.kinesis.model.KMSOptInRequiredException;
import com.amazonaws.services.kinesis.model.KMSThrottlingException;
import com.amazonaws.services.kinesis.model.LimitExceededException;
import com.amazonaws.services.kinesis.model.ListStreamsRequest;
import com.amazonaws.services.kinesis.model.ListStreamsResult;
import com.amazonaws.services.kinesis.model.ListTagsForStreamRequest;
import com.amazonaws.services.kinesis.model.ListTagsForStreamResult;
import com.amazonaws.services.kinesis.model.MergeShardsRequest;
import com.amazonaws.services.kinesis.model.MergeShardsResult;
import com.amazonaws.services.kinesis.model.ProvisionedThroughputExceededException;
import com.amazonaws.services.kinesis.model.PutRecordRequest;
import com.amazonaws.services.kinesis.model.PutRecordResult;
import com.amazonaws.services.kinesis.model.PutRecordsRequest;
import com.amazonaws.services.kinesis.model.PutRecordsResult;
import com.amazonaws.services.kinesis.model.RemoveTagsFromStreamRequest;
import com.amazonaws.services.kinesis.model.RemoveTagsFromStreamResult;
import com.amazonaws.services.kinesis.model.ResourceInUseException;
import com.amazonaws.services.kinesis.model.ResourceNotFoundException;
import com.amazonaws.services.kinesis.model.SplitShardRequest;
import com.amazonaws.services.kinesis.model.SplitShardResult;
import com.amazonaws.services.kinesis.model.StartStreamEncryptionRequest;
import com.amazonaws.services.kinesis.model.StartStreamEncryptionResult;
import com.amazonaws.services.kinesis.model.StopStreamEncryptionRequest;
import com.amazonaws.services.kinesis.model.StopStreamEncryptionResult;
import com.amazonaws.services.kinesis.model.UpdateShardCountRequest;
import com.amazonaws.services.kinesis.model.UpdateShardCountResult;
import com.amazonaws.services.kinesis.model.transform.AddTagsToStreamRequestProtocolMarshaller;
import com.amazonaws.services.kinesis.model.transform.AddTagsToStreamResultJsonUnmarshaller;
import com.amazonaws.services.kinesis.model.transform.CreateStreamRequestProtocolMarshaller;
import com.amazonaws.services.kinesis.model.transform.CreateStreamResultJsonUnmarshaller;
import com.amazonaws.services.kinesis.model.transform.DecreaseStreamRetentionPeriodRequestProtocolMarshaller;
import com.amazonaws.services.kinesis.model.transform.DecreaseStreamRetentionPeriodResultJsonUnmarshaller;
import com.amazonaws.services.kinesis.model.transform.DeleteStreamRequestProtocolMarshaller;
import com.amazonaws.services.kinesis.model.transform.DeleteStreamResultJsonUnmarshaller;
import com.amazonaws.services.kinesis.model.transform.DescribeLimitsRequestProtocolMarshaller;
import com.amazonaws.services.kinesis.model.transform.DescribeLimitsResultJsonUnmarshaller;
import com.amazonaws.services.kinesis.model.transform.DescribeStreamRequestProtocolMarshaller;
import com.amazonaws.services.kinesis.model.transform.DescribeStreamResultJsonUnmarshaller;
import com.amazonaws.services.kinesis.model.transform.DisableEnhancedMonitoringRequestProtocolMarshaller;
import com.amazonaws.services.kinesis.model.transform.DisableEnhancedMonitoringResultJsonUnmarshaller;
import com.amazonaws.services.kinesis.model.transform.EnableEnhancedMonitoringRequestProtocolMarshaller;
import com.amazonaws.services.kinesis.model.transform.EnableEnhancedMonitoringResultJsonUnmarshaller;
import com.amazonaws.services.kinesis.model.transform.GetRecordsRequestProtocolMarshaller;
import com.amazonaws.services.kinesis.model.transform.GetRecordsResultJsonUnmarshaller;
import com.amazonaws.services.kinesis.model.transform.GetShardIteratorRequestProtocolMarshaller;
import com.amazonaws.services.kinesis.model.transform.GetShardIteratorResultJsonUnmarshaller;
import com.amazonaws.services.kinesis.model.transform.IncreaseStreamRetentionPeriodRequestProtocolMarshaller;
import com.amazonaws.services.kinesis.model.transform.IncreaseStreamRetentionPeriodResultJsonUnmarshaller;
import com.amazonaws.services.kinesis.model.transform.ListStreamsRequestProtocolMarshaller;
import com.amazonaws.services.kinesis.model.transform.ListStreamsResultJsonUnmarshaller;
import com.amazonaws.services.kinesis.model.transform.ListTagsForStreamRequestProtocolMarshaller;
import com.amazonaws.services.kinesis.model.transform.ListTagsForStreamResultJsonUnmarshaller;
import com.amazonaws.services.kinesis.model.transform.MergeShardsRequestProtocolMarshaller;
import com.amazonaws.services.kinesis.model.transform.MergeShardsResultJsonUnmarshaller;
import com.amazonaws.services.kinesis.model.transform.PutRecordRequestProtocolMarshaller;
import com.amazonaws.services.kinesis.model.transform.PutRecordResultJsonUnmarshaller;
import com.amazonaws.services.kinesis.model.transform.PutRecordsRequestProtocolMarshaller;
import com.amazonaws.services.kinesis.model.transform.PutRecordsResultJsonUnmarshaller;
import com.amazonaws.services.kinesis.model.transform.RemoveTagsFromStreamRequestProtocolMarshaller;
import com.amazonaws.services.kinesis.model.transform.RemoveTagsFromStreamResultJsonUnmarshaller;
import com.amazonaws.services.kinesis.model.transform.SplitShardRequestProtocolMarshaller;
import com.amazonaws.services.kinesis.model.transform.SplitShardResultJsonUnmarshaller;
import com.amazonaws.services.kinesis.model.transform.StartStreamEncryptionRequestProtocolMarshaller;
import com.amazonaws.services.kinesis.model.transform.StartStreamEncryptionResultJsonUnmarshaller;
import com.amazonaws.services.kinesis.model.transform.StopStreamEncryptionRequestProtocolMarshaller;
import com.amazonaws.services.kinesis.model.transform.StopStreamEncryptionResultJsonUnmarshaller;
import com.amazonaws.services.kinesis.model.transform.UpdateShardCountRequestProtocolMarshaller;
import com.amazonaws.services.kinesis.model.transform.UpdateShardCountResultJsonUnmarshaller;
import com.amazonaws.services.kinesis.waiters.AmazonKinesisWaiters;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.nio.ByteBuffer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AmazonKinesisClient
extends AmazonWebServiceClient
implements AmazonKinesis {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonKinesis.class);
    private static final String DEFAULT_SIGNING_NAME = "kinesis";
    private volatile AmazonKinesisWaiters waiters;
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(true).withSupportsIon(false).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidArgumentException").withModeledClass(InvalidArgumentException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceInUseException").withModeledClass(ResourceInUseException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("KMSOptInRequired").withModeledClass(KMSOptInRequiredException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withModeledClass(ResourceNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ExpiredIteratorException").withModeledClass(ExpiredIteratorException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("KMSAccessDeniedException").withModeledClass(KMSAccessDeniedException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("KMSInvalidStateException").withModeledClass(KMSInvalidStateException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("KMSDisabledException").withModeledClass(KMSDisabledException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("KMSNotFoundException").withModeledClass(KMSNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ProvisionedThroughputExceededException").withModeledClass(ProvisionedThroughputExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("KMSThrottlingException").withModeledClass(KMSThrottlingException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LimitExceededException").withModeledClass(LimitExceededException.class)).withBaseServiceExceptionClass(AmazonKinesisException.class));

    @Deprecated
    public AmazonKinesisClient() {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), configFactory.getConfig());
    }

    @Deprecated
    public AmazonKinesisClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration);
    }

    @Deprecated
    public AmazonKinesisClient(AWSCredentials awsCredentials) {
        this(awsCredentials, configFactory.getConfig());
    }

    @Deprecated
    public AmazonKinesisClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    @Deprecated
    public AmazonKinesisClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, configFactory.getConfig());
    }

    @Deprecated
    public AmazonKinesisClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, null);
    }

    @Deprecated
    public AmazonKinesisClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(clientConfiguration, requestMetricCollector);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    public static AmazonKinesisClientBuilder builder() {
        return AmazonKinesisClientBuilder.standard();
    }

    AmazonKinesisClient(AwsSyncClientParams clientParams) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("https://kinesis.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/kinesis/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/kinesis/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public AddTagsToStreamResult addTagsToStream(AddTagsToStreamRequest request) {
        request = (AddTagsToStreamRequest)this.beforeClientExecution(request);
        return this.executeAddTagsToStream(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final AddTagsToStreamResult executeAddTagsToStream(AddTagsToStreamRequest addTagsToStreamRequest) {
        ExecutionContext executionContext = this.createExecutionContext(addTagsToStreamRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<AddTagsToStreamRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new AddTagsToStreamRequestProtocolMarshaller(this.protocolFactory).marshall((AddTagsToStreamRequest)super.beforeMarshalling((AmazonWebServiceRequest)addTagsToStreamRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new AddTagsToStreamResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            AddTagsToStreamResult addTagsToStreamResult = (AddTagsToStreamResult)response.getAwsResponse();
            return addTagsToStreamResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateStreamResult createStream(CreateStreamRequest request) {
        request = (CreateStreamRequest)this.beforeClientExecution(request);
        return this.executeCreateStream(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateStreamResult executeCreateStream(CreateStreamRequest createStreamRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createStreamRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateStreamRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateStreamRequestProtocolMarshaller(this.protocolFactory).marshall((CreateStreamRequest)super.beforeMarshalling((AmazonWebServiceRequest)createStreamRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateStreamResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateStreamResult createStreamResult = (CreateStreamResult)response.getAwsResponse();
            return createStreamResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateStreamResult createStream(String streamName, Integer shardCount) {
        return this.createStream(new CreateStreamRequest().withStreamName(streamName).withShardCount(shardCount));
    }

    @Override
    public DecreaseStreamRetentionPeriodResult decreaseStreamRetentionPeriod(DecreaseStreamRetentionPeriodRequest request) {
        request = (DecreaseStreamRetentionPeriodRequest)this.beforeClientExecution(request);
        return this.executeDecreaseStreamRetentionPeriod(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DecreaseStreamRetentionPeriodResult executeDecreaseStreamRetentionPeriod(DecreaseStreamRetentionPeriodRequest decreaseStreamRetentionPeriodRequest) {
        ExecutionContext executionContext = this.createExecutionContext(decreaseStreamRetentionPeriodRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DecreaseStreamRetentionPeriodRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DecreaseStreamRetentionPeriodRequestProtocolMarshaller(this.protocolFactory).marshall((DecreaseStreamRetentionPeriodRequest)super.beforeMarshalling((AmazonWebServiceRequest)decreaseStreamRetentionPeriodRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DecreaseStreamRetentionPeriodResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DecreaseStreamRetentionPeriodResult decreaseStreamRetentionPeriodResult = (DecreaseStreamRetentionPeriodResult)response.getAwsResponse();
            return decreaseStreamRetentionPeriodResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteStreamResult deleteStream(DeleteStreamRequest request) {
        request = (DeleteStreamRequest)this.beforeClientExecution(request);
        return this.executeDeleteStream(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteStreamResult executeDeleteStream(DeleteStreamRequest deleteStreamRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteStreamRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteStreamRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteStreamRequestProtocolMarshaller(this.protocolFactory).marshall((DeleteStreamRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteStreamRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteStreamResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteStreamResult deleteStreamResult = (DeleteStreamResult)response.getAwsResponse();
            return deleteStreamResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteStreamResult deleteStream(String streamName) {
        return this.deleteStream(new DeleteStreamRequest().withStreamName(streamName));
    }

    @Override
    public DescribeLimitsResult describeLimits(DescribeLimitsRequest request) {
        request = (DescribeLimitsRequest)this.beforeClientExecution(request);
        return this.executeDescribeLimits(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeLimitsResult executeDescribeLimits(DescribeLimitsRequest describeLimitsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeLimitsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeLimitsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeLimitsRequestProtocolMarshaller(this.protocolFactory).marshall((DescribeLimitsRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeLimitsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeLimitsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeLimitsResult describeLimitsResult = (DescribeLimitsResult)response.getAwsResponse();
            return describeLimitsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeStreamResult describeStream(DescribeStreamRequest request) {
        request = (DescribeStreamRequest)this.beforeClientExecution(request);
        return this.executeDescribeStream(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeStreamResult executeDescribeStream(DescribeStreamRequest describeStreamRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeStreamRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeStreamRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeStreamRequestProtocolMarshaller(this.protocolFactory).marshall((DescribeStreamRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeStreamRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeStreamResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeStreamResult describeStreamResult = (DescribeStreamResult)response.getAwsResponse();
            return describeStreamResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeStreamResult describeStream(String streamName) {
        return this.describeStream(new DescribeStreamRequest().withStreamName(streamName));
    }

    @Override
    public DescribeStreamResult describeStream(String streamName, String exclusiveStartShardId) {
        return this.describeStream(new DescribeStreamRequest().withStreamName(streamName).withExclusiveStartShardId(exclusiveStartShardId));
    }

    @Override
    public DescribeStreamResult describeStream(String streamName, Integer limit, String exclusiveStartShardId) {
        return this.describeStream(new DescribeStreamRequest().withStreamName(streamName).withLimit(limit).withExclusiveStartShardId(exclusiveStartShardId));
    }

    @Override
    public DisableEnhancedMonitoringResult disableEnhancedMonitoring(DisableEnhancedMonitoringRequest request) {
        request = (DisableEnhancedMonitoringRequest)this.beforeClientExecution(request);
        return this.executeDisableEnhancedMonitoring(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DisableEnhancedMonitoringResult executeDisableEnhancedMonitoring(DisableEnhancedMonitoringRequest disableEnhancedMonitoringRequest) {
        ExecutionContext executionContext = this.createExecutionContext(disableEnhancedMonitoringRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DisableEnhancedMonitoringRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DisableEnhancedMonitoringRequestProtocolMarshaller(this.protocolFactory).marshall((DisableEnhancedMonitoringRequest)super.beforeMarshalling((AmazonWebServiceRequest)disableEnhancedMonitoringRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DisableEnhancedMonitoringResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DisableEnhancedMonitoringResult disableEnhancedMonitoringResult = (DisableEnhancedMonitoringResult)response.getAwsResponse();
            return disableEnhancedMonitoringResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public EnableEnhancedMonitoringResult enableEnhancedMonitoring(EnableEnhancedMonitoringRequest request) {
        request = (EnableEnhancedMonitoringRequest)this.beforeClientExecution(request);
        return this.executeEnableEnhancedMonitoring(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final EnableEnhancedMonitoringResult executeEnableEnhancedMonitoring(EnableEnhancedMonitoringRequest enableEnhancedMonitoringRequest) {
        ExecutionContext executionContext = this.createExecutionContext(enableEnhancedMonitoringRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<EnableEnhancedMonitoringRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new EnableEnhancedMonitoringRequestProtocolMarshaller(this.protocolFactory).marshall((EnableEnhancedMonitoringRequest)super.beforeMarshalling((AmazonWebServiceRequest)enableEnhancedMonitoringRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new EnableEnhancedMonitoringResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            EnableEnhancedMonitoringResult enableEnhancedMonitoringResult = (EnableEnhancedMonitoringResult)response.getAwsResponse();
            return enableEnhancedMonitoringResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetRecordsResult getRecords(GetRecordsRequest request) {
        request = (GetRecordsRequest)this.beforeClientExecution(request);
        return this.executeGetRecords(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetRecordsResult executeGetRecords(GetRecordsRequest getRecordsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getRecordsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetRecordsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetRecordsRequestProtocolMarshaller(this.protocolFactory).marshall((GetRecordsRequest)super.beforeMarshalling((AmazonWebServiceRequest)getRecordsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetRecordsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetRecordsResult getRecordsResult = (GetRecordsResult)response.getAwsResponse();
            return getRecordsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetShardIteratorResult getShardIterator(GetShardIteratorRequest request) {
        request = (GetShardIteratorRequest)this.beforeClientExecution(request);
        return this.executeGetShardIterator(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetShardIteratorResult executeGetShardIterator(GetShardIteratorRequest getShardIteratorRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getShardIteratorRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetShardIteratorRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetShardIteratorRequestProtocolMarshaller(this.protocolFactory).marshall((GetShardIteratorRequest)super.beforeMarshalling((AmazonWebServiceRequest)getShardIteratorRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetShardIteratorResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetShardIteratorResult getShardIteratorResult = (GetShardIteratorResult)response.getAwsResponse();
            return getShardIteratorResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetShardIteratorResult getShardIterator(String streamName, String shardId, String shardIteratorType) {
        return this.getShardIterator(new GetShardIteratorRequest().withStreamName(streamName).withShardId(shardId).withShardIteratorType(shardIteratorType));
    }

    @Override
    public GetShardIteratorResult getShardIterator(String streamName, String shardId, String shardIteratorType, String startingSequenceNumber) {
        return this.getShardIterator(new GetShardIteratorRequest().withStreamName(streamName).withShardId(shardId).withShardIteratorType(shardIteratorType).withStartingSequenceNumber(startingSequenceNumber));
    }

    @Override
    public IncreaseStreamRetentionPeriodResult increaseStreamRetentionPeriod(IncreaseStreamRetentionPeriodRequest request) {
        request = (IncreaseStreamRetentionPeriodRequest)this.beforeClientExecution(request);
        return this.executeIncreaseStreamRetentionPeriod(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final IncreaseStreamRetentionPeriodResult executeIncreaseStreamRetentionPeriod(IncreaseStreamRetentionPeriodRequest increaseStreamRetentionPeriodRequest) {
        ExecutionContext executionContext = this.createExecutionContext(increaseStreamRetentionPeriodRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<IncreaseStreamRetentionPeriodRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new IncreaseStreamRetentionPeriodRequestProtocolMarshaller(this.protocolFactory).marshall((IncreaseStreamRetentionPeriodRequest)super.beforeMarshalling((AmazonWebServiceRequest)increaseStreamRetentionPeriodRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new IncreaseStreamRetentionPeriodResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            IncreaseStreamRetentionPeriodResult increaseStreamRetentionPeriodResult = (IncreaseStreamRetentionPeriodResult)response.getAwsResponse();
            return increaseStreamRetentionPeriodResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListStreamsResult listStreams(ListStreamsRequest request) {
        request = (ListStreamsRequest)this.beforeClientExecution(request);
        return this.executeListStreams(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListStreamsResult executeListStreams(ListStreamsRequest listStreamsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listStreamsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListStreamsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListStreamsRequestProtocolMarshaller(this.protocolFactory).marshall((ListStreamsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listStreamsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListStreamsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListStreamsResult listStreamsResult = (ListStreamsResult)response.getAwsResponse();
            return listStreamsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListStreamsResult listStreams() {
        return this.listStreams(new ListStreamsRequest());
    }

    @Override
    public ListStreamsResult listStreams(String exclusiveStartStreamName) {
        return this.listStreams(new ListStreamsRequest().withExclusiveStartStreamName(exclusiveStartStreamName));
    }

    @Override
    public ListStreamsResult listStreams(Integer limit, String exclusiveStartStreamName) {
        return this.listStreams(new ListStreamsRequest().withLimit(limit).withExclusiveStartStreamName(exclusiveStartStreamName));
    }

    @Override
    public ListTagsForStreamResult listTagsForStream(ListTagsForStreamRequest request) {
        request = (ListTagsForStreamRequest)this.beforeClientExecution(request);
        return this.executeListTagsForStream(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTagsForStreamResult executeListTagsForStream(ListTagsForStreamRequest listTagsForStreamRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTagsForStreamRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTagsForStreamRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTagsForStreamRequestProtocolMarshaller(this.protocolFactory).marshall((ListTagsForStreamRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTagsForStreamRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTagsForStreamResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTagsForStreamResult listTagsForStreamResult = (ListTagsForStreamResult)response.getAwsResponse();
            return listTagsForStreamResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public MergeShardsResult mergeShards(MergeShardsRequest request) {
        request = (MergeShardsRequest)this.beforeClientExecution(request);
        return this.executeMergeShards(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final MergeShardsResult executeMergeShards(MergeShardsRequest mergeShardsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(mergeShardsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<MergeShardsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new MergeShardsRequestProtocolMarshaller(this.protocolFactory).marshall((MergeShardsRequest)super.beforeMarshalling((AmazonWebServiceRequest)mergeShardsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new MergeShardsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            MergeShardsResult mergeShardsResult = (MergeShardsResult)response.getAwsResponse();
            return mergeShardsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public MergeShardsResult mergeShards(String streamName, String shardToMerge, String adjacentShardToMerge) {
        return this.mergeShards(new MergeShardsRequest().withStreamName(streamName).withShardToMerge(shardToMerge).withAdjacentShardToMerge(adjacentShardToMerge));
    }

    @Override
    public PutRecordResult putRecord(PutRecordRequest request) {
        request = (PutRecordRequest)this.beforeClientExecution(request);
        return this.executePutRecord(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutRecordResult executePutRecord(PutRecordRequest putRecordRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putRecordRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutRecordRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutRecordRequestProtocolMarshaller(this.protocolFactory).marshall((PutRecordRequest)super.beforeMarshalling((AmazonWebServiceRequest)putRecordRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PutRecordResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PutRecordResult putRecordResult = (PutRecordResult)response.getAwsResponse();
            return putRecordResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutRecordResult putRecord(String streamName, ByteBuffer data, String partitionKey) {
        return this.putRecord(new PutRecordRequest().withStreamName(streamName).withData(data).withPartitionKey(partitionKey));
    }

    @Override
    public PutRecordResult putRecord(String streamName, ByteBuffer data, String partitionKey, String sequenceNumberForOrdering) {
        return this.putRecord(new PutRecordRequest().withStreamName(streamName).withData(data).withPartitionKey(partitionKey).withSequenceNumberForOrdering(sequenceNumberForOrdering));
    }

    @Override
    public PutRecordsResult putRecords(PutRecordsRequest request) {
        request = (PutRecordsRequest)this.beforeClientExecution(request);
        return this.executePutRecords(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutRecordsResult executePutRecords(PutRecordsRequest putRecordsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putRecordsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutRecordsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutRecordsRequestProtocolMarshaller(this.protocolFactory).marshall((PutRecordsRequest)super.beforeMarshalling((AmazonWebServiceRequest)putRecordsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PutRecordsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PutRecordsResult putRecordsResult = (PutRecordsResult)response.getAwsResponse();
            return putRecordsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public RemoveTagsFromStreamResult removeTagsFromStream(RemoveTagsFromStreamRequest request) {
        request = (RemoveTagsFromStreamRequest)this.beforeClientExecution(request);
        return this.executeRemoveTagsFromStream(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final RemoveTagsFromStreamResult executeRemoveTagsFromStream(RemoveTagsFromStreamRequest removeTagsFromStreamRequest) {
        ExecutionContext executionContext = this.createExecutionContext(removeTagsFromStreamRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<RemoveTagsFromStreamRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new RemoveTagsFromStreamRequestProtocolMarshaller(this.protocolFactory).marshall((RemoveTagsFromStreamRequest)super.beforeMarshalling((AmazonWebServiceRequest)removeTagsFromStreamRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new RemoveTagsFromStreamResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            RemoveTagsFromStreamResult removeTagsFromStreamResult = (RemoveTagsFromStreamResult)response.getAwsResponse();
            return removeTagsFromStreamResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public SplitShardResult splitShard(SplitShardRequest request) {
        request = (SplitShardRequest)this.beforeClientExecution(request);
        return this.executeSplitShard(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final SplitShardResult executeSplitShard(SplitShardRequest splitShardRequest) {
        ExecutionContext executionContext = this.createExecutionContext(splitShardRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<SplitShardRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new SplitShardRequestProtocolMarshaller(this.protocolFactory).marshall((SplitShardRequest)super.beforeMarshalling((AmazonWebServiceRequest)splitShardRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new SplitShardResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            SplitShardResult splitShardResult = (SplitShardResult)response.getAwsResponse();
            return splitShardResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public SplitShardResult splitShard(String streamName, String shardToSplit, String newStartingHashKey) {
        return this.splitShard(new SplitShardRequest().withStreamName(streamName).withShardToSplit(shardToSplit).withNewStartingHashKey(newStartingHashKey));
    }

    @Override
    public StartStreamEncryptionResult startStreamEncryption(StartStreamEncryptionRequest request) {
        request = (StartStreamEncryptionRequest)this.beforeClientExecution(request);
        return this.executeStartStreamEncryption(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StartStreamEncryptionResult executeStartStreamEncryption(StartStreamEncryptionRequest startStreamEncryptionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(startStreamEncryptionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StartStreamEncryptionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StartStreamEncryptionRequestProtocolMarshaller(this.protocolFactory).marshall((StartStreamEncryptionRequest)super.beforeMarshalling((AmazonWebServiceRequest)startStreamEncryptionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StartStreamEncryptionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StartStreamEncryptionResult startStreamEncryptionResult = (StartStreamEncryptionResult)response.getAwsResponse();
            return startStreamEncryptionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StopStreamEncryptionResult stopStreamEncryption(StopStreamEncryptionRequest request) {
        request = (StopStreamEncryptionRequest)this.beforeClientExecution(request);
        return this.executeStopStreamEncryption(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StopStreamEncryptionResult executeStopStreamEncryption(StopStreamEncryptionRequest stopStreamEncryptionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(stopStreamEncryptionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StopStreamEncryptionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StopStreamEncryptionRequestProtocolMarshaller(this.protocolFactory).marshall((StopStreamEncryptionRequest)super.beforeMarshalling((AmazonWebServiceRequest)stopStreamEncryptionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StopStreamEncryptionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StopStreamEncryptionResult stopStreamEncryptionResult = (StopStreamEncryptionResult)response.getAwsResponse();
            return stopStreamEncryptionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateShardCountResult updateShardCount(UpdateShardCountRequest request) {
        request = (UpdateShardCountRequest)this.beforeClientExecution(request);
        return this.executeUpdateShardCount(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateShardCountResult executeUpdateShardCount(UpdateShardCountRequest updateShardCountRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateShardCountRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateShardCountRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateShardCountRequestProtocolMarshaller(this.protocolFactory).marshall((UpdateShardCountRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateShardCountRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateShardCountResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateShardCountResult updateShardCountResult = (UpdateShardCountResult)response.getAwsResponse();
            return updateShardCountResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AmazonKinesisWaiters waiters() {
        if (this.waiters == null) {
            AmazonKinesisClient amazonKinesisClient = this;
            synchronized (amazonKinesisClient) {
                if (this.waiters == null) {
                    this.waiters = new AmazonKinesisWaiters(this);
                }
            }
        }
        return this.waiters;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        if (this.waiters != null) {
            this.waiters.shutdown();
        }
    }
}

