/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisfirehose.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.kinesisfirehose.model.EncryptionConfiguration;
import com.amazonaws.services.kinesisfirehose.model.transform.KMSEncryptionConfigJsonMarshaller;
import com.amazonaws.util.json.StructuredJsonGenerator;

public class EncryptionConfigurationJsonMarshaller {
    private static EncryptionConfigurationJsonMarshaller instance;

    public void marshall(EncryptionConfiguration encryptionConfiguration, StructuredJsonGenerator jsonGenerator) {
        if (encryptionConfiguration == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (encryptionConfiguration.getNoEncryptionConfig() != null) {
                jsonGenerator.writeFieldName("NoEncryptionConfig").writeValue(encryptionConfiguration.getNoEncryptionConfig());
            }
            if (encryptionConfiguration.getKMSEncryptionConfig() != null) {
                jsonGenerator.writeFieldName("KMSEncryptionConfig");
                KMSEncryptionConfigJsonMarshaller.getInstance().marshall(encryptionConfiguration.getKMSEncryptionConfig(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static EncryptionConfigurationJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new EncryptionConfigurationJsonMarshaller();
        }
        return instance;
    }
}

