/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalMap;
import com.amazonaws.services.kinesis.model.AddTagsToStreamRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;

public class AddTagsToStreamRequestMarshaller
implements Marshaller<Request<AddTagsToStreamRequest>, AddTagsToStreamRequest> {
    public Request<AddTagsToStreamRequest> marshall(AddTagsToStreamRequest addTagsToStreamRequest) {
        if (addTagsToStreamRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)addTagsToStreamRequest, "AmazonKinesis");
        request.addHeader("X-Amz-Target", "Kinesis_20131202.AddTagsToStream");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalMap tagsMap;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (addTagsToStreamRequest.getStreamName() != null) {
                jsonWriter.key("StreamName").value((Object)addTagsToStreamRequest.getStreamName());
            }
            if (!(tagsMap = (SdkInternalMap)addTagsToStreamRequest.getTags()).isEmpty() || !tagsMap.isAutoConstruct()) {
                jsonWriter.key("Tags");
                jsonWriter.object();
                for (Map.Entry tagsMapValue : tagsMap.entrySet()) {
                    if (tagsMapValue.getValue() == null) continue;
                    jsonWriter.key((String)tagsMapValue.getKey());
                    jsonWriter.value(tagsMapValue.getValue());
                }
                jsonWriter.endObject();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

