/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.keyspaces.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.keyspaces.model.AutoScalingSpecification;
import com.amazonaws.services.keyspaces.model.CapacitySpecification;
import com.amazonaws.services.keyspaces.model.ClientSideTimestamps;
import com.amazonaws.services.keyspaces.model.ColumnDefinition;
import com.amazonaws.services.keyspaces.model.EncryptionSpecification;
import com.amazonaws.services.keyspaces.model.PointInTimeRecovery;
import com.amazonaws.services.keyspaces.model.ReplicaSpecification;
import com.amazonaws.services.keyspaces.model.TimeToLive;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UpdateTableRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String keyspaceName;
    private String tableName;
    private List<ColumnDefinition> addColumns;
    private CapacitySpecification capacitySpecification;
    private EncryptionSpecification encryptionSpecification;
    private PointInTimeRecovery pointInTimeRecovery;
    private TimeToLive ttl;
    private Integer defaultTimeToLive;
    private ClientSideTimestamps clientSideTimestamps;
    private AutoScalingSpecification autoScalingSpecification;
    private List<ReplicaSpecification> replicaSpecifications;

    public void setKeyspaceName(String keyspaceName) {
        this.keyspaceName = keyspaceName;
    }

    public String getKeyspaceName() {
        return this.keyspaceName;
    }

    public UpdateTableRequest withKeyspaceName(String keyspaceName) {
        this.setKeyspaceName(keyspaceName);
        return this;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public UpdateTableRequest withTableName(String tableName) {
        this.setTableName(tableName);
        return this;
    }

    public List<ColumnDefinition> getAddColumns() {
        return this.addColumns;
    }

    public void setAddColumns(Collection<ColumnDefinition> addColumns) {
        if (addColumns == null) {
            this.addColumns = null;
            return;
        }
        this.addColumns = new ArrayList<ColumnDefinition>(addColumns);
    }

    public UpdateTableRequest withAddColumns(ColumnDefinition ... addColumns) {
        if (this.addColumns == null) {
            this.setAddColumns(new ArrayList<ColumnDefinition>(addColumns.length));
        }
        for (ColumnDefinition ele : addColumns) {
            this.addColumns.add(ele);
        }
        return this;
    }

    public UpdateTableRequest withAddColumns(Collection<ColumnDefinition> addColumns) {
        this.setAddColumns(addColumns);
        return this;
    }

    public void setCapacitySpecification(CapacitySpecification capacitySpecification) {
        this.capacitySpecification = capacitySpecification;
    }

    public CapacitySpecification getCapacitySpecification() {
        return this.capacitySpecification;
    }

    public UpdateTableRequest withCapacitySpecification(CapacitySpecification capacitySpecification) {
        this.setCapacitySpecification(capacitySpecification);
        return this;
    }

    public void setEncryptionSpecification(EncryptionSpecification encryptionSpecification) {
        this.encryptionSpecification = encryptionSpecification;
    }

    public EncryptionSpecification getEncryptionSpecification() {
        return this.encryptionSpecification;
    }

    public UpdateTableRequest withEncryptionSpecification(EncryptionSpecification encryptionSpecification) {
        this.setEncryptionSpecification(encryptionSpecification);
        return this;
    }

    public void setPointInTimeRecovery(PointInTimeRecovery pointInTimeRecovery) {
        this.pointInTimeRecovery = pointInTimeRecovery;
    }

    public PointInTimeRecovery getPointInTimeRecovery() {
        return this.pointInTimeRecovery;
    }

    public UpdateTableRequest withPointInTimeRecovery(PointInTimeRecovery pointInTimeRecovery) {
        this.setPointInTimeRecovery(pointInTimeRecovery);
        return this;
    }

    public void setTtl(TimeToLive ttl) {
        this.ttl = ttl;
    }

    public TimeToLive getTtl() {
        return this.ttl;
    }

    public UpdateTableRequest withTtl(TimeToLive ttl) {
        this.setTtl(ttl);
        return this;
    }

    public void setDefaultTimeToLive(Integer defaultTimeToLive) {
        this.defaultTimeToLive = defaultTimeToLive;
    }

    public Integer getDefaultTimeToLive() {
        return this.defaultTimeToLive;
    }

    public UpdateTableRequest withDefaultTimeToLive(Integer defaultTimeToLive) {
        this.setDefaultTimeToLive(defaultTimeToLive);
        return this;
    }

    public void setClientSideTimestamps(ClientSideTimestamps clientSideTimestamps) {
        this.clientSideTimestamps = clientSideTimestamps;
    }

    public ClientSideTimestamps getClientSideTimestamps() {
        return this.clientSideTimestamps;
    }

    public UpdateTableRequest withClientSideTimestamps(ClientSideTimestamps clientSideTimestamps) {
        this.setClientSideTimestamps(clientSideTimestamps);
        return this;
    }

    public void setAutoScalingSpecification(AutoScalingSpecification autoScalingSpecification) {
        this.autoScalingSpecification = autoScalingSpecification;
    }

    public AutoScalingSpecification getAutoScalingSpecification() {
        return this.autoScalingSpecification;
    }

    public UpdateTableRequest withAutoScalingSpecification(AutoScalingSpecification autoScalingSpecification) {
        this.setAutoScalingSpecification(autoScalingSpecification);
        return this;
    }

    public List<ReplicaSpecification> getReplicaSpecifications() {
        return this.replicaSpecifications;
    }

    public void setReplicaSpecifications(Collection<ReplicaSpecification> replicaSpecifications) {
        if (replicaSpecifications == null) {
            this.replicaSpecifications = null;
            return;
        }
        this.replicaSpecifications = new ArrayList<ReplicaSpecification>(replicaSpecifications);
    }

    public UpdateTableRequest withReplicaSpecifications(ReplicaSpecification ... replicaSpecifications) {
        if (this.replicaSpecifications == null) {
            this.setReplicaSpecifications(new ArrayList<ReplicaSpecification>(replicaSpecifications.length));
        }
        for (ReplicaSpecification ele : replicaSpecifications) {
            this.replicaSpecifications.add(ele);
        }
        return this;
    }

    public UpdateTableRequest withReplicaSpecifications(Collection<ReplicaSpecification> replicaSpecifications) {
        this.setReplicaSpecifications(replicaSpecifications);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getKeyspaceName() != null) {
            sb.append("KeyspaceName: ").append(this.getKeyspaceName()).append(",");
        }
        if (this.getTableName() != null) {
            sb.append("TableName: ").append(this.getTableName()).append(",");
        }
        if (this.getAddColumns() != null) {
            sb.append("AddColumns: ").append(this.getAddColumns()).append(",");
        }
        if (this.getCapacitySpecification() != null) {
            sb.append("CapacitySpecification: ").append(this.getCapacitySpecification()).append(",");
        }
        if (this.getEncryptionSpecification() != null) {
            sb.append("EncryptionSpecification: ").append(this.getEncryptionSpecification()).append(",");
        }
        if (this.getPointInTimeRecovery() != null) {
            sb.append("PointInTimeRecovery: ").append(this.getPointInTimeRecovery()).append(",");
        }
        if (this.getTtl() != null) {
            sb.append("Ttl: ").append(this.getTtl()).append(",");
        }
        if (this.getDefaultTimeToLive() != null) {
            sb.append("DefaultTimeToLive: ").append(this.getDefaultTimeToLive()).append(",");
        }
        if (this.getClientSideTimestamps() != null) {
            sb.append("ClientSideTimestamps: ").append(this.getClientSideTimestamps()).append(",");
        }
        if (this.getAutoScalingSpecification() != null) {
            sb.append("AutoScalingSpecification: ").append(this.getAutoScalingSpecification()).append(",");
        }
        if (this.getReplicaSpecifications() != null) {
            sb.append("ReplicaSpecifications: ").append(this.getReplicaSpecifications());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTableRequest)) {
            return false;
        }
        UpdateTableRequest other = (UpdateTableRequest)obj;
        if (other.getKeyspaceName() == null ^ this.getKeyspaceName() == null) {
            return false;
        }
        if (other.getKeyspaceName() != null && !other.getKeyspaceName().equals(this.getKeyspaceName())) {
            return false;
        }
        if (other.getTableName() == null ^ this.getTableName() == null) {
            return false;
        }
        if (other.getTableName() != null && !other.getTableName().equals(this.getTableName())) {
            return false;
        }
        if (other.getAddColumns() == null ^ this.getAddColumns() == null) {
            return false;
        }
        if (other.getAddColumns() != null && !other.getAddColumns().equals(this.getAddColumns())) {
            return false;
        }
        if (other.getCapacitySpecification() == null ^ this.getCapacitySpecification() == null) {
            return false;
        }
        if (other.getCapacitySpecification() != null && !other.getCapacitySpecification().equals(this.getCapacitySpecification())) {
            return false;
        }
        if (other.getEncryptionSpecification() == null ^ this.getEncryptionSpecification() == null) {
            return false;
        }
        if (other.getEncryptionSpecification() != null && !other.getEncryptionSpecification().equals(this.getEncryptionSpecification())) {
            return false;
        }
        if (other.getPointInTimeRecovery() == null ^ this.getPointInTimeRecovery() == null) {
            return false;
        }
        if (other.getPointInTimeRecovery() != null && !other.getPointInTimeRecovery().equals(this.getPointInTimeRecovery())) {
            return false;
        }
        if (other.getTtl() == null ^ this.getTtl() == null) {
            return false;
        }
        if (other.getTtl() != null && !other.getTtl().equals(this.getTtl())) {
            return false;
        }
        if (other.getDefaultTimeToLive() == null ^ this.getDefaultTimeToLive() == null) {
            return false;
        }
        if (other.getDefaultTimeToLive() != null && !other.getDefaultTimeToLive().equals(this.getDefaultTimeToLive())) {
            return false;
        }
        if (other.getClientSideTimestamps() == null ^ this.getClientSideTimestamps() == null) {
            return false;
        }
        if (other.getClientSideTimestamps() != null && !other.getClientSideTimestamps().equals(this.getClientSideTimestamps())) {
            return false;
        }
        if (other.getAutoScalingSpecification() == null ^ this.getAutoScalingSpecification() == null) {
            return false;
        }
        if (other.getAutoScalingSpecification() != null && !other.getAutoScalingSpecification().equals(this.getAutoScalingSpecification())) {
            return false;
        }
        if (other.getReplicaSpecifications() == null ^ this.getReplicaSpecifications() == null) {
            return false;
        }
        return other.getReplicaSpecifications() == null || other.getReplicaSpecifications().equals(this.getReplicaSpecifications());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getKeyspaceName() == null ? 0 : this.getKeyspaceName().hashCode());
        hashCode = 31 * hashCode + (this.getTableName() == null ? 0 : this.getTableName().hashCode());
        hashCode = 31 * hashCode + (this.getAddColumns() == null ? 0 : this.getAddColumns().hashCode());
        hashCode = 31 * hashCode + (this.getCapacitySpecification() == null ? 0 : this.getCapacitySpecification().hashCode());
        hashCode = 31 * hashCode + (this.getEncryptionSpecification() == null ? 0 : this.getEncryptionSpecification().hashCode());
        hashCode = 31 * hashCode + (this.getPointInTimeRecovery() == null ? 0 : this.getPointInTimeRecovery().hashCode());
        hashCode = 31 * hashCode + (this.getTtl() == null ? 0 : this.getTtl().hashCode());
        hashCode = 31 * hashCode + (this.getDefaultTimeToLive() == null ? 0 : this.getDefaultTimeToLive().hashCode());
        hashCode = 31 * hashCode + (this.getClientSideTimestamps() == null ? 0 : this.getClientSideTimestamps().hashCode());
        hashCode = 31 * hashCode + (this.getAutoScalingSpecification() == null ? 0 : this.getAutoScalingSpecification().hashCode());
        hashCode = 31 * hashCode + (this.getReplicaSpecifications() == null ? 0 : this.getReplicaSpecifications().hashCode());
        return hashCode;
    }

    public UpdateTableRequest clone() {
        return (UpdateTableRequest)super.clone();
    }
}

