/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kendra.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.kendra.model.ExpandConfiguration;
import com.amazonaws.services.kendra.model.MissingAttributeKeyStrategy;
import com.amazonaws.services.kendra.model.SortingConfiguration;
import com.amazonaws.services.kendra.model.transform.CollapseConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CollapseConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private String documentAttributeKey;
    private List<SortingConfiguration> sortingConfigurations;
    private String missingAttributeKeyStrategy;
    private Boolean expand;
    private ExpandConfiguration expandConfiguration;

    public void setDocumentAttributeKey(String documentAttributeKey) {
        this.documentAttributeKey = documentAttributeKey;
    }

    public String getDocumentAttributeKey() {
        return this.documentAttributeKey;
    }

    public CollapseConfiguration withDocumentAttributeKey(String documentAttributeKey) {
        this.setDocumentAttributeKey(documentAttributeKey);
        return this;
    }

    public List<SortingConfiguration> getSortingConfigurations() {
        return this.sortingConfigurations;
    }

    public void setSortingConfigurations(Collection<SortingConfiguration> sortingConfigurations) {
        if (sortingConfigurations == null) {
            this.sortingConfigurations = null;
            return;
        }
        this.sortingConfigurations = new ArrayList<SortingConfiguration>(sortingConfigurations);
    }

    public CollapseConfiguration withSortingConfigurations(SortingConfiguration ... sortingConfigurations) {
        if (this.sortingConfigurations == null) {
            this.setSortingConfigurations(new ArrayList<SortingConfiguration>(sortingConfigurations.length));
        }
        for (SortingConfiguration ele : sortingConfigurations) {
            this.sortingConfigurations.add(ele);
        }
        return this;
    }

    public CollapseConfiguration withSortingConfigurations(Collection<SortingConfiguration> sortingConfigurations) {
        this.setSortingConfigurations(sortingConfigurations);
        return this;
    }

    public void setMissingAttributeKeyStrategy(String missingAttributeKeyStrategy) {
        this.missingAttributeKeyStrategy = missingAttributeKeyStrategy;
    }

    public String getMissingAttributeKeyStrategy() {
        return this.missingAttributeKeyStrategy;
    }

    public CollapseConfiguration withMissingAttributeKeyStrategy(String missingAttributeKeyStrategy) {
        this.setMissingAttributeKeyStrategy(missingAttributeKeyStrategy);
        return this;
    }

    public CollapseConfiguration withMissingAttributeKeyStrategy(MissingAttributeKeyStrategy missingAttributeKeyStrategy) {
        this.missingAttributeKeyStrategy = missingAttributeKeyStrategy.toString();
        return this;
    }

    public void setExpand(Boolean expand) {
        this.expand = expand;
    }

    public Boolean getExpand() {
        return this.expand;
    }

    public CollapseConfiguration withExpand(Boolean expand) {
        this.setExpand(expand);
        return this;
    }

    public Boolean isExpand() {
        return this.expand;
    }

    public void setExpandConfiguration(ExpandConfiguration expandConfiguration) {
        this.expandConfiguration = expandConfiguration;
    }

    public ExpandConfiguration getExpandConfiguration() {
        return this.expandConfiguration;
    }

    public CollapseConfiguration withExpandConfiguration(ExpandConfiguration expandConfiguration) {
        this.setExpandConfiguration(expandConfiguration);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDocumentAttributeKey() != null) {
            sb.append("DocumentAttributeKey: ").append(this.getDocumentAttributeKey()).append(",");
        }
        if (this.getSortingConfigurations() != null) {
            sb.append("SortingConfigurations: ").append(this.getSortingConfigurations()).append(",");
        }
        if (this.getMissingAttributeKeyStrategy() != null) {
            sb.append("MissingAttributeKeyStrategy: ").append(this.getMissingAttributeKeyStrategy()).append(",");
        }
        if (this.getExpand() != null) {
            sb.append("Expand: ").append(this.getExpand()).append(",");
        }
        if (this.getExpandConfiguration() != null) {
            sb.append("ExpandConfiguration: ").append(this.getExpandConfiguration());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CollapseConfiguration)) {
            return false;
        }
        CollapseConfiguration other = (CollapseConfiguration)obj;
        if (other.getDocumentAttributeKey() == null ^ this.getDocumentAttributeKey() == null) {
            return false;
        }
        if (other.getDocumentAttributeKey() != null && !other.getDocumentAttributeKey().equals(this.getDocumentAttributeKey())) {
            return false;
        }
        if (other.getSortingConfigurations() == null ^ this.getSortingConfigurations() == null) {
            return false;
        }
        if (other.getSortingConfigurations() != null && !other.getSortingConfigurations().equals(this.getSortingConfigurations())) {
            return false;
        }
        if (other.getMissingAttributeKeyStrategy() == null ^ this.getMissingAttributeKeyStrategy() == null) {
            return false;
        }
        if (other.getMissingAttributeKeyStrategy() != null && !other.getMissingAttributeKeyStrategy().equals(this.getMissingAttributeKeyStrategy())) {
            return false;
        }
        if (other.getExpand() == null ^ this.getExpand() == null) {
            return false;
        }
        if (other.getExpand() != null && !other.getExpand().equals(this.getExpand())) {
            return false;
        }
        if (other.getExpandConfiguration() == null ^ this.getExpandConfiguration() == null) {
            return false;
        }
        return other.getExpandConfiguration() == null || other.getExpandConfiguration().equals(this.getExpandConfiguration());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDocumentAttributeKey() == null ? 0 : this.getDocumentAttributeKey().hashCode());
        hashCode = 31 * hashCode + (this.getSortingConfigurations() == null ? 0 : this.getSortingConfigurations().hashCode());
        hashCode = 31 * hashCode + (this.getMissingAttributeKeyStrategy() == null ? 0 : this.getMissingAttributeKeyStrategy().hashCode());
        hashCode = 31 * hashCode + (this.getExpand() == null ? 0 : this.getExpand().hashCode());
        hashCode = 31 * hashCode + (this.getExpandConfiguration() == null ? 0 : this.getExpandConfiguration().hashCode());
        return hashCode;
    }

    public CollapseConfiguration clone() {
        try {
            return (CollapseConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CollapseConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

