/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.kendra.model.transform;

import java.util.List;
import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.kendra.model.*;

import com.amazonaws.protocol.*;
import com.amazonaws.annotation.SdkInternalApi;

/**
 * QueryRequestMarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
@SdkInternalApi
public class QueryRequestMarshaller {

    private static final MarshallingInfo<String> INDEXID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("IndexId").build();
    private static final MarshallingInfo<String> QUERYTEXT_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("QueryText").build();
    private static final MarshallingInfo<StructuredPojo> ATTRIBUTEFILTER_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AttributeFilter").build();
    private static final MarshallingInfo<List> FACETS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("Facets").build();
    private static final MarshallingInfo<List> REQUESTEDDOCUMENTATTRIBUTES_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RequestedDocumentAttributes").build();
    private static final MarshallingInfo<String> QUERYRESULTTYPEFILTER_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("QueryResultTypeFilter").build();
    private static final MarshallingInfo<List> DOCUMENTRELEVANCEOVERRIDECONFIGURATIONS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DocumentRelevanceOverrideConfigurations").build();
    private static final MarshallingInfo<Integer> PAGENUMBER_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PageNumber").build();
    private static final MarshallingInfo<Integer> PAGESIZE_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PageSize").build();
    private static final MarshallingInfo<StructuredPojo> SORTINGCONFIGURATION_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SortingConfiguration").build();
    private static final MarshallingInfo<List> SORTINGCONFIGURATIONS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SortingConfigurations").build();
    private static final MarshallingInfo<StructuredPojo> USERCONTEXT_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UserContext").build();
    private static final MarshallingInfo<String> VISITORID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("VisitorId").build();
    private static final MarshallingInfo<StructuredPojo> SPELLCORRECTIONCONFIGURATION_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SpellCorrectionConfiguration").build();
    private static final MarshallingInfo<StructuredPojo> COLLAPSECONFIGURATION_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CollapseConfiguration").build();

    private static final QueryRequestMarshaller instance = new QueryRequestMarshaller();

    public static QueryRequestMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(QueryRequest queryRequest, ProtocolMarshaller protocolMarshaller) {

        if (queryRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            protocolMarshaller.marshall(queryRequest.getIndexId(), INDEXID_BINDING);
            protocolMarshaller.marshall(queryRequest.getQueryText(), QUERYTEXT_BINDING);
            protocolMarshaller.marshall(queryRequest.getAttributeFilter(), ATTRIBUTEFILTER_BINDING);
            protocolMarshaller.marshall(queryRequest.getFacets(), FACETS_BINDING);
            protocolMarshaller.marshall(queryRequest.getRequestedDocumentAttributes(), REQUESTEDDOCUMENTATTRIBUTES_BINDING);
            protocolMarshaller.marshall(queryRequest.getQueryResultTypeFilter(), QUERYRESULTTYPEFILTER_BINDING);
            protocolMarshaller.marshall(queryRequest.getDocumentRelevanceOverrideConfigurations(), DOCUMENTRELEVANCEOVERRIDECONFIGURATIONS_BINDING);
            protocolMarshaller.marshall(queryRequest.getPageNumber(), PAGENUMBER_BINDING);
            protocolMarshaller.marshall(queryRequest.getPageSize(), PAGESIZE_BINDING);
            protocolMarshaller.marshall(queryRequest.getSortingConfiguration(), SORTINGCONFIGURATION_BINDING);
            protocolMarshaller.marshall(queryRequest.getSortingConfigurations(), SORTINGCONFIGURATIONS_BINDING);
            protocolMarshaller.marshall(queryRequest.getUserContext(), USERCONTEXT_BINDING);
            protocolMarshaller.marshall(queryRequest.getVisitorId(), VISITORID_BINDING);
            protocolMarshaller.marshall(queryRequest.getSpellCorrectionConfiguration(), SPELLCORRECTIONCONFIGURATION_BINDING);
            protocolMarshaller.marshall(queryRequest.getCollapseConfiguration(), COLLAPSECONFIGURATION_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
