/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kafkaconnect;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.kafkaconnect.AWSKafkaConnectAsync;
import com.amazonaws.services.kafkaconnect.AWSKafkaConnectAsyncClientBuilder;
import com.amazonaws.services.kafkaconnect.AWSKafkaConnectClient;
import com.amazonaws.services.kafkaconnect.model.CreateConnectorRequest;
import com.amazonaws.services.kafkaconnect.model.CreateConnectorResult;
import com.amazonaws.services.kafkaconnect.model.CreateCustomPluginRequest;
import com.amazonaws.services.kafkaconnect.model.CreateCustomPluginResult;
import com.amazonaws.services.kafkaconnect.model.CreateWorkerConfigurationRequest;
import com.amazonaws.services.kafkaconnect.model.CreateWorkerConfigurationResult;
import com.amazonaws.services.kafkaconnect.model.DeleteConnectorRequest;
import com.amazonaws.services.kafkaconnect.model.DeleteConnectorResult;
import com.amazonaws.services.kafkaconnect.model.DeleteCustomPluginRequest;
import com.amazonaws.services.kafkaconnect.model.DeleteCustomPluginResult;
import com.amazonaws.services.kafkaconnect.model.DescribeConnectorRequest;
import com.amazonaws.services.kafkaconnect.model.DescribeConnectorResult;
import com.amazonaws.services.kafkaconnect.model.DescribeCustomPluginRequest;
import com.amazonaws.services.kafkaconnect.model.DescribeCustomPluginResult;
import com.amazonaws.services.kafkaconnect.model.DescribeWorkerConfigurationRequest;
import com.amazonaws.services.kafkaconnect.model.DescribeWorkerConfigurationResult;
import com.amazonaws.services.kafkaconnect.model.ListConnectorsRequest;
import com.amazonaws.services.kafkaconnect.model.ListConnectorsResult;
import com.amazonaws.services.kafkaconnect.model.ListCustomPluginsRequest;
import com.amazonaws.services.kafkaconnect.model.ListCustomPluginsResult;
import com.amazonaws.services.kafkaconnect.model.ListWorkerConfigurationsRequest;
import com.amazonaws.services.kafkaconnect.model.ListWorkerConfigurationsResult;
import com.amazonaws.services.kafkaconnect.model.UpdateConnectorRequest;
import com.amazonaws.services.kafkaconnect.model.UpdateConnectorResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSKafkaConnectAsyncClient
extends AWSKafkaConnectClient
implements AWSKafkaConnectAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSKafkaConnectAsyncClientBuilder asyncBuilder() {
        return AWSKafkaConnectAsyncClientBuilder.standard();
    }

    AWSKafkaConnectAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSKafkaConnectAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CreateConnectorResult> createConnectorAsync(CreateConnectorRequest request) {
        return this.createConnectorAsync(request, null);
    }

    @Override
    public Future<CreateConnectorResult> createConnectorAsync(CreateConnectorRequest request, final AsyncHandler<CreateConnectorRequest, CreateConnectorResult> asyncHandler) {
        final CreateConnectorRequest finalRequest = (CreateConnectorRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateConnectorResult>(){

            @Override
            public CreateConnectorResult call() throws Exception {
                CreateConnectorResult result = null;
                try {
                    result = AWSKafkaConnectAsyncClient.this.executeCreateConnector(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateCustomPluginResult> createCustomPluginAsync(CreateCustomPluginRequest request) {
        return this.createCustomPluginAsync(request, null);
    }

    @Override
    public Future<CreateCustomPluginResult> createCustomPluginAsync(CreateCustomPluginRequest request, final AsyncHandler<CreateCustomPluginRequest, CreateCustomPluginResult> asyncHandler) {
        final CreateCustomPluginRequest finalRequest = (CreateCustomPluginRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateCustomPluginResult>(){

            @Override
            public CreateCustomPluginResult call() throws Exception {
                CreateCustomPluginResult result = null;
                try {
                    result = AWSKafkaConnectAsyncClient.this.executeCreateCustomPlugin(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateWorkerConfigurationResult> createWorkerConfigurationAsync(CreateWorkerConfigurationRequest request) {
        return this.createWorkerConfigurationAsync(request, null);
    }

    @Override
    public Future<CreateWorkerConfigurationResult> createWorkerConfigurationAsync(CreateWorkerConfigurationRequest request, final AsyncHandler<CreateWorkerConfigurationRequest, CreateWorkerConfigurationResult> asyncHandler) {
        final CreateWorkerConfigurationRequest finalRequest = (CreateWorkerConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateWorkerConfigurationResult>(){

            @Override
            public CreateWorkerConfigurationResult call() throws Exception {
                CreateWorkerConfigurationResult result = null;
                try {
                    result = AWSKafkaConnectAsyncClient.this.executeCreateWorkerConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteConnectorResult> deleteConnectorAsync(DeleteConnectorRequest request) {
        return this.deleteConnectorAsync(request, null);
    }

    @Override
    public Future<DeleteConnectorResult> deleteConnectorAsync(DeleteConnectorRequest request, final AsyncHandler<DeleteConnectorRequest, DeleteConnectorResult> asyncHandler) {
        final DeleteConnectorRequest finalRequest = (DeleteConnectorRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteConnectorResult>(){

            @Override
            public DeleteConnectorResult call() throws Exception {
                DeleteConnectorResult result = null;
                try {
                    result = AWSKafkaConnectAsyncClient.this.executeDeleteConnector(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteCustomPluginResult> deleteCustomPluginAsync(DeleteCustomPluginRequest request) {
        return this.deleteCustomPluginAsync(request, null);
    }

    @Override
    public Future<DeleteCustomPluginResult> deleteCustomPluginAsync(DeleteCustomPluginRequest request, final AsyncHandler<DeleteCustomPluginRequest, DeleteCustomPluginResult> asyncHandler) {
        final DeleteCustomPluginRequest finalRequest = (DeleteCustomPluginRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteCustomPluginResult>(){

            @Override
            public DeleteCustomPluginResult call() throws Exception {
                DeleteCustomPluginResult result = null;
                try {
                    result = AWSKafkaConnectAsyncClient.this.executeDeleteCustomPlugin(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeConnectorResult> describeConnectorAsync(DescribeConnectorRequest request) {
        return this.describeConnectorAsync(request, null);
    }

    @Override
    public Future<DescribeConnectorResult> describeConnectorAsync(DescribeConnectorRequest request, final AsyncHandler<DescribeConnectorRequest, DescribeConnectorResult> asyncHandler) {
        final DescribeConnectorRequest finalRequest = (DescribeConnectorRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeConnectorResult>(){

            @Override
            public DescribeConnectorResult call() throws Exception {
                DescribeConnectorResult result = null;
                try {
                    result = AWSKafkaConnectAsyncClient.this.executeDescribeConnector(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeCustomPluginResult> describeCustomPluginAsync(DescribeCustomPluginRequest request) {
        return this.describeCustomPluginAsync(request, null);
    }

    @Override
    public Future<DescribeCustomPluginResult> describeCustomPluginAsync(DescribeCustomPluginRequest request, final AsyncHandler<DescribeCustomPluginRequest, DescribeCustomPluginResult> asyncHandler) {
        final DescribeCustomPluginRequest finalRequest = (DescribeCustomPluginRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeCustomPluginResult>(){

            @Override
            public DescribeCustomPluginResult call() throws Exception {
                DescribeCustomPluginResult result = null;
                try {
                    result = AWSKafkaConnectAsyncClient.this.executeDescribeCustomPlugin(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeWorkerConfigurationResult> describeWorkerConfigurationAsync(DescribeWorkerConfigurationRequest request) {
        return this.describeWorkerConfigurationAsync(request, null);
    }

    @Override
    public Future<DescribeWorkerConfigurationResult> describeWorkerConfigurationAsync(DescribeWorkerConfigurationRequest request, final AsyncHandler<DescribeWorkerConfigurationRequest, DescribeWorkerConfigurationResult> asyncHandler) {
        final DescribeWorkerConfigurationRequest finalRequest = (DescribeWorkerConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeWorkerConfigurationResult>(){

            @Override
            public DescribeWorkerConfigurationResult call() throws Exception {
                DescribeWorkerConfigurationResult result = null;
                try {
                    result = AWSKafkaConnectAsyncClient.this.executeDescribeWorkerConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListConnectorsResult> listConnectorsAsync(ListConnectorsRequest request) {
        return this.listConnectorsAsync(request, null);
    }

    @Override
    public Future<ListConnectorsResult> listConnectorsAsync(ListConnectorsRequest request, final AsyncHandler<ListConnectorsRequest, ListConnectorsResult> asyncHandler) {
        final ListConnectorsRequest finalRequest = (ListConnectorsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListConnectorsResult>(){

            @Override
            public ListConnectorsResult call() throws Exception {
                ListConnectorsResult result = null;
                try {
                    result = AWSKafkaConnectAsyncClient.this.executeListConnectors(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListCustomPluginsResult> listCustomPluginsAsync(ListCustomPluginsRequest request) {
        return this.listCustomPluginsAsync(request, null);
    }

    @Override
    public Future<ListCustomPluginsResult> listCustomPluginsAsync(ListCustomPluginsRequest request, final AsyncHandler<ListCustomPluginsRequest, ListCustomPluginsResult> asyncHandler) {
        final ListCustomPluginsRequest finalRequest = (ListCustomPluginsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListCustomPluginsResult>(){

            @Override
            public ListCustomPluginsResult call() throws Exception {
                ListCustomPluginsResult result = null;
                try {
                    result = AWSKafkaConnectAsyncClient.this.executeListCustomPlugins(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListWorkerConfigurationsResult> listWorkerConfigurationsAsync(ListWorkerConfigurationsRequest request) {
        return this.listWorkerConfigurationsAsync(request, null);
    }

    @Override
    public Future<ListWorkerConfigurationsResult> listWorkerConfigurationsAsync(ListWorkerConfigurationsRequest request, final AsyncHandler<ListWorkerConfigurationsRequest, ListWorkerConfigurationsResult> asyncHandler) {
        final ListWorkerConfigurationsRequest finalRequest = (ListWorkerConfigurationsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListWorkerConfigurationsResult>(){

            @Override
            public ListWorkerConfigurationsResult call() throws Exception {
                ListWorkerConfigurationsResult result = null;
                try {
                    result = AWSKafkaConnectAsyncClient.this.executeListWorkerConfigurations(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateConnectorResult> updateConnectorAsync(UpdateConnectorRequest request) {
        return this.updateConnectorAsync(request, null);
    }

    @Override
    public Future<UpdateConnectorResult> updateConnectorAsync(UpdateConnectorRequest request, final AsyncHandler<UpdateConnectorRequest, UpdateConnectorResult> asyncHandler) {
        final UpdateConnectorRequest finalRequest = (UpdateConnectorRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateConnectorResult>(){

            @Override
            public UpdateConnectorResult call() throws Exception {
                UpdateConnectorResult result = null;
                try {
                    result = AWSKafkaConnectAsyncClient.this.executeUpdateConnector(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

