/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kafka.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.kafka.model.CompatibleKafkaVersion;
import java.util.List;

@SdkInternalApi
public class CompatibleKafkaVersionMarshaller {
    private static final MarshallingInfo<String> SOURCEVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sourceVersion").build();
    private static final MarshallingInfo<List> TARGETVERSIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("targetVersions").build();
    private static final CompatibleKafkaVersionMarshaller instance = new CompatibleKafkaVersionMarshaller();

    public static CompatibleKafkaVersionMarshaller getInstance() {
        return instance;
    }

    public void marshall(CompatibleKafkaVersion compatibleKafkaVersion, ProtocolMarshaller protocolMarshaller) {
        if (compatibleKafkaVersion == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)compatibleKafkaVersion.getSourceVersion(), SOURCEVERSION_BINDING);
            protocolMarshaller.marshall(compatibleKafkaVersion.getTargetVersions(), TARGETVERSIONS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

