/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kafka.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.kafka.model.Cluster;
import java.util.Date;
import java.util.Map;

@SdkInternalApi
public class ClusterMarshaller {
    private static final MarshallingInfo<String> ACTIVEOPERATIONARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("activeOperationArn").build();
    private static final MarshallingInfo<String> CLUSTERTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("clusterType").build();
    private static final MarshallingInfo<String> CLUSTERARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("clusterArn").build();
    private static final MarshallingInfo<String> CLUSTERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("clusterName").build();
    private static final MarshallingInfo<Date> CREATIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("creationTime").timestampFormat("iso8601").build();
    private static final MarshallingInfo<String> CURRENTVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("currentVersion").build();
    private static final MarshallingInfo<String> STATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("state").build();
    private static final MarshallingInfo<StructuredPojo> STATEINFO_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("stateInfo").build();
    private static final MarshallingInfo<Map> TAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("tags").build();
    private static final MarshallingInfo<StructuredPojo> PROVISIONED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("provisioned").build();
    private static final MarshallingInfo<StructuredPojo> SERVERLESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("serverless").build();
    private static final ClusterMarshaller instance = new ClusterMarshaller();

    public static ClusterMarshaller getInstance() {
        return instance;
    }

    public void marshall(Cluster cluster, ProtocolMarshaller protocolMarshaller) {
        if (cluster == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)cluster.getActiveOperationArn(), ACTIVEOPERATIONARN_BINDING);
            protocolMarshaller.marshall((Object)cluster.getClusterType(), CLUSTERTYPE_BINDING);
            protocolMarshaller.marshall((Object)cluster.getClusterArn(), CLUSTERARN_BINDING);
            protocolMarshaller.marshall((Object)cluster.getClusterName(), CLUSTERNAME_BINDING);
            protocolMarshaller.marshall((Object)cluster.getCreationTime(), CREATIONTIME_BINDING);
            protocolMarshaller.marshall((Object)cluster.getCurrentVersion(), CURRENTVERSION_BINDING);
            protocolMarshaller.marshall((Object)cluster.getState(), STATE_BINDING);
            protocolMarshaller.marshall((Object)cluster.getStateInfo(), STATEINFO_BINDING);
            protocolMarshaller.marshall(cluster.getTags(), TAGS_BINDING);
            protocolMarshaller.marshall((Object)cluster.getProvisioned(), PROVISIONED_BINDING);
            protocolMarshaller.marshall((Object)cluster.getServerless(), SERVERLESS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

