/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kafka.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.kafka.model.CloudWatchLogs;

@SdkInternalApi
public class CloudWatchLogsMarshaller {
    private static final MarshallingInfo<Boolean> ENABLED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("enabled").build();
    private static final MarshallingInfo<String> LOGGROUP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("logGroup").build();
    private static final CloudWatchLogsMarshaller instance = new CloudWatchLogsMarshaller();

    public static CloudWatchLogsMarshaller getInstance() {
        return instance;
    }

    public void marshall(CloudWatchLogs cloudWatchLogs, ProtocolMarshaller protocolMarshaller) {
        if (cloudWatchLogs == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)cloudWatchLogs.getEnabled(), ENABLED_BINDING);
            protocolMarshaller.marshall((Object)cloudWatchLogs.getLogGroup(), LOGGROUP_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

