/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kafka.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.kafka.model.KafkaCluster;
import com.amazonaws.services.kafka.model.ReplicationInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreateReplicatorRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String description;
    private List<KafkaCluster> kafkaClusters;
    private List<ReplicationInfo> replicationInfoList;
    private String replicatorName;
    private String serviceExecutionRoleArn;
    private Map<String, String> tags;

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public CreateReplicatorRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public List<KafkaCluster> getKafkaClusters() {
        return this.kafkaClusters;
    }

    public void setKafkaClusters(Collection<KafkaCluster> kafkaClusters) {
        if (kafkaClusters == null) {
            this.kafkaClusters = null;
            return;
        }
        this.kafkaClusters = new ArrayList<KafkaCluster>(kafkaClusters);
    }

    public CreateReplicatorRequest withKafkaClusters(KafkaCluster ... kafkaClusters) {
        if (this.kafkaClusters == null) {
            this.setKafkaClusters(new ArrayList<KafkaCluster>(kafkaClusters.length));
        }
        for (KafkaCluster ele : kafkaClusters) {
            this.kafkaClusters.add(ele);
        }
        return this;
    }

    public CreateReplicatorRequest withKafkaClusters(Collection<KafkaCluster> kafkaClusters) {
        this.setKafkaClusters(kafkaClusters);
        return this;
    }

    public List<ReplicationInfo> getReplicationInfoList() {
        return this.replicationInfoList;
    }

    public void setReplicationInfoList(Collection<ReplicationInfo> replicationInfoList) {
        if (replicationInfoList == null) {
            this.replicationInfoList = null;
            return;
        }
        this.replicationInfoList = new ArrayList<ReplicationInfo>(replicationInfoList);
    }

    public CreateReplicatorRequest withReplicationInfoList(ReplicationInfo ... replicationInfoList) {
        if (this.replicationInfoList == null) {
            this.setReplicationInfoList(new ArrayList<ReplicationInfo>(replicationInfoList.length));
        }
        for (ReplicationInfo ele : replicationInfoList) {
            this.replicationInfoList.add(ele);
        }
        return this;
    }

    public CreateReplicatorRequest withReplicationInfoList(Collection<ReplicationInfo> replicationInfoList) {
        this.setReplicationInfoList(replicationInfoList);
        return this;
    }

    public void setReplicatorName(String replicatorName) {
        this.replicatorName = replicatorName;
    }

    public String getReplicatorName() {
        return this.replicatorName;
    }

    public CreateReplicatorRequest withReplicatorName(String replicatorName) {
        this.setReplicatorName(replicatorName);
        return this;
    }

    public void setServiceExecutionRoleArn(String serviceExecutionRoleArn) {
        this.serviceExecutionRoleArn = serviceExecutionRoleArn;
    }

    public String getServiceExecutionRoleArn() {
        return this.serviceExecutionRoleArn;
    }

    public CreateReplicatorRequest withServiceExecutionRoleArn(String serviceExecutionRoleArn) {
        this.setServiceExecutionRoleArn(serviceExecutionRoleArn);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public CreateReplicatorRequest withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public CreateReplicatorRequest addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public CreateReplicatorRequest clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getKafkaClusters() != null) {
            sb.append("KafkaClusters: ").append(this.getKafkaClusters()).append(",");
        }
        if (this.getReplicationInfoList() != null) {
            sb.append("ReplicationInfoList: ").append(this.getReplicationInfoList()).append(",");
        }
        if (this.getReplicatorName() != null) {
            sb.append("ReplicatorName: ").append(this.getReplicatorName()).append(",");
        }
        if (this.getServiceExecutionRoleArn() != null) {
            sb.append("ServiceExecutionRoleArn: ").append(this.getServiceExecutionRoleArn()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateReplicatorRequest)) {
            return false;
        }
        CreateReplicatorRequest other = (CreateReplicatorRequest)obj;
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getKafkaClusters() == null ^ this.getKafkaClusters() == null) {
            return false;
        }
        if (other.getKafkaClusters() != null && !other.getKafkaClusters().equals(this.getKafkaClusters())) {
            return false;
        }
        if (other.getReplicationInfoList() == null ^ this.getReplicationInfoList() == null) {
            return false;
        }
        if (other.getReplicationInfoList() != null && !other.getReplicationInfoList().equals(this.getReplicationInfoList())) {
            return false;
        }
        if (other.getReplicatorName() == null ^ this.getReplicatorName() == null) {
            return false;
        }
        if (other.getReplicatorName() != null && !other.getReplicatorName().equals(this.getReplicatorName())) {
            return false;
        }
        if (other.getServiceExecutionRoleArn() == null ^ this.getServiceExecutionRoleArn() == null) {
            return false;
        }
        if (other.getServiceExecutionRoleArn() != null && !other.getServiceExecutionRoleArn().equals(this.getServiceExecutionRoleArn())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getKafkaClusters() == null ? 0 : this.getKafkaClusters().hashCode());
        hashCode = 31 * hashCode + (this.getReplicationInfoList() == null ? 0 : this.getReplicationInfoList().hashCode());
        hashCode = 31 * hashCode + (this.getReplicatorName() == null ? 0 : this.getReplicatorName().hashCode());
        hashCode = 31 * hashCode + (this.getServiceExecutionRoleArn() == null ? 0 : this.getServiceExecutionRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CreateReplicatorRequest clone() {
        return (CreateReplicatorRequest)super.clone();
    }
}

