/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.kafka.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * 
 <p>
 * Description of the requester that calls the API operation.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/UserIdentity" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class UserIdentity implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The identity type of the requester that calls the API operation.
     * </p>
     */
    private String type;
    /**
     * <p>
     * A unique identifier for the requester that calls the API operation.
     * </p>
     */
    private String principalId;

    /**
     * <p>
     * The identity type of the requester that calls the API operation.
     * </p>
     * 
     * @param type
     *        <p>
     *        The identity type of the requester that calls the API operation.
     *        </p>
     * @see UserIdentityType
     */

    public void setType(String type) {
        this.type = type;
    }

    /**
     * <p>
     * The identity type of the requester that calls the API operation.
     * </p>
     * 
     * @return <p>
     *         The identity type of the requester that calls the API operation.
     *         </p>
     * @see UserIdentityType
     */

    public String getType() {
        return this.type;
    }

    /**
     * <p>
     * The identity type of the requester that calls the API operation.
     * </p>
     * 
     * @param type
     *        <p>
     *        The identity type of the requester that calls the API operation.
     *        </p>
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see UserIdentityType
     */

    public UserIdentity withType(String type) {
        setType(type);
        return this;
    }

    /**
     * <p>
     * The identity type of the requester that calls the API operation.
     * </p>
     * 
     * @param type
     *        <p>
     *        The identity type of the requester that calls the API operation.
     *        </p>
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see UserIdentityType
     */

    public UserIdentity withType(UserIdentityType type) {
        this.type = type.toString();
        return this;
    }

    /**
     * <p>
     * A unique identifier for the requester that calls the API operation.
     * </p>
     * 
     * @param principalId
     *        <p>
     *        A unique identifier for the requester that calls the API operation.
     *        </p>
     */

    public void setPrincipalId(String principalId) {
        this.principalId = principalId;
    }

    /**
     * <p>
     * A unique identifier for the requester that calls the API operation.
     * </p>
     * 
     * @return <p>
     *         A unique identifier for the requester that calls the API operation.
     *         </p>
     */

    public String getPrincipalId() {
        return this.principalId;
    }

    /**
     * <p>
     * A unique identifier for the requester that calls the API operation.
     * </p>
     * 
     * @param principalId
     *        <p>
     *        A unique identifier for the requester that calls the API operation.
     *        </p>
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UserIdentity withPrincipalId(String principalId) {
        setPrincipalId(principalId);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getType() != null)
            sb.append("Type: ").append(getType()).append(",");
        if (getPrincipalId() != null)
            sb.append("PrincipalId: ").append(getPrincipalId());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof UserIdentity == false)
            return false;
        UserIdentity other = (UserIdentity) obj;
        if (other.getType() == null ^ this.getType() == null)
            return false;
        if (other.getType() != null && other.getType().equals(this.getType()) == false)
            return false;
        if (other.getPrincipalId() == null ^ this.getPrincipalId() == null)
            return false;
        if (other.getPrincipalId() != null && other.getPrincipalId().equals(this.getPrincipalId()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getType() == null) ? 0 : getType().hashCode());
        hashCode = prime * hashCode + ((getPrincipalId() == null) ? 0 : getPrincipalId().hashCode());
        return hashCode;
    }

    @Override
    public UserIdentity clone() {
        try {
            return (UserIdentity) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.kafka.model.transform.UserIdentityMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
