/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kafka.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.kafka.model.BrokerAZDistribution;
import com.amazonaws.services.kafka.model.ConnectivityInfo;
import com.amazonaws.services.kafka.model.StorageInfo;
import com.amazonaws.services.kafka.model.transform.BrokerNodeGroupInfoMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BrokerNodeGroupInfo
implements Serializable,
Cloneable,
StructuredPojo {
    private String brokerAZDistribution;
    private List<String> clientSubnets;
    private String instanceType;
    private List<String> securityGroups;
    private StorageInfo storageInfo;
    private ConnectivityInfo connectivityInfo;

    public void setBrokerAZDistribution(String brokerAZDistribution) {
        this.brokerAZDistribution = brokerAZDistribution;
    }

    public String getBrokerAZDistribution() {
        return this.brokerAZDistribution;
    }

    public BrokerNodeGroupInfo withBrokerAZDistribution(String brokerAZDistribution) {
        this.setBrokerAZDistribution(brokerAZDistribution);
        return this;
    }

    public BrokerNodeGroupInfo withBrokerAZDistribution(BrokerAZDistribution brokerAZDistribution) {
        this.brokerAZDistribution = brokerAZDistribution.toString();
        return this;
    }

    public List<String> getClientSubnets() {
        return this.clientSubnets;
    }

    public void setClientSubnets(Collection<String> clientSubnets) {
        if (clientSubnets == null) {
            this.clientSubnets = null;
            return;
        }
        this.clientSubnets = new ArrayList<String>(clientSubnets);
    }

    public BrokerNodeGroupInfo withClientSubnets(String ... clientSubnets) {
        if (this.clientSubnets == null) {
            this.setClientSubnets(new ArrayList<String>(clientSubnets.length));
        }
        for (String ele : clientSubnets) {
            this.clientSubnets.add(ele);
        }
        return this;
    }

    public BrokerNodeGroupInfo withClientSubnets(Collection<String> clientSubnets) {
        this.setClientSubnets(clientSubnets);
        return this;
    }

    public void setInstanceType(String instanceType) {
        this.instanceType = instanceType;
    }

    public String getInstanceType() {
        return this.instanceType;
    }

    public BrokerNodeGroupInfo withInstanceType(String instanceType) {
        this.setInstanceType(instanceType);
        return this;
    }

    public List<String> getSecurityGroups() {
        return this.securityGroups;
    }

    public void setSecurityGroups(Collection<String> securityGroups) {
        if (securityGroups == null) {
            this.securityGroups = null;
            return;
        }
        this.securityGroups = new ArrayList<String>(securityGroups);
    }

    public BrokerNodeGroupInfo withSecurityGroups(String ... securityGroups) {
        if (this.securityGroups == null) {
            this.setSecurityGroups(new ArrayList<String>(securityGroups.length));
        }
        for (String ele : securityGroups) {
            this.securityGroups.add(ele);
        }
        return this;
    }

    public BrokerNodeGroupInfo withSecurityGroups(Collection<String> securityGroups) {
        this.setSecurityGroups(securityGroups);
        return this;
    }

    public void setStorageInfo(StorageInfo storageInfo) {
        this.storageInfo = storageInfo;
    }

    public StorageInfo getStorageInfo() {
        return this.storageInfo;
    }

    public BrokerNodeGroupInfo withStorageInfo(StorageInfo storageInfo) {
        this.setStorageInfo(storageInfo);
        return this;
    }

    public void setConnectivityInfo(ConnectivityInfo connectivityInfo) {
        this.connectivityInfo = connectivityInfo;
    }

    public ConnectivityInfo getConnectivityInfo() {
        return this.connectivityInfo;
    }

    public BrokerNodeGroupInfo withConnectivityInfo(ConnectivityInfo connectivityInfo) {
        this.setConnectivityInfo(connectivityInfo);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getBrokerAZDistribution() != null) {
            sb.append("BrokerAZDistribution: ").append(this.getBrokerAZDistribution()).append(",");
        }
        if (this.getClientSubnets() != null) {
            sb.append("ClientSubnets: ").append(this.getClientSubnets()).append(",");
        }
        if (this.getInstanceType() != null) {
            sb.append("InstanceType: ").append(this.getInstanceType()).append(",");
        }
        if (this.getSecurityGroups() != null) {
            sb.append("SecurityGroups: ").append(this.getSecurityGroups()).append(",");
        }
        if (this.getStorageInfo() != null) {
            sb.append("StorageInfo: ").append(this.getStorageInfo()).append(",");
        }
        if (this.getConnectivityInfo() != null) {
            sb.append("ConnectivityInfo: ").append(this.getConnectivityInfo());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BrokerNodeGroupInfo)) {
            return false;
        }
        BrokerNodeGroupInfo other = (BrokerNodeGroupInfo)obj;
        if (other.getBrokerAZDistribution() == null ^ this.getBrokerAZDistribution() == null) {
            return false;
        }
        if (other.getBrokerAZDistribution() != null && !other.getBrokerAZDistribution().equals(this.getBrokerAZDistribution())) {
            return false;
        }
        if (other.getClientSubnets() == null ^ this.getClientSubnets() == null) {
            return false;
        }
        if (other.getClientSubnets() != null && !other.getClientSubnets().equals(this.getClientSubnets())) {
            return false;
        }
        if (other.getInstanceType() == null ^ this.getInstanceType() == null) {
            return false;
        }
        if (other.getInstanceType() != null && !other.getInstanceType().equals(this.getInstanceType())) {
            return false;
        }
        if (other.getSecurityGroups() == null ^ this.getSecurityGroups() == null) {
            return false;
        }
        if (other.getSecurityGroups() != null && !other.getSecurityGroups().equals(this.getSecurityGroups())) {
            return false;
        }
        if (other.getStorageInfo() == null ^ this.getStorageInfo() == null) {
            return false;
        }
        if (other.getStorageInfo() != null && !other.getStorageInfo().equals(this.getStorageInfo())) {
            return false;
        }
        if (other.getConnectivityInfo() == null ^ this.getConnectivityInfo() == null) {
            return false;
        }
        return other.getConnectivityInfo() == null || other.getConnectivityInfo().equals(this.getConnectivityInfo());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getBrokerAZDistribution() == null ? 0 : this.getBrokerAZDistribution().hashCode());
        hashCode = 31 * hashCode + (this.getClientSubnets() == null ? 0 : this.getClientSubnets().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceType() == null ? 0 : this.getInstanceType().hashCode());
        hashCode = 31 * hashCode + (this.getSecurityGroups() == null ? 0 : this.getSecurityGroups().hashCode());
        hashCode = 31 * hashCode + (this.getStorageInfo() == null ? 0 : this.getStorageInfo().hashCode());
        hashCode = 31 * hashCode + (this.getConnectivityInfo() == null ? 0 : this.getConnectivityInfo().hashCode());
        return hashCode;
    }

    public BrokerNodeGroupInfo clone() {
        try {
            return (BrokerNodeGroupInfo)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BrokerNodeGroupInfoMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

