/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.ivschat.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Summary information about a logging configuration.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ivschat-2020-07-14/LoggingConfigurationSummary"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class LoggingConfigurationSummary implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * Logging-configuration ARN.
     * </p>
     */
    private String arn;
    /**
     * <p>
     * Logging-configuration ID, generated by the system. This is a relative identifier, the part of the ARN that
     * uniquely identifies the room.
     * </p>
     */
    private String id;
    /**
     * <p>
     * Time when the logging configuration was created. This is an ISO 8601 timestamp; <i>note that this is returned as
     * a string</i>.
     * </p>
     */
    private java.util.Date createTime;
    /**
     * <p>
     * Time of the logging configuration’s last update. This is an ISO 8601 timestamp; <i>note that this is returned as
     * a string</i>.
     * </p>
     */
    private java.util.Date updateTime;
    /**
     * <p>
     * Logging-configuration name. The value does not need to be unique.
     * </p>
     */
    private String name;
    /**
     * <p>
     * A complex type that contains a destination configuration for where chat content will be logged.
     * </p>
     */
    private DestinationConfiguration destinationConfiguration;
    /**
     * <p>
     * The state of the logging configuration. When this is <code>ACTIVE</code>, the configuration is ready for logging
     * chat content.
     * </p>
     */
    private String state;
    /**
     * <p>
     * Tags to attach to the resource. Array of maps, each of the form <code>string:string (key:value)</code>. See <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS Resources</a> for details,
     * including restrictions that apply to tags and "Tag naming limits and requirements"; Amazon IVS Chat has no
     * constraints on tags beyond what is documented there.
     * </p>
     */
    private java.util.Map<String, String> tags;

    /**
     * <p>
     * Logging-configuration ARN.
     * </p>
     * 
     * @param arn
     *        Logging-configuration ARN.
     */

    public void setArn(String arn) {
        this.arn = arn;
    }

    /**
     * <p>
     * Logging-configuration ARN.
     * </p>
     * 
     * @return Logging-configuration ARN.
     */

    public String getArn() {
        return this.arn;
    }

    /**
     * <p>
     * Logging-configuration ARN.
     * </p>
     * 
     * @param arn
     *        Logging-configuration ARN.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public LoggingConfigurationSummary withArn(String arn) {
        setArn(arn);
        return this;
    }

    /**
     * <p>
     * Logging-configuration ID, generated by the system. This is a relative identifier, the part of the ARN that
     * uniquely identifies the room.
     * </p>
     * 
     * @param id
     *        Logging-configuration ID, generated by the system. This is a relative identifier, the part of the ARN that
     *        uniquely identifies the room.
     */

    public void setId(String id) {
        this.id = id;
    }

    /**
     * <p>
     * Logging-configuration ID, generated by the system. This is a relative identifier, the part of the ARN that
     * uniquely identifies the room.
     * </p>
     * 
     * @return Logging-configuration ID, generated by the system. This is a relative identifier, the part of the ARN
     *         that uniquely identifies the room.
     */

    public String getId() {
        return this.id;
    }

    /**
     * <p>
     * Logging-configuration ID, generated by the system. This is a relative identifier, the part of the ARN that
     * uniquely identifies the room.
     * </p>
     * 
     * @param id
     *        Logging-configuration ID, generated by the system. This is a relative identifier, the part of the ARN that
     *        uniquely identifies the room.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public LoggingConfigurationSummary withId(String id) {
        setId(id);
        return this;
    }

    /**
     * <p>
     * Time when the logging configuration was created. This is an ISO 8601 timestamp; <i>note that this is returned as
     * a string</i>.
     * </p>
     * 
     * @param createTime
     *        Time when the logging configuration was created. This is an ISO 8601 timestamp; <i>note that this is
     *        returned as a string</i>.
     */

    public void setCreateTime(java.util.Date createTime) {
        this.createTime = createTime;
    }

    /**
     * <p>
     * Time when the logging configuration was created. This is an ISO 8601 timestamp; <i>note that this is returned as
     * a string</i>.
     * </p>
     * 
     * @return Time when the logging configuration was created. This is an ISO 8601 timestamp; <i>note that this is
     *         returned as a string</i>.
     */

    public java.util.Date getCreateTime() {
        return this.createTime;
    }

    /**
     * <p>
     * Time when the logging configuration was created. This is an ISO 8601 timestamp; <i>note that this is returned as
     * a string</i>.
     * </p>
     * 
     * @param createTime
     *        Time when the logging configuration was created. This is an ISO 8601 timestamp; <i>note that this is
     *        returned as a string</i>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public LoggingConfigurationSummary withCreateTime(java.util.Date createTime) {
        setCreateTime(createTime);
        return this;
    }

    /**
     * <p>
     * Time of the logging configuration’s last update. This is an ISO 8601 timestamp; <i>note that this is returned as
     * a string</i>.
     * </p>
     * 
     * @param updateTime
     *        Time of the logging configuration’s last update. This is an ISO 8601 timestamp; <i>note that this is
     *        returned as a string</i>.
     */

    public void setUpdateTime(java.util.Date updateTime) {
        this.updateTime = updateTime;
    }

    /**
     * <p>
     * Time of the logging configuration’s last update. This is an ISO 8601 timestamp; <i>note that this is returned as
     * a string</i>.
     * </p>
     * 
     * @return Time of the logging configuration’s last update. This is an ISO 8601 timestamp; <i>note that this is
     *         returned as a string</i>.
     */

    public java.util.Date getUpdateTime() {
        return this.updateTime;
    }

    /**
     * <p>
     * Time of the logging configuration’s last update. This is an ISO 8601 timestamp; <i>note that this is returned as
     * a string</i>.
     * </p>
     * 
     * @param updateTime
     *        Time of the logging configuration’s last update. This is an ISO 8601 timestamp; <i>note that this is
     *        returned as a string</i>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public LoggingConfigurationSummary withUpdateTime(java.util.Date updateTime) {
        setUpdateTime(updateTime);
        return this;
    }

    /**
     * <p>
     * Logging-configuration name. The value does not need to be unique.
     * </p>
     * 
     * @param name
     *        Logging-configuration name. The value does not need to be unique.
     */

    public void setName(String name) {
        this.name = name;
    }

    /**
     * <p>
     * Logging-configuration name. The value does not need to be unique.
     * </p>
     * 
     * @return Logging-configuration name. The value does not need to be unique.
     */

    public String getName() {
        return this.name;
    }

    /**
     * <p>
     * Logging-configuration name. The value does not need to be unique.
     * </p>
     * 
     * @param name
     *        Logging-configuration name. The value does not need to be unique.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public LoggingConfigurationSummary withName(String name) {
        setName(name);
        return this;
    }

    /**
     * <p>
     * A complex type that contains a destination configuration for where chat content will be logged.
     * </p>
     * 
     * @param destinationConfiguration
     *        A complex type that contains a destination configuration for where chat content will be logged.
     */

    public void setDestinationConfiguration(DestinationConfiguration destinationConfiguration) {
        this.destinationConfiguration = destinationConfiguration;
    }

    /**
     * <p>
     * A complex type that contains a destination configuration for where chat content will be logged.
     * </p>
     * 
     * @return A complex type that contains a destination configuration for where chat content will be logged.
     */

    public DestinationConfiguration getDestinationConfiguration() {
        return this.destinationConfiguration;
    }

    /**
     * <p>
     * A complex type that contains a destination configuration for where chat content will be logged.
     * </p>
     * 
     * @param destinationConfiguration
     *        A complex type that contains a destination configuration for where chat content will be logged.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public LoggingConfigurationSummary withDestinationConfiguration(DestinationConfiguration destinationConfiguration) {
        setDestinationConfiguration(destinationConfiguration);
        return this;
    }

    /**
     * <p>
     * The state of the logging configuration. When this is <code>ACTIVE</code>, the configuration is ready for logging
     * chat content.
     * </p>
     * 
     * @param state
     *        The state of the logging configuration. When this is <code>ACTIVE</code>, the configuration is ready for
     *        logging chat content.
     * @see LoggingConfigurationState
     */

    public void setState(String state) {
        this.state = state;
    }

    /**
     * <p>
     * The state of the logging configuration. When this is <code>ACTIVE</code>, the configuration is ready for logging
     * chat content.
     * </p>
     * 
     * @return The state of the logging configuration. When this is <code>ACTIVE</code>, the configuration is ready for
     *         logging chat content.
     * @see LoggingConfigurationState
     */

    public String getState() {
        return this.state;
    }

    /**
     * <p>
     * The state of the logging configuration. When this is <code>ACTIVE</code>, the configuration is ready for logging
     * chat content.
     * </p>
     * 
     * @param state
     *        The state of the logging configuration. When this is <code>ACTIVE</code>, the configuration is ready for
     *        logging chat content.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see LoggingConfigurationState
     */

    public LoggingConfigurationSummary withState(String state) {
        setState(state);
        return this;
    }

    /**
     * <p>
     * The state of the logging configuration. When this is <code>ACTIVE</code>, the configuration is ready for logging
     * chat content.
     * </p>
     * 
     * @param state
     *        The state of the logging configuration. When this is <code>ACTIVE</code>, the configuration is ready for
     *        logging chat content.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see LoggingConfigurationState
     */

    public LoggingConfigurationSummary withState(LoggingConfigurationState state) {
        this.state = state.toString();
        return this;
    }

    /**
     * <p>
     * Tags to attach to the resource. Array of maps, each of the form <code>string:string (key:value)</code>. See <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS Resources</a> for details,
     * including restrictions that apply to tags and "Tag naming limits and requirements"; Amazon IVS Chat has no
     * constraints on tags beyond what is documented there.
     * </p>
     * 
     * @return Tags to attach to the resource. Array of maps, each of the form <code>string:string (key:value)</code>.
     *         See <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS Resources</a>
     *         for details, including restrictions that apply to tags and "Tag naming limits and requirements"; Amazon
     *         IVS Chat has no constraints on tags beyond what is documented there.
     */

    public java.util.Map<String, String> getTags() {
        return tags;
    }

    /**
     * <p>
     * Tags to attach to the resource. Array of maps, each of the form <code>string:string (key:value)</code>. See <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS Resources</a> for details,
     * including restrictions that apply to tags and "Tag naming limits and requirements"; Amazon IVS Chat has no
     * constraints on tags beyond what is documented there.
     * </p>
     * 
     * @param tags
     *        Tags to attach to the resource. Array of maps, each of the form <code>string:string (key:value)</code>.
     *        See <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS Resources</a> for
     *        details, including restrictions that apply to tags and "Tag naming limits and requirements"; Amazon IVS
     *        Chat has no constraints on tags beyond what is documented there.
     */

    public void setTags(java.util.Map<String, String> tags) {
        this.tags = tags;
    }

    /**
     * <p>
     * Tags to attach to the resource. Array of maps, each of the form <code>string:string (key:value)</code>. See <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS Resources</a> for details,
     * including restrictions that apply to tags and "Tag naming limits and requirements"; Amazon IVS Chat has no
     * constraints on tags beyond what is documented there.
     * </p>
     * 
     * @param tags
     *        Tags to attach to the resource. Array of maps, each of the form <code>string:string (key:value)</code>.
     *        See <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS Resources</a> for
     *        details, including restrictions that apply to tags and "Tag naming limits and requirements"; Amazon IVS
     *        Chat has no constraints on tags beyond what is documented there.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public LoggingConfigurationSummary withTags(java.util.Map<String, String> tags) {
        setTags(tags);
        return this;
    }

    /**
     * Add a single Tags entry
     *
     * @see LoggingConfigurationSummary#withTags
     * @returns a reference to this object so that method calls can be chained together.
     */

    public LoggingConfigurationSummary addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new java.util.HashMap<String, String>();
        }
        if (this.tags.containsKey(key))
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        this.tags.put(key, value);
        return this;
    }

    /**
     * Removes all the entries added into Tags.
     *
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public LoggingConfigurationSummary clearTagsEntries() {
        this.tags = null;
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getArn() != null)
            sb.append("Arn: ").append(getArn()).append(",");
        if (getId() != null)
            sb.append("Id: ").append(getId()).append(",");
        if (getCreateTime() != null)
            sb.append("CreateTime: ").append(getCreateTime()).append(",");
        if (getUpdateTime() != null)
            sb.append("UpdateTime: ").append(getUpdateTime()).append(",");
        if (getName() != null)
            sb.append("Name: ").append(getName()).append(",");
        if (getDestinationConfiguration() != null)
            sb.append("DestinationConfiguration: ").append(getDestinationConfiguration()).append(",");
        if (getState() != null)
            sb.append("State: ").append(getState()).append(",");
        if (getTags() != null)
            sb.append("Tags: ").append(getTags());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof LoggingConfigurationSummary == false)
            return false;
        LoggingConfigurationSummary other = (LoggingConfigurationSummary) obj;
        if (other.getArn() == null ^ this.getArn() == null)
            return false;
        if (other.getArn() != null && other.getArn().equals(this.getArn()) == false)
            return false;
        if (other.getId() == null ^ this.getId() == null)
            return false;
        if (other.getId() != null && other.getId().equals(this.getId()) == false)
            return false;
        if (other.getCreateTime() == null ^ this.getCreateTime() == null)
            return false;
        if (other.getCreateTime() != null && other.getCreateTime().equals(this.getCreateTime()) == false)
            return false;
        if (other.getUpdateTime() == null ^ this.getUpdateTime() == null)
            return false;
        if (other.getUpdateTime() != null && other.getUpdateTime().equals(this.getUpdateTime()) == false)
            return false;
        if (other.getName() == null ^ this.getName() == null)
            return false;
        if (other.getName() != null && other.getName().equals(this.getName()) == false)
            return false;
        if (other.getDestinationConfiguration() == null ^ this.getDestinationConfiguration() == null)
            return false;
        if (other.getDestinationConfiguration() != null && other.getDestinationConfiguration().equals(this.getDestinationConfiguration()) == false)
            return false;
        if (other.getState() == null ^ this.getState() == null)
            return false;
        if (other.getState() != null && other.getState().equals(this.getState()) == false)
            return false;
        if (other.getTags() == null ^ this.getTags() == null)
            return false;
        if (other.getTags() != null && other.getTags().equals(this.getTags()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getArn() == null) ? 0 : getArn().hashCode());
        hashCode = prime * hashCode + ((getId() == null) ? 0 : getId().hashCode());
        hashCode = prime * hashCode + ((getCreateTime() == null) ? 0 : getCreateTime().hashCode());
        hashCode = prime * hashCode + ((getUpdateTime() == null) ? 0 : getUpdateTime().hashCode());
        hashCode = prime * hashCode + ((getName() == null) ? 0 : getName().hashCode());
        hashCode = prime * hashCode + ((getDestinationConfiguration() == null) ? 0 : getDestinationConfiguration().hashCode());
        hashCode = prime * hashCode + ((getState() == null) ? 0 : getState().hashCode());
        hashCode = prime * hashCode + ((getTags() == null) ? 0 : getTags().hashCode());
        return hashCode;
    }

    @Override
    public LoggingConfigurationSummary clone() {
        try {
            return (LoggingConfigurationSummary) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.ivschat.model.transform.LoggingConfigurationSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
