/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ivs.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.ivs.model.Srt;

@SdkInternalApi
public class SrtMarshaller {
    private static final MarshallingInfo<String> ENDPOINT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("endpoint").build();
    private static final MarshallingInfo<String> PASSPHRASE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("passphrase").build();
    private static final SrtMarshaller instance = new SrtMarshaller();

    public static SrtMarshaller getInstance() {
        return instance;
    }

    public void marshall(Srt srt, ProtocolMarshaller protocolMarshaller) {
        if (srt == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)srt.getEndpoint(), ENDPOINT_BINDING);
            protocolMarshaller.marshall((Object)srt.getPassphrase(), PASSPHRASE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

