/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ivs.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.ivs.model.ChannelLatencyMode;
import com.amazonaws.services.ivs.model.ChannelType;
import com.amazonaws.services.ivs.model.TranscodePreset;
import com.amazonaws.services.ivs.model.transform.ChannelMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class Channel
implements Serializable,
Cloneable,
StructuredPojo {
    private String arn;
    private Boolean authorized;
    private String ingestEndpoint;
    private Boolean insecureIngest;
    private String latencyMode;
    private String name;
    private String playbackUrl;
    private String preset;
    private String recordingConfigurationArn;
    private Map<String, String> tags;
    private String type;

    public void setArn(String arn) {
        this.arn = arn;
    }

    public String getArn() {
        return this.arn;
    }

    public Channel withArn(String arn) {
        this.setArn(arn);
        return this;
    }

    public void setAuthorized(Boolean authorized) {
        this.authorized = authorized;
    }

    public Boolean getAuthorized() {
        return this.authorized;
    }

    public Channel withAuthorized(Boolean authorized) {
        this.setAuthorized(authorized);
        return this;
    }

    public Boolean isAuthorized() {
        return this.authorized;
    }

    public void setIngestEndpoint(String ingestEndpoint) {
        this.ingestEndpoint = ingestEndpoint;
    }

    public String getIngestEndpoint() {
        return this.ingestEndpoint;
    }

    public Channel withIngestEndpoint(String ingestEndpoint) {
        this.setIngestEndpoint(ingestEndpoint);
        return this;
    }

    public void setInsecureIngest(Boolean insecureIngest) {
        this.insecureIngest = insecureIngest;
    }

    public Boolean getInsecureIngest() {
        return this.insecureIngest;
    }

    public Channel withInsecureIngest(Boolean insecureIngest) {
        this.setInsecureIngest(insecureIngest);
        return this;
    }

    public Boolean isInsecureIngest() {
        return this.insecureIngest;
    }

    public void setLatencyMode(String latencyMode) {
        this.latencyMode = latencyMode;
    }

    public String getLatencyMode() {
        return this.latencyMode;
    }

    public Channel withLatencyMode(String latencyMode) {
        this.setLatencyMode(latencyMode);
        return this;
    }

    public Channel withLatencyMode(ChannelLatencyMode latencyMode) {
        this.latencyMode = latencyMode.toString();
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Channel withName(String name) {
        this.setName(name);
        return this;
    }

    public void setPlaybackUrl(String playbackUrl) {
        this.playbackUrl = playbackUrl;
    }

    public String getPlaybackUrl() {
        return this.playbackUrl;
    }

    public Channel withPlaybackUrl(String playbackUrl) {
        this.setPlaybackUrl(playbackUrl);
        return this;
    }

    public void setPreset(String preset) {
        this.preset = preset;
    }

    public String getPreset() {
        return this.preset;
    }

    public Channel withPreset(String preset) {
        this.setPreset(preset);
        return this;
    }

    public Channel withPreset(TranscodePreset preset) {
        this.preset = preset.toString();
        return this;
    }

    public void setRecordingConfigurationArn(String recordingConfigurationArn) {
        this.recordingConfigurationArn = recordingConfigurationArn;
    }

    public String getRecordingConfigurationArn() {
        return this.recordingConfigurationArn;
    }

    public Channel withRecordingConfigurationArn(String recordingConfigurationArn) {
        this.setRecordingConfigurationArn(recordingConfigurationArn);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public Channel withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public Channel addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public Channel clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public Channel withType(String type) {
        this.setType(type);
        return this;
    }

    public Channel withType(ChannelType type) {
        this.type = type.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getArn() != null) {
            sb.append("Arn: ").append(this.getArn()).append(",");
        }
        if (this.getAuthorized() != null) {
            sb.append("Authorized: ").append(this.getAuthorized()).append(",");
        }
        if (this.getIngestEndpoint() != null) {
            sb.append("IngestEndpoint: ").append(this.getIngestEndpoint()).append(",");
        }
        if (this.getInsecureIngest() != null) {
            sb.append("InsecureIngest: ").append(this.getInsecureIngest()).append(",");
        }
        if (this.getLatencyMode() != null) {
            sb.append("LatencyMode: ").append(this.getLatencyMode()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getPlaybackUrl() != null) {
            sb.append("PlaybackUrl: ").append(this.getPlaybackUrl()).append(",");
        }
        if (this.getPreset() != null) {
            sb.append("Preset: ").append(this.getPreset()).append(",");
        }
        if (this.getRecordingConfigurationArn() != null) {
            sb.append("RecordingConfigurationArn: ").append(this.getRecordingConfigurationArn()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Channel)) {
            return false;
        }
        Channel other = (Channel)obj;
        if (other.getArn() == null ^ this.getArn() == null) {
            return false;
        }
        if (other.getArn() != null && !other.getArn().equals(this.getArn())) {
            return false;
        }
        if (other.getAuthorized() == null ^ this.getAuthorized() == null) {
            return false;
        }
        if (other.getAuthorized() != null && !other.getAuthorized().equals(this.getAuthorized())) {
            return false;
        }
        if (other.getIngestEndpoint() == null ^ this.getIngestEndpoint() == null) {
            return false;
        }
        if (other.getIngestEndpoint() != null && !other.getIngestEndpoint().equals(this.getIngestEndpoint())) {
            return false;
        }
        if (other.getInsecureIngest() == null ^ this.getInsecureIngest() == null) {
            return false;
        }
        if (other.getInsecureIngest() != null && !other.getInsecureIngest().equals(this.getInsecureIngest())) {
            return false;
        }
        if (other.getLatencyMode() == null ^ this.getLatencyMode() == null) {
            return false;
        }
        if (other.getLatencyMode() != null && !other.getLatencyMode().equals(this.getLatencyMode())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getPlaybackUrl() == null ^ this.getPlaybackUrl() == null) {
            return false;
        }
        if (other.getPlaybackUrl() != null && !other.getPlaybackUrl().equals(this.getPlaybackUrl())) {
            return false;
        }
        if (other.getPreset() == null ^ this.getPreset() == null) {
            return false;
        }
        if (other.getPreset() != null && !other.getPreset().equals(this.getPreset())) {
            return false;
        }
        if (other.getRecordingConfigurationArn() == null ^ this.getRecordingConfigurationArn() == null) {
            return false;
        }
        if (other.getRecordingConfigurationArn() != null && !other.getRecordingConfigurationArn().equals(this.getRecordingConfigurationArn())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        return other.getType() == null || other.getType().equals(this.getType());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getArn() == null ? 0 : this.getArn().hashCode());
        hashCode = 31 * hashCode + (this.getAuthorized() == null ? 0 : this.getAuthorized().hashCode());
        hashCode = 31 * hashCode + (this.getIngestEndpoint() == null ? 0 : this.getIngestEndpoint().hashCode());
        hashCode = 31 * hashCode + (this.getInsecureIngest() == null ? 0 : this.getInsecureIngest().hashCode());
        hashCode = 31 * hashCode + (this.getLatencyMode() == null ? 0 : this.getLatencyMode().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getPlaybackUrl() == null ? 0 : this.getPlaybackUrl().hashCode());
        hashCode = 31 * hashCode + (this.getPreset() == null ? 0 : this.getPreset().hashCode());
        hashCode = 31 * hashCode + (this.getRecordingConfigurationArn() == null ? 0 : this.getRecordingConfigurationArn().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        return hashCode;
    }

    public Channel clone() {
        try {
            return (Channel)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ChannelMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

