/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ivs.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.ivs.model.BatchError;
import com.amazonaws.services.ivs.model.Channel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BatchGetChannelResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<Channel> channels;
    private List<BatchError> errors;

    public List<Channel> getChannels() {
        return this.channels;
    }

    public void setChannels(Collection<Channel> channels) {
        if (channels == null) {
            this.channels = null;
            return;
        }
        this.channels = new ArrayList<Channel>(channels);
    }

    public BatchGetChannelResult withChannels(Channel ... channels) {
        if (this.channels == null) {
            this.setChannels(new ArrayList<Channel>(channels.length));
        }
        for (Channel ele : channels) {
            this.channels.add(ele);
        }
        return this;
    }

    public BatchGetChannelResult withChannels(Collection<Channel> channels) {
        this.setChannels(channels);
        return this;
    }

    public List<BatchError> getErrors() {
        return this.errors;
    }

    public void setErrors(Collection<BatchError> errors) {
        if (errors == null) {
            this.errors = null;
            return;
        }
        this.errors = new ArrayList<BatchError>(errors);
    }

    public BatchGetChannelResult withErrors(BatchError ... errors) {
        if (this.errors == null) {
            this.setErrors(new ArrayList<BatchError>(errors.length));
        }
        for (BatchError ele : errors) {
            this.errors.add(ele);
        }
        return this;
    }

    public BatchGetChannelResult withErrors(Collection<BatchError> errors) {
        this.setErrors(errors);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getChannels() != null) {
            sb.append("Channels: ").append(this.getChannels()).append(",");
        }
        if (this.getErrors() != null) {
            sb.append("Errors: ").append(this.getErrors());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetChannelResult)) {
            return false;
        }
        BatchGetChannelResult other = (BatchGetChannelResult)obj;
        if (other.getChannels() == null ^ this.getChannels() == null) {
            return false;
        }
        if (other.getChannels() != null && !other.getChannels().equals(this.getChannels())) {
            return false;
        }
        if (other.getErrors() == null ^ this.getErrors() == null) {
            return false;
        }
        return other.getErrors() == null || other.getErrors().equals(this.getErrors());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getChannels() == null ? 0 : this.getChannels().hashCode());
        hashCode = 31 * hashCode + (this.getErrors() == null ? 0 : this.getErrors().hashCode());
        return hashCode;
    }

    public BatchGetChannelResult clone() {
        try {
            return (BatchGetChannelResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

