/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotwireless.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.iotwireless.model.Gnss;
import java.util.List;

@SdkInternalApi
public class GnssMarshaller {
    private static final MarshallingInfo<String> PAYLOAD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Payload").build();
    private static final MarshallingInfo<Float> CAPTURETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.FLOAT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CaptureTime").build();
    private static final MarshallingInfo<Float> CAPTURETIMEACCURACY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.FLOAT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CaptureTimeAccuracy").build();
    private static final MarshallingInfo<List> ASSISTPOSITION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AssistPosition").build();
    private static final MarshallingInfo<Float> ASSISTALTITUDE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.FLOAT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AssistAltitude").build();
    private static final MarshallingInfo<Boolean> USE2DSOLVER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Use2DSolver").build();
    private static final GnssMarshaller instance = new GnssMarshaller();

    public static GnssMarshaller getInstance() {
        return instance;
    }

    public void marshall(Gnss gnss, ProtocolMarshaller protocolMarshaller) {
        if (gnss == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)gnss.getPayload(), PAYLOAD_BINDING);
            protocolMarshaller.marshall((Object)gnss.getCaptureTime(), CAPTURETIME_BINDING);
            protocolMarshaller.marshall((Object)gnss.getCaptureTimeAccuracy(), CAPTURETIMEACCURACY_BINDING);
            protocolMarshaller.marshall(gnss.getAssistPosition(), ASSISTPOSITION_BINDING);
            protocolMarshaller.marshall((Object)gnss.getAssistAltitude(), ASSISTALTITUDE_BINDING);
            protocolMarshaller.marshall((Object)gnss.getUse2DSolver(), USE2DSOLVER_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

