/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotwireless.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.iotwireless.model.TraceContent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GetNetworkAnalyzerConfigurationResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private TraceContent traceContent;
    private List<String> wirelessDevices;
    private List<String> wirelessGateways;

    public void setTraceContent(TraceContent traceContent) {
        this.traceContent = traceContent;
    }

    public TraceContent getTraceContent() {
        return this.traceContent;
    }

    public GetNetworkAnalyzerConfigurationResult withTraceContent(TraceContent traceContent) {
        this.setTraceContent(traceContent);
        return this;
    }

    public List<String> getWirelessDevices() {
        return this.wirelessDevices;
    }

    public void setWirelessDevices(Collection<String> wirelessDevices) {
        if (wirelessDevices == null) {
            this.wirelessDevices = null;
            return;
        }
        this.wirelessDevices = new ArrayList<String>(wirelessDevices);
    }

    public GetNetworkAnalyzerConfigurationResult withWirelessDevices(String ... wirelessDevices) {
        if (this.wirelessDevices == null) {
            this.setWirelessDevices(new ArrayList<String>(wirelessDevices.length));
        }
        for (String ele : wirelessDevices) {
            this.wirelessDevices.add(ele);
        }
        return this;
    }

    public GetNetworkAnalyzerConfigurationResult withWirelessDevices(Collection<String> wirelessDevices) {
        this.setWirelessDevices(wirelessDevices);
        return this;
    }

    public List<String> getWirelessGateways() {
        return this.wirelessGateways;
    }

    public void setWirelessGateways(Collection<String> wirelessGateways) {
        if (wirelessGateways == null) {
            this.wirelessGateways = null;
            return;
        }
        this.wirelessGateways = new ArrayList<String>(wirelessGateways);
    }

    public GetNetworkAnalyzerConfigurationResult withWirelessGateways(String ... wirelessGateways) {
        if (this.wirelessGateways == null) {
            this.setWirelessGateways(new ArrayList<String>(wirelessGateways.length));
        }
        for (String ele : wirelessGateways) {
            this.wirelessGateways.add(ele);
        }
        return this;
    }

    public GetNetworkAnalyzerConfigurationResult withWirelessGateways(Collection<String> wirelessGateways) {
        this.setWirelessGateways(wirelessGateways);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTraceContent() != null) {
            sb.append("TraceContent: ").append(this.getTraceContent()).append(",");
        }
        if (this.getWirelessDevices() != null) {
            sb.append("WirelessDevices: ").append(this.getWirelessDevices()).append(",");
        }
        if (this.getWirelessGateways() != null) {
            sb.append("WirelessGateways: ").append(this.getWirelessGateways());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetNetworkAnalyzerConfigurationResult)) {
            return false;
        }
        GetNetworkAnalyzerConfigurationResult other = (GetNetworkAnalyzerConfigurationResult)obj;
        if (other.getTraceContent() == null ^ this.getTraceContent() == null) {
            return false;
        }
        if (other.getTraceContent() != null && !other.getTraceContent().equals(this.getTraceContent())) {
            return false;
        }
        if (other.getWirelessDevices() == null ^ this.getWirelessDevices() == null) {
            return false;
        }
        if (other.getWirelessDevices() != null && !other.getWirelessDevices().equals(this.getWirelessDevices())) {
            return false;
        }
        if (other.getWirelessGateways() == null ^ this.getWirelessGateways() == null) {
            return false;
        }
        return other.getWirelessGateways() == null || other.getWirelessGateways().equals(this.getWirelessGateways());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTraceContent() == null ? 0 : this.getTraceContent().hashCode());
        hashCode = 31 * hashCode + (this.getWirelessDevices() == null ? 0 : this.getWirelessDevices().hashCode());
        hashCode = 31 * hashCode + (this.getWirelessGateways() == null ? 0 : this.getWirelessGateways().hashCode());
        return hashCode;
    }

    public GetNetworkAnalyzerConfigurationResult clone() {
        try {
            return (GetNetworkAnalyzerConfigurationResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

