/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iottwinmaker.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.iottwinmaker.model.S3SourceConfiguration;

@SdkInternalApi
public class S3SourceConfigurationMarshaller {
    private static final MarshallingInfo<String> LOCATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("location").build();
    private static final S3SourceConfigurationMarshaller instance = new S3SourceConfigurationMarshaller();

    public static S3SourceConfigurationMarshaller getInstance() {
        return instance;
    }

    public void marshall(S3SourceConfiguration s3SourceConfiguration, ProtocolMarshaller protocolMarshaller) {
        if (s3SourceConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)s3SourceConfiguration.getLocation(), LOCATION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

