/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iottwinmaker.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.iottwinmaker.model.SyncResourceFilter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListSyncResourcesRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String workspaceId;
    private String syncSource;
    private List<SyncResourceFilter> filters;
    private Integer maxResults;
    private String nextToken;

    public void setWorkspaceId(String workspaceId) {
        this.workspaceId = workspaceId;
    }

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public ListSyncResourcesRequest withWorkspaceId(String workspaceId) {
        this.setWorkspaceId(workspaceId);
        return this;
    }

    public void setSyncSource(String syncSource) {
        this.syncSource = syncSource;
    }

    public String getSyncSource() {
        return this.syncSource;
    }

    public ListSyncResourcesRequest withSyncSource(String syncSource) {
        this.setSyncSource(syncSource);
        return this;
    }

    public List<SyncResourceFilter> getFilters() {
        return this.filters;
    }

    public void setFilters(Collection<SyncResourceFilter> filters) {
        if (filters == null) {
            this.filters = null;
            return;
        }
        this.filters = new ArrayList<SyncResourceFilter>(filters);
    }

    public ListSyncResourcesRequest withFilters(SyncResourceFilter ... filters) {
        if (this.filters == null) {
            this.setFilters(new ArrayList<SyncResourceFilter>(filters.length));
        }
        for (SyncResourceFilter ele : filters) {
            this.filters.add(ele);
        }
        return this;
    }

    public ListSyncResourcesRequest withFilters(Collection<SyncResourceFilter> filters) {
        this.setFilters(filters);
        return this;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public ListSyncResourcesRequest withMaxResults(Integer maxResults) {
        this.setMaxResults(maxResults);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListSyncResourcesRequest withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getWorkspaceId() != null) {
            sb.append("WorkspaceId: ").append(this.getWorkspaceId()).append(",");
        }
        if (this.getSyncSource() != null) {
            sb.append("SyncSource: ").append(this.getSyncSource()).append(",");
        }
        if (this.getFilters() != null) {
            sb.append("Filters: ").append(this.getFilters()).append(",");
        }
        if (this.getMaxResults() != null) {
            sb.append("MaxResults: ").append(this.getMaxResults()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSyncResourcesRequest)) {
            return false;
        }
        ListSyncResourcesRequest other = (ListSyncResourcesRequest)obj;
        if (other.getWorkspaceId() == null ^ this.getWorkspaceId() == null) {
            return false;
        }
        if (other.getWorkspaceId() != null && !other.getWorkspaceId().equals(this.getWorkspaceId())) {
            return false;
        }
        if (other.getSyncSource() == null ^ this.getSyncSource() == null) {
            return false;
        }
        if (other.getSyncSource() != null && !other.getSyncSource().equals(this.getSyncSource())) {
            return false;
        }
        if (other.getFilters() == null ^ this.getFilters() == null) {
            return false;
        }
        if (other.getFilters() != null && !other.getFilters().equals(this.getFilters())) {
            return false;
        }
        if (other.getMaxResults() == null ^ this.getMaxResults() == null) {
            return false;
        }
        if (other.getMaxResults() != null && !other.getMaxResults().equals(this.getMaxResults())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getWorkspaceId() == null ? 0 : this.getWorkspaceId().hashCode());
        hashCode = 31 * hashCode + (this.getSyncSource() == null ? 0 : this.getSyncSource().hashCode());
        hashCode = 31 * hashCode + (this.getFilters() == null ? 0 : this.getFilters().hashCode());
        hashCode = 31 * hashCode + (this.getMaxResults() == null ? 0 : this.getMaxResults().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListSyncResourcesRequest clone() {
        return (ListSyncResourcesRequest)super.clone();
    }
}

