/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotthingsgraph;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.iotthingsgraph.AWSIoTThingsGraphAsync;
import com.amazonaws.services.iotthingsgraph.AWSIoTThingsGraphAsyncClientBuilder;
import com.amazonaws.services.iotthingsgraph.AWSIoTThingsGraphClient;
import com.amazonaws.services.iotthingsgraph.model.AssociateEntityToThingRequest;
import com.amazonaws.services.iotthingsgraph.model.AssociateEntityToThingResult;
import com.amazonaws.services.iotthingsgraph.model.CreateFlowTemplateRequest;
import com.amazonaws.services.iotthingsgraph.model.CreateFlowTemplateResult;
import com.amazonaws.services.iotthingsgraph.model.CreateSystemInstanceRequest;
import com.amazonaws.services.iotthingsgraph.model.CreateSystemInstanceResult;
import com.amazonaws.services.iotthingsgraph.model.CreateSystemTemplateRequest;
import com.amazonaws.services.iotthingsgraph.model.CreateSystemTemplateResult;
import com.amazonaws.services.iotthingsgraph.model.DeleteFlowTemplateRequest;
import com.amazonaws.services.iotthingsgraph.model.DeleteFlowTemplateResult;
import com.amazonaws.services.iotthingsgraph.model.DeleteNamespaceRequest;
import com.amazonaws.services.iotthingsgraph.model.DeleteNamespaceResult;
import com.amazonaws.services.iotthingsgraph.model.DeleteSystemInstanceRequest;
import com.amazonaws.services.iotthingsgraph.model.DeleteSystemInstanceResult;
import com.amazonaws.services.iotthingsgraph.model.DeleteSystemTemplateRequest;
import com.amazonaws.services.iotthingsgraph.model.DeleteSystemTemplateResult;
import com.amazonaws.services.iotthingsgraph.model.DeploySystemInstanceRequest;
import com.amazonaws.services.iotthingsgraph.model.DeploySystemInstanceResult;
import com.amazonaws.services.iotthingsgraph.model.DeprecateFlowTemplateRequest;
import com.amazonaws.services.iotthingsgraph.model.DeprecateFlowTemplateResult;
import com.amazonaws.services.iotthingsgraph.model.DeprecateSystemTemplateRequest;
import com.amazonaws.services.iotthingsgraph.model.DeprecateSystemTemplateResult;
import com.amazonaws.services.iotthingsgraph.model.DescribeNamespaceRequest;
import com.amazonaws.services.iotthingsgraph.model.DescribeNamespaceResult;
import com.amazonaws.services.iotthingsgraph.model.DissociateEntityFromThingRequest;
import com.amazonaws.services.iotthingsgraph.model.DissociateEntityFromThingResult;
import com.amazonaws.services.iotthingsgraph.model.GetEntitiesRequest;
import com.amazonaws.services.iotthingsgraph.model.GetEntitiesResult;
import com.amazonaws.services.iotthingsgraph.model.GetFlowTemplateRequest;
import com.amazonaws.services.iotthingsgraph.model.GetFlowTemplateResult;
import com.amazonaws.services.iotthingsgraph.model.GetFlowTemplateRevisionsRequest;
import com.amazonaws.services.iotthingsgraph.model.GetFlowTemplateRevisionsResult;
import com.amazonaws.services.iotthingsgraph.model.GetNamespaceDeletionStatusRequest;
import com.amazonaws.services.iotthingsgraph.model.GetNamespaceDeletionStatusResult;
import com.amazonaws.services.iotthingsgraph.model.GetSystemInstanceRequest;
import com.amazonaws.services.iotthingsgraph.model.GetSystemInstanceResult;
import com.amazonaws.services.iotthingsgraph.model.GetSystemTemplateRequest;
import com.amazonaws.services.iotthingsgraph.model.GetSystemTemplateResult;
import com.amazonaws.services.iotthingsgraph.model.GetSystemTemplateRevisionsRequest;
import com.amazonaws.services.iotthingsgraph.model.GetSystemTemplateRevisionsResult;
import com.amazonaws.services.iotthingsgraph.model.GetUploadStatusRequest;
import com.amazonaws.services.iotthingsgraph.model.GetUploadStatusResult;
import com.amazonaws.services.iotthingsgraph.model.ListFlowExecutionMessagesRequest;
import com.amazonaws.services.iotthingsgraph.model.ListFlowExecutionMessagesResult;
import com.amazonaws.services.iotthingsgraph.model.ListTagsForResourceRequest;
import com.amazonaws.services.iotthingsgraph.model.ListTagsForResourceResult;
import com.amazonaws.services.iotthingsgraph.model.SearchEntitiesRequest;
import com.amazonaws.services.iotthingsgraph.model.SearchEntitiesResult;
import com.amazonaws.services.iotthingsgraph.model.SearchFlowExecutionsRequest;
import com.amazonaws.services.iotthingsgraph.model.SearchFlowExecutionsResult;
import com.amazonaws.services.iotthingsgraph.model.SearchFlowTemplatesRequest;
import com.amazonaws.services.iotthingsgraph.model.SearchFlowTemplatesResult;
import com.amazonaws.services.iotthingsgraph.model.SearchSystemInstancesRequest;
import com.amazonaws.services.iotthingsgraph.model.SearchSystemInstancesResult;
import com.amazonaws.services.iotthingsgraph.model.SearchSystemTemplatesRequest;
import com.amazonaws.services.iotthingsgraph.model.SearchSystemTemplatesResult;
import com.amazonaws.services.iotthingsgraph.model.SearchThingsRequest;
import com.amazonaws.services.iotthingsgraph.model.SearchThingsResult;
import com.amazonaws.services.iotthingsgraph.model.TagResourceRequest;
import com.amazonaws.services.iotthingsgraph.model.TagResourceResult;
import com.amazonaws.services.iotthingsgraph.model.UndeploySystemInstanceRequest;
import com.amazonaws.services.iotthingsgraph.model.UndeploySystemInstanceResult;
import com.amazonaws.services.iotthingsgraph.model.UntagResourceRequest;
import com.amazonaws.services.iotthingsgraph.model.UntagResourceResult;
import com.amazonaws.services.iotthingsgraph.model.UpdateFlowTemplateRequest;
import com.amazonaws.services.iotthingsgraph.model.UpdateFlowTemplateResult;
import com.amazonaws.services.iotthingsgraph.model.UpdateSystemTemplateRequest;
import com.amazonaws.services.iotthingsgraph.model.UpdateSystemTemplateResult;
import com.amazonaws.services.iotthingsgraph.model.UploadEntityDefinitionsRequest;
import com.amazonaws.services.iotthingsgraph.model.UploadEntityDefinitionsResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSIoTThingsGraphAsyncClient
extends AWSIoTThingsGraphClient
implements AWSIoTThingsGraphAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSIoTThingsGraphAsyncClientBuilder asyncBuilder() {
        return AWSIoTThingsGraphAsyncClientBuilder.standard();
    }

    AWSIoTThingsGraphAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSIoTThingsGraphAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<AssociateEntityToThingResult> associateEntityToThingAsync(AssociateEntityToThingRequest request) {
        return this.associateEntityToThingAsync(request, null);
    }

    @Override
    public Future<AssociateEntityToThingResult> associateEntityToThingAsync(AssociateEntityToThingRequest request, final AsyncHandler<AssociateEntityToThingRequest, AssociateEntityToThingResult> asyncHandler) {
        final AssociateEntityToThingRequest finalRequest = (AssociateEntityToThingRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<AssociateEntityToThingResult>(){

            @Override
            public AssociateEntityToThingResult call() throws Exception {
                AssociateEntityToThingResult result = null;
                try {
                    result = AWSIoTThingsGraphAsyncClient.this.executeAssociateEntityToThing(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateFlowTemplateResult> createFlowTemplateAsync(CreateFlowTemplateRequest request) {
        return this.createFlowTemplateAsync(request, null);
    }

    @Override
    public Future<CreateFlowTemplateResult> createFlowTemplateAsync(CreateFlowTemplateRequest request, final AsyncHandler<CreateFlowTemplateRequest, CreateFlowTemplateResult> asyncHandler) {
        final CreateFlowTemplateRequest finalRequest = (CreateFlowTemplateRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateFlowTemplateResult>(){

            @Override
            public CreateFlowTemplateResult call() throws Exception {
                CreateFlowTemplateResult result = null;
                try {
                    result = AWSIoTThingsGraphAsyncClient.this.executeCreateFlowTemplate(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateSystemInstanceResult> createSystemInstanceAsync(CreateSystemInstanceRequest request) {
        return this.createSystemInstanceAsync(request, null);
    }

    @Override
    public Future<CreateSystemInstanceResult> createSystemInstanceAsync(CreateSystemInstanceRequest request, final AsyncHandler<CreateSystemInstanceRequest, CreateSystemInstanceResult> asyncHandler) {
        final CreateSystemInstanceRequest finalRequest = (CreateSystemInstanceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateSystemInstanceResult>(){

            @Override
            public CreateSystemInstanceResult call() throws Exception {
                CreateSystemInstanceResult result = null;
                try {
                    result = AWSIoTThingsGraphAsyncClient.this.executeCreateSystemInstance(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateSystemTemplateResult> createSystemTemplateAsync(CreateSystemTemplateRequest request) {
        return this.createSystemTemplateAsync(request, null);
    }

    @Override
    public Future<CreateSystemTemplateResult> createSystemTemplateAsync(CreateSystemTemplateRequest request, final AsyncHandler<CreateSystemTemplateRequest, CreateSystemTemplateResult> asyncHandler) {
        final CreateSystemTemplateRequest finalRequest = (CreateSystemTemplateRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateSystemTemplateResult>(){

            @Override
            public CreateSystemTemplateResult call() throws Exception {
                CreateSystemTemplateResult result = null;
                try {
                    result = AWSIoTThingsGraphAsyncClient.this.executeCreateSystemTemplate(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteFlowTemplateResult> deleteFlowTemplateAsync(DeleteFlowTemplateRequest request) {
        return this.deleteFlowTemplateAsync(request, null);
    }

    @Override
    public Future<DeleteFlowTemplateResult> deleteFlowTemplateAsync(DeleteFlowTemplateRequest request, final AsyncHandler<DeleteFlowTemplateRequest, DeleteFlowTemplateResult> asyncHandler) {
        final DeleteFlowTemplateRequest finalRequest = (DeleteFlowTemplateRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteFlowTemplateResult>(){

            @Override
            public DeleteFlowTemplateResult call() throws Exception {
                DeleteFlowTemplateResult result = null;
                try {
                    result = AWSIoTThingsGraphAsyncClient.this.executeDeleteFlowTemplate(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteNamespaceResult> deleteNamespaceAsync(DeleteNamespaceRequest request) {
        return this.deleteNamespaceAsync(request, null);
    }

    @Override
    public Future<DeleteNamespaceResult> deleteNamespaceAsync(DeleteNamespaceRequest request, final AsyncHandler<DeleteNamespaceRequest, DeleteNamespaceResult> asyncHandler) {
        final DeleteNamespaceRequest finalRequest = (DeleteNamespaceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteNamespaceResult>(){

            @Override
            public DeleteNamespaceResult call() throws Exception {
                DeleteNamespaceResult result = null;
                try {
                    result = AWSIoTThingsGraphAsyncClient.this.executeDeleteNamespace(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteSystemInstanceResult> deleteSystemInstanceAsync(DeleteSystemInstanceRequest request) {
        return this.deleteSystemInstanceAsync(request, null);
    }

    @Override
    public Future<DeleteSystemInstanceResult> deleteSystemInstanceAsync(DeleteSystemInstanceRequest request, final AsyncHandler<DeleteSystemInstanceRequest, DeleteSystemInstanceResult> asyncHandler) {
        final DeleteSystemInstanceRequest finalRequest = (DeleteSystemInstanceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteSystemInstanceResult>(){

            @Override
            public DeleteSystemInstanceResult call() throws Exception {
                DeleteSystemInstanceResult result = null;
                try {
                    result = AWSIoTThingsGraphAsyncClient.this.executeDeleteSystemInstance(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteSystemTemplateResult> deleteSystemTemplateAsync(DeleteSystemTemplateRequest request) {
        return this.deleteSystemTemplateAsync(request, null);
    }

    @Override
    public Future<DeleteSystemTemplateResult> deleteSystemTemplateAsync(DeleteSystemTemplateRequest request, final AsyncHandler<DeleteSystemTemplateRequest, DeleteSystemTemplateResult> asyncHandler) {
        final DeleteSystemTemplateRequest finalRequest = (DeleteSystemTemplateRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteSystemTemplateResult>(){

            @Override
            public DeleteSystemTemplateResult call() throws Exception {
                DeleteSystemTemplateResult result = null;
                try {
                    result = AWSIoTThingsGraphAsyncClient.this.executeDeleteSystemTemplate(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeploySystemInstanceResult> deploySystemInstanceAsync(DeploySystemInstanceRequest request) {
        return this.deploySystemInstanceAsync(request, null);
    }

    @Override
    public Future<DeploySystemInstanceResult> deploySystemInstanceAsync(DeploySystemInstanceRequest request, final AsyncHandler<DeploySystemInstanceRequest, DeploySystemInstanceResult> asyncHandler) {
        final DeploySystemInstanceRequest finalRequest = (DeploySystemInstanceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeploySystemInstanceResult>(){

            @Override
            public DeploySystemInstanceResult call() throws Exception {
                DeploySystemInstanceResult result = null;
                try {
                    result = AWSIoTThingsGraphAsyncClient.this.executeDeploySystemInstance(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeprecateFlowTemplateResult> deprecateFlowTemplateAsync(DeprecateFlowTemplateRequest request) {
        return this.deprecateFlowTemplateAsync(request, null);
    }

    @Override
    public Future<DeprecateFlowTemplateResult> deprecateFlowTemplateAsync(DeprecateFlowTemplateRequest request, final AsyncHandler<DeprecateFlowTemplateRequest, DeprecateFlowTemplateResult> asyncHandler) {
        final DeprecateFlowTemplateRequest finalRequest = (DeprecateFlowTemplateRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeprecateFlowTemplateResult>(){

            @Override
            public DeprecateFlowTemplateResult call() throws Exception {
                DeprecateFlowTemplateResult result = null;
                try {
                    result = AWSIoTThingsGraphAsyncClient.this.executeDeprecateFlowTemplate(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeprecateSystemTemplateResult> deprecateSystemTemplateAsync(DeprecateSystemTemplateRequest request) {
        return this.deprecateSystemTemplateAsync(request, null);
    }

    @Override
    public Future<DeprecateSystemTemplateResult> deprecateSystemTemplateAsync(DeprecateSystemTemplateRequest request, final AsyncHandler<DeprecateSystemTemplateRequest, DeprecateSystemTemplateResult> asyncHandler) {
        final DeprecateSystemTemplateRequest finalRequest = (DeprecateSystemTemplateRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeprecateSystemTemplateResult>(){

            @Override
            public DeprecateSystemTemplateResult call() throws Exception {
                DeprecateSystemTemplateResult result = null;
                try {
                    result = AWSIoTThingsGraphAsyncClient.this.executeDeprecateSystemTemplate(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeNamespaceResult> describeNamespaceAsync(DescribeNamespaceRequest request) {
        return this.describeNamespaceAsync(request, null);
    }

    @Override
    public Future<DescribeNamespaceResult> describeNamespaceAsync(DescribeNamespaceRequest request, final AsyncHandler<DescribeNamespaceRequest, DescribeNamespaceResult> asyncHandler) {
        final DescribeNamespaceRequest finalRequest = (DescribeNamespaceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeNamespaceResult>(){

            @Override
            public DescribeNamespaceResult call() throws Exception {
                DescribeNamespaceResult result = null;
                try {
                    result = AWSIoTThingsGraphAsyncClient.this.executeDescribeNamespace(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DissociateEntityFromThingResult> dissociateEntityFromThingAsync(DissociateEntityFromThingRequest request) {
        return this.dissociateEntityFromThingAsync(request, null);
    }

    @Override
    public Future<DissociateEntityFromThingResult> dissociateEntityFromThingAsync(DissociateEntityFromThingRequest request, final AsyncHandler<DissociateEntityFromThingRequest, DissociateEntityFromThingResult> asyncHandler) {
        final DissociateEntityFromThingRequest finalRequest = (DissociateEntityFromThingRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DissociateEntityFromThingResult>(){

            @Override
            public DissociateEntityFromThingResult call() throws Exception {
                DissociateEntityFromThingResult result = null;
                try {
                    result = AWSIoTThingsGraphAsyncClient.this.executeDissociateEntityFromThing(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetEntitiesResult> getEntitiesAsync(GetEntitiesRequest request) {
        return this.getEntitiesAsync(request, null);
    }

    @Override
    public Future<GetEntitiesResult> getEntitiesAsync(GetEntitiesRequest request, final AsyncHandler<GetEntitiesRequest, GetEntitiesResult> asyncHandler) {
        final GetEntitiesRequest finalRequest = (GetEntitiesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetEntitiesResult>(){

            @Override
            public GetEntitiesResult call() throws Exception {
                GetEntitiesResult result = null;
                try {
                    result = AWSIoTThingsGraphAsyncClient.this.executeGetEntities(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetFlowTemplateResult> getFlowTemplateAsync(GetFlowTemplateRequest request) {
        return this.getFlowTemplateAsync(request, null);
    }

    @Override
    public Future<GetFlowTemplateResult> getFlowTemplateAsync(GetFlowTemplateRequest request, final AsyncHandler<GetFlowTemplateRequest, GetFlowTemplateResult> asyncHandler) {
        final GetFlowTemplateRequest finalRequest = (GetFlowTemplateRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetFlowTemplateResult>(){

            @Override
            public GetFlowTemplateResult call() throws Exception {
                GetFlowTemplateResult result = null;
                try {
                    result = AWSIoTThingsGraphAsyncClient.this.executeGetFlowTemplate(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetFlowTemplateRevisionsResult> getFlowTemplateRevisionsAsync(GetFlowTemplateRevisionsRequest request) {
        return this.getFlowTemplateRevisionsAsync(request, null);
    }

    @Override
    public Future<GetFlowTemplateRevisionsResult> getFlowTemplateRevisionsAsync(GetFlowTemplateRevisionsRequest request, final AsyncHandler<GetFlowTemplateRevisionsRequest, GetFlowTemplateRevisionsResult> asyncHandler) {
        final GetFlowTemplateRevisionsRequest finalRequest = (GetFlowTemplateRevisionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetFlowTemplateRevisionsResult>(){

            @Override
            public GetFlowTemplateRevisionsResult call() throws Exception {
                GetFlowTemplateRevisionsResult result = null;
                try {
                    result = AWSIoTThingsGraphAsyncClient.this.executeGetFlowTemplateRevisions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetNamespaceDeletionStatusResult> getNamespaceDeletionStatusAsync(GetNamespaceDeletionStatusRequest request) {
        return this.getNamespaceDeletionStatusAsync(request, null);
    }

    @Override
    public Future<GetNamespaceDeletionStatusResult> getNamespaceDeletionStatusAsync(GetNamespaceDeletionStatusRequest request, final AsyncHandler<GetNamespaceDeletionStatusRequest, GetNamespaceDeletionStatusResult> asyncHandler) {
        final GetNamespaceDeletionStatusRequest finalRequest = (GetNamespaceDeletionStatusRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetNamespaceDeletionStatusResult>(){

            @Override
            public GetNamespaceDeletionStatusResult call() throws Exception {
                GetNamespaceDeletionStatusResult result = null;
                try {
                    result = AWSIoTThingsGraphAsyncClient.this.executeGetNamespaceDeletionStatus(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetSystemInstanceResult> getSystemInstanceAsync(GetSystemInstanceRequest request) {
        return this.getSystemInstanceAsync(request, null);
    }

    @Override
    public Future<GetSystemInstanceResult> getSystemInstanceAsync(GetSystemInstanceRequest request, final AsyncHandler<GetSystemInstanceRequest, GetSystemInstanceResult> asyncHandler) {
        final GetSystemInstanceRequest finalRequest = (GetSystemInstanceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetSystemInstanceResult>(){

            @Override
            public GetSystemInstanceResult call() throws Exception {
                GetSystemInstanceResult result = null;
                try {
                    result = AWSIoTThingsGraphAsyncClient.this.executeGetSystemInstance(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetSystemTemplateResult> getSystemTemplateAsync(GetSystemTemplateRequest request) {
        return this.getSystemTemplateAsync(request, null);
    }

    @Override
    public Future<GetSystemTemplateResult> getSystemTemplateAsync(GetSystemTemplateRequest request, final AsyncHandler<GetSystemTemplateRequest, GetSystemTemplateResult> asyncHandler) {
        final GetSystemTemplateRequest finalRequest = (GetSystemTemplateRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetSystemTemplateResult>(){

            @Override
            public GetSystemTemplateResult call() throws Exception {
                GetSystemTemplateResult result = null;
                try {
                    result = AWSIoTThingsGraphAsyncClient.this.executeGetSystemTemplate(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetSystemTemplateRevisionsResult> getSystemTemplateRevisionsAsync(GetSystemTemplateRevisionsRequest request) {
        return this.getSystemTemplateRevisionsAsync(request, null);
    }

    @Override
    public Future<GetSystemTemplateRevisionsResult> getSystemTemplateRevisionsAsync(GetSystemTemplateRevisionsRequest request, final AsyncHandler<GetSystemTemplateRevisionsRequest, GetSystemTemplateRevisionsResult> asyncHandler) {
        final GetSystemTemplateRevisionsRequest finalRequest = (GetSystemTemplateRevisionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetSystemTemplateRevisionsResult>(){

            @Override
            public GetSystemTemplateRevisionsResult call() throws Exception {
                GetSystemTemplateRevisionsResult result = null;
                try {
                    result = AWSIoTThingsGraphAsyncClient.this.executeGetSystemTemplateRevisions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetUploadStatusResult> getUploadStatusAsync(GetUploadStatusRequest request) {
        return this.getUploadStatusAsync(request, null);
    }

    @Override
    public Future<GetUploadStatusResult> getUploadStatusAsync(GetUploadStatusRequest request, final AsyncHandler<GetUploadStatusRequest, GetUploadStatusResult> asyncHandler) {
        final GetUploadStatusRequest finalRequest = (GetUploadStatusRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetUploadStatusResult>(){

            @Override
            public GetUploadStatusResult call() throws Exception {
                GetUploadStatusResult result = null;
                try {
                    result = AWSIoTThingsGraphAsyncClient.this.executeGetUploadStatus(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListFlowExecutionMessagesResult> listFlowExecutionMessagesAsync(ListFlowExecutionMessagesRequest request) {
        return this.listFlowExecutionMessagesAsync(request, null);
    }

    @Override
    public Future<ListFlowExecutionMessagesResult> listFlowExecutionMessagesAsync(ListFlowExecutionMessagesRequest request, final AsyncHandler<ListFlowExecutionMessagesRequest, ListFlowExecutionMessagesResult> asyncHandler) {
        final ListFlowExecutionMessagesRequest finalRequest = (ListFlowExecutionMessagesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListFlowExecutionMessagesResult>(){

            @Override
            public ListFlowExecutionMessagesResult call() throws Exception {
                ListFlowExecutionMessagesResult result = null;
                try {
                    result = AWSIoTThingsGraphAsyncClient.this.executeListFlowExecutionMessages(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AWSIoTThingsGraphAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SearchEntitiesResult> searchEntitiesAsync(SearchEntitiesRequest request) {
        return this.searchEntitiesAsync(request, null);
    }

    @Override
    public Future<SearchEntitiesResult> searchEntitiesAsync(SearchEntitiesRequest request, final AsyncHandler<SearchEntitiesRequest, SearchEntitiesResult> asyncHandler) {
        final SearchEntitiesRequest finalRequest = (SearchEntitiesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<SearchEntitiesResult>(){

            @Override
            public SearchEntitiesResult call() throws Exception {
                SearchEntitiesResult result = null;
                try {
                    result = AWSIoTThingsGraphAsyncClient.this.executeSearchEntities(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SearchFlowExecutionsResult> searchFlowExecutionsAsync(SearchFlowExecutionsRequest request) {
        return this.searchFlowExecutionsAsync(request, null);
    }

    @Override
    public Future<SearchFlowExecutionsResult> searchFlowExecutionsAsync(SearchFlowExecutionsRequest request, final AsyncHandler<SearchFlowExecutionsRequest, SearchFlowExecutionsResult> asyncHandler) {
        final SearchFlowExecutionsRequest finalRequest = (SearchFlowExecutionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<SearchFlowExecutionsResult>(){

            @Override
            public SearchFlowExecutionsResult call() throws Exception {
                SearchFlowExecutionsResult result = null;
                try {
                    result = AWSIoTThingsGraphAsyncClient.this.executeSearchFlowExecutions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SearchFlowTemplatesResult> searchFlowTemplatesAsync(SearchFlowTemplatesRequest request) {
        return this.searchFlowTemplatesAsync(request, null);
    }

    @Override
    public Future<SearchFlowTemplatesResult> searchFlowTemplatesAsync(SearchFlowTemplatesRequest request, final AsyncHandler<SearchFlowTemplatesRequest, SearchFlowTemplatesResult> asyncHandler) {
        final SearchFlowTemplatesRequest finalRequest = (SearchFlowTemplatesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<SearchFlowTemplatesResult>(){

            @Override
            public SearchFlowTemplatesResult call() throws Exception {
                SearchFlowTemplatesResult result = null;
                try {
                    result = AWSIoTThingsGraphAsyncClient.this.executeSearchFlowTemplates(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SearchSystemInstancesResult> searchSystemInstancesAsync(SearchSystemInstancesRequest request) {
        return this.searchSystemInstancesAsync(request, null);
    }

    @Override
    public Future<SearchSystemInstancesResult> searchSystemInstancesAsync(SearchSystemInstancesRequest request, final AsyncHandler<SearchSystemInstancesRequest, SearchSystemInstancesResult> asyncHandler) {
        final SearchSystemInstancesRequest finalRequest = (SearchSystemInstancesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<SearchSystemInstancesResult>(){

            @Override
            public SearchSystemInstancesResult call() throws Exception {
                SearchSystemInstancesResult result = null;
                try {
                    result = AWSIoTThingsGraphAsyncClient.this.executeSearchSystemInstances(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SearchSystemTemplatesResult> searchSystemTemplatesAsync(SearchSystemTemplatesRequest request) {
        return this.searchSystemTemplatesAsync(request, null);
    }

    @Override
    public Future<SearchSystemTemplatesResult> searchSystemTemplatesAsync(SearchSystemTemplatesRequest request, final AsyncHandler<SearchSystemTemplatesRequest, SearchSystemTemplatesResult> asyncHandler) {
        final SearchSystemTemplatesRequest finalRequest = (SearchSystemTemplatesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<SearchSystemTemplatesResult>(){

            @Override
            public SearchSystemTemplatesResult call() throws Exception {
                SearchSystemTemplatesResult result = null;
                try {
                    result = AWSIoTThingsGraphAsyncClient.this.executeSearchSystemTemplates(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SearchThingsResult> searchThingsAsync(SearchThingsRequest request) {
        return this.searchThingsAsync(request, null);
    }

    @Override
    public Future<SearchThingsResult> searchThingsAsync(SearchThingsRequest request, final AsyncHandler<SearchThingsRequest, SearchThingsResult> asyncHandler) {
        final SearchThingsRequest finalRequest = (SearchThingsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<SearchThingsResult>(){

            @Override
            public SearchThingsResult call() throws Exception {
                SearchThingsResult result = null;
                try {
                    result = AWSIoTThingsGraphAsyncClient.this.executeSearchThings(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AWSIoTThingsGraphAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UndeploySystemInstanceResult> undeploySystemInstanceAsync(UndeploySystemInstanceRequest request) {
        return this.undeploySystemInstanceAsync(request, null);
    }

    @Override
    public Future<UndeploySystemInstanceResult> undeploySystemInstanceAsync(UndeploySystemInstanceRequest request, final AsyncHandler<UndeploySystemInstanceRequest, UndeploySystemInstanceResult> asyncHandler) {
        final UndeploySystemInstanceRequest finalRequest = (UndeploySystemInstanceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UndeploySystemInstanceResult>(){

            @Override
            public UndeploySystemInstanceResult call() throws Exception {
                UndeploySystemInstanceResult result = null;
                try {
                    result = AWSIoTThingsGraphAsyncClient.this.executeUndeploySystemInstance(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AWSIoTThingsGraphAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateFlowTemplateResult> updateFlowTemplateAsync(UpdateFlowTemplateRequest request) {
        return this.updateFlowTemplateAsync(request, null);
    }

    @Override
    public Future<UpdateFlowTemplateResult> updateFlowTemplateAsync(UpdateFlowTemplateRequest request, final AsyncHandler<UpdateFlowTemplateRequest, UpdateFlowTemplateResult> asyncHandler) {
        final UpdateFlowTemplateRequest finalRequest = (UpdateFlowTemplateRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateFlowTemplateResult>(){

            @Override
            public UpdateFlowTemplateResult call() throws Exception {
                UpdateFlowTemplateResult result = null;
                try {
                    result = AWSIoTThingsGraphAsyncClient.this.executeUpdateFlowTemplate(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateSystemTemplateResult> updateSystemTemplateAsync(UpdateSystemTemplateRequest request) {
        return this.updateSystemTemplateAsync(request, null);
    }

    @Override
    public Future<UpdateSystemTemplateResult> updateSystemTemplateAsync(UpdateSystemTemplateRequest request, final AsyncHandler<UpdateSystemTemplateRequest, UpdateSystemTemplateResult> asyncHandler) {
        final UpdateSystemTemplateRequest finalRequest = (UpdateSystemTemplateRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateSystemTemplateResult>(){

            @Override
            public UpdateSystemTemplateResult call() throws Exception {
                UpdateSystemTemplateResult result = null;
                try {
                    result = AWSIoTThingsGraphAsyncClient.this.executeUpdateSystemTemplate(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UploadEntityDefinitionsResult> uploadEntityDefinitionsAsync(UploadEntityDefinitionsRequest request) {
        return this.uploadEntityDefinitionsAsync(request, null);
    }

    @Override
    public Future<UploadEntityDefinitionsResult> uploadEntityDefinitionsAsync(UploadEntityDefinitionsRequest request, final AsyncHandler<UploadEntityDefinitionsRequest, UploadEntityDefinitionsResult> asyncHandler) {
        final UploadEntityDefinitionsRequest finalRequest = (UploadEntityDefinitionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UploadEntityDefinitionsResult>(){

            @Override
            public UploadEntityDefinitionsResult call() throws Exception {
                UploadEntityDefinitionsResult result = null;
                try {
                    result = AWSIoTThingsGraphAsyncClient.this.executeUploadEntityDefinitions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

