/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotsitewise.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.iotsitewise.model.Csv;
import java.util.List;

@SdkInternalApi
public class CsvMarshaller {
    private static final MarshallingInfo<List> COLUMNNAMES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("columnNames").build();
    private static final CsvMarshaller instance = new CsvMarshaller();

    public static CsvMarshaller getInstance() {
        return instance;
    }

    public void marshall(Csv csv, ProtocolMarshaller protocolMarshaller) {
        if (csv == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(csv.getColumnNames(), COLUMNNAMES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

