/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotsitewise.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.iotsitewise.model.ColumnName;
import com.amazonaws.services.iotsitewise.model.transform.CsvMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Csv
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> columnNames;

    public List<String> getColumnNames() {
        return this.columnNames;
    }

    public void setColumnNames(Collection<String> columnNames) {
        if (columnNames == null) {
            this.columnNames = null;
            return;
        }
        this.columnNames = new ArrayList<String>(columnNames);
    }

    public Csv withColumnNames(String ... columnNames) {
        if (this.columnNames == null) {
            this.setColumnNames(new ArrayList<String>(columnNames.length));
        }
        for (String ele : columnNames) {
            this.columnNames.add(ele);
        }
        return this;
    }

    public Csv withColumnNames(Collection<String> columnNames) {
        this.setColumnNames(columnNames);
        return this;
    }

    public Csv withColumnNames(ColumnName ... columnNames) {
        ArrayList<String> columnNamesCopy = new ArrayList<String>(columnNames.length);
        for (ColumnName value : columnNames) {
            columnNamesCopy.add(value.toString());
        }
        if (this.getColumnNames() == null) {
            this.setColumnNames(columnNamesCopy);
        } else {
            this.getColumnNames().addAll(columnNamesCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getColumnNames() != null) {
            sb.append("ColumnNames: ").append(this.getColumnNames());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Csv)) {
            return false;
        }
        Csv other = (Csv)obj;
        if (other.getColumnNames() == null ^ this.getColumnNames() == null) {
            return false;
        }
        return other.getColumnNames() == null || other.getColumnNames().equals(this.getColumnNames());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getColumnNames() == null ? 0 : this.getColumnNames().hashCode());
        return hashCode;
    }

    public Csv clone() {
        try {
            return (Csv)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CsvMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

