/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotfleetwise.model.transform;

import com.amazonaws.services.iotfleetwise.model.Node;
import com.amazonaws.services.iotfleetwise.model.transform.ActuatorJsonUnmarshaller;
import com.amazonaws.services.iotfleetwise.model.transform.AttributeJsonUnmarshaller;
import com.amazonaws.services.iotfleetwise.model.transform.BranchJsonUnmarshaller;
import com.amazonaws.services.iotfleetwise.model.transform.CustomPropertyJsonUnmarshaller;
import com.amazonaws.services.iotfleetwise.model.transform.CustomStructJsonUnmarshaller;
import com.amazonaws.services.iotfleetwise.model.transform.SensorJsonUnmarshaller;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import com.fasterxml.jackson.core.JsonToken;

public class NodeJsonUnmarshaller
implements Unmarshaller<Node, JsonUnmarshallerContext> {
    private static NodeJsonUnmarshaller instance;

    public Node unmarshall(JsonUnmarshallerContext context) throws Exception {
        Node node = new Node();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("branch", targetDepth)) {
                    context.nextToken();
                    node.setBranch(BranchJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("sensor", targetDepth)) {
                    context.nextToken();
                    node.setSensor(SensorJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("actuator", targetDepth)) {
                    context.nextToken();
                    node.setActuator(ActuatorJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("attribute", targetDepth)) {
                    context.nextToken();
                    node.setAttribute(AttributeJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("struct", targetDepth)) {
                    context.nextToken();
                    node.setStruct(CustomStructJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("property", targetDepth)) {
                    context.nextToken();
                    node.setProperty(CustomPropertyJsonUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return node;
    }

    public static NodeJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new NodeJsonUnmarshaller();
        }
        return instance;
    }
}

