/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ioteventsdata;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.ioteventsdata.AWSIoTEventsDataAsync;
import com.amazonaws.services.ioteventsdata.AWSIoTEventsDataAsyncClientBuilder;
import com.amazonaws.services.ioteventsdata.AWSIoTEventsDataClient;
import com.amazonaws.services.ioteventsdata.model.BatchAcknowledgeAlarmRequest;
import com.amazonaws.services.ioteventsdata.model.BatchAcknowledgeAlarmResult;
import com.amazonaws.services.ioteventsdata.model.BatchDeleteDetectorRequest;
import com.amazonaws.services.ioteventsdata.model.BatchDeleteDetectorResult;
import com.amazonaws.services.ioteventsdata.model.BatchDisableAlarmRequest;
import com.amazonaws.services.ioteventsdata.model.BatchDisableAlarmResult;
import com.amazonaws.services.ioteventsdata.model.BatchEnableAlarmRequest;
import com.amazonaws.services.ioteventsdata.model.BatchEnableAlarmResult;
import com.amazonaws.services.ioteventsdata.model.BatchPutMessageRequest;
import com.amazonaws.services.ioteventsdata.model.BatchPutMessageResult;
import com.amazonaws.services.ioteventsdata.model.BatchResetAlarmRequest;
import com.amazonaws.services.ioteventsdata.model.BatchResetAlarmResult;
import com.amazonaws.services.ioteventsdata.model.BatchSnoozeAlarmRequest;
import com.amazonaws.services.ioteventsdata.model.BatchSnoozeAlarmResult;
import com.amazonaws.services.ioteventsdata.model.BatchUpdateDetectorRequest;
import com.amazonaws.services.ioteventsdata.model.BatchUpdateDetectorResult;
import com.amazonaws.services.ioteventsdata.model.DescribeAlarmRequest;
import com.amazonaws.services.ioteventsdata.model.DescribeAlarmResult;
import com.amazonaws.services.ioteventsdata.model.DescribeDetectorRequest;
import com.amazonaws.services.ioteventsdata.model.DescribeDetectorResult;
import com.amazonaws.services.ioteventsdata.model.ListAlarmsRequest;
import com.amazonaws.services.ioteventsdata.model.ListAlarmsResult;
import com.amazonaws.services.ioteventsdata.model.ListDetectorsRequest;
import com.amazonaws.services.ioteventsdata.model.ListDetectorsResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSIoTEventsDataAsyncClient
extends AWSIoTEventsDataClient
implements AWSIoTEventsDataAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSIoTEventsDataAsyncClientBuilder asyncBuilder() {
        return AWSIoTEventsDataAsyncClientBuilder.standard();
    }

    AWSIoTEventsDataAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSIoTEventsDataAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<BatchAcknowledgeAlarmResult> batchAcknowledgeAlarmAsync(BatchAcknowledgeAlarmRequest request) {
        return this.batchAcknowledgeAlarmAsync(request, null);
    }

    @Override
    public Future<BatchAcknowledgeAlarmResult> batchAcknowledgeAlarmAsync(BatchAcknowledgeAlarmRequest request, final AsyncHandler<BatchAcknowledgeAlarmRequest, BatchAcknowledgeAlarmResult> asyncHandler) {
        final BatchAcknowledgeAlarmRequest finalRequest = (BatchAcknowledgeAlarmRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<BatchAcknowledgeAlarmResult>(){

            @Override
            public BatchAcknowledgeAlarmResult call() throws Exception {
                BatchAcknowledgeAlarmResult result = null;
                try {
                    result = AWSIoTEventsDataAsyncClient.this.executeBatchAcknowledgeAlarm(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<BatchDeleteDetectorResult> batchDeleteDetectorAsync(BatchDeleteDetectorRequest request) {
        return this.batchDeleteDetectorAsync(request, null);
    }

    @Override
    public Future<BatchDeleteDetectorResult> batchDeleteDetectorAsync(BatchDeleteDetectorRequest request, final AsyncHandler<BatchDeleteDetectorRequest, BatchDeleteDetectorResult> asyncHandler) {
        final BatchDeleteDetectorRequest finalRequest = (BatchDeleteDetectorRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<BatchDeleteDetectorResult>(){

            @Override
            public BatchDeleteDetectorResult call() throws Exception {
                BatchDeleteDetectorResult result = null;
                try {
                    result = AWSIoTEventsDataAsyncClient.this.executeBatchDeleteDetector(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<BatchDisableAlarmResult> batchDisableAlarmAsync(BatchDisableAlarmRequest request) {
        return this.batchDisableAlarmAsync(request, null);
    }

    @Override
    public Future<BatchDisableAlarmResult> batchDisableAlarmAsync(BatchDisableAlarmRequest request, final AsyncHandler<BatchDisableAlarmRequest, BatchDisableAlarmResult> asyncHandler) {
        final BatchDisableAlarmRequest finalRequest = (BatchDisableAlarmRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<BatchDisableAlarmResult>(){

            @Override
            public BatchDisableAlarmResult call() throws Exception {
                BatchDisableAlarmResult result = null;
                try {
                    result = AWSIoTEventsDataAsyncClient.this.executeBatchDisableAlarm(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<BatchEnableAlarmResult> batchEnableAlarmAsync(BatchEnableAlarmRequest request) {
        return this.batchEnableAlarmAsync(request, null);
    }

    @Override
    public Future<BatchEnableAlarmResult> batchEnableAlarmAsync(BatchEnableAlarmRequest request, final AsyncHandler<BatchEnableAlarmRequest, BatchEnableAlarmResult> asyncHandler) {
        final BatchEnableAlarmRequest finalRequest = (BatchEnableAlarmRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<BatchEnableAlarmResult>(){

            @Override
            public BatchEnableAlarmResult call() throws Exception {
                BatchEnableAlarmResult result = null;
                try {
                    result = AWSIoTEventsDataAsyncClient.this.executeBatchEnableAlarm(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<BatchPutMessageResult> batchPutMessageAsync(BatchPutMessageRequest request) {
        return this.batchPutMessageAsync(request, null);
    }

    @Override
    public Future<BatchPutMessageResult> batchPutMessageAsync(BatchPutMessageRequest request, final AsyncHandler<BatchPutMessageRequest, BatchPutMessageResult> asyncHandler) {
        final BatchPutMessageRequest finalRequest = (BatchPutMessageRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<BatchPutMessageResult>(){

            @Override
            public BatchPutMessageResult call() throws Exception {
                BatchPutMessageResult result = null;
                try {
                    result = AWSIoTEventsDataAsyncClient.this.executeBatchPutMessage(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<BatchResetAlarmResult> batchResetAlarmAsync(BatchResetAlarmRequest request) {
        return this.batchResetAlarmAsync(request, null);
    }

    @Override
    public Future<BatchResetAlarmResult> batchResetAlarmAsync(BatchResetAlarmRequest request, final AsyncHandler<BatchResetAlarmRequest, BatchResetAlarmResult> asyncHandler) {
        final BatchResetAlarmRequest finalRequest = (BatchResetAlarmRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<BatchResetAlarmResult>(){

            @Override
            public BatchResetAlarmResult call() throws Exception {
                BatchResetAlarmResult result = null;
                try {
                    result = AWSIoTEventsDataAsyncClient.this.executeBatchResetAlarm(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<BatchSnoozeAlarmResult> batchSnoozeAlarmAsync(BatchSnoozeAlarmRequest request) {
        return this.batchSnoozeAlarmAsync(request, null);
    }

    @Override
    public Future<BatchSnoozeAlarmResult> batchSnoozeAlarmAsync(BatchSnoozeAlarmRequest request, final AsyncHandler<BatchSnoozeAlarmRequest, BatchSnoozeAlarmResult> asyncHandler) {
        final BatchSnoozeAlarmRequest finalRequest = (BatchSnoozeAlarmRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<BatchSnoozeAlarmResult>(){

            @Override
            public BatchSnoozeAlarmResult call() throws Exception {
                BatchSnoozeAlarmResult result = null;
                try {
                    result = AWSIoTEventsDataAsyncClient.this.executeBatchSnoozeAlarm(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<BatchUpdateDetectorResult> batchUpdateDetectorAsync(BatchUpdateDetectorRequest request) {
        return this.batchUpdateDetectorAsync(request, null);
    }

    @Override
    public Future<BatchUpdateDetectorResult> batchUpdateDetectorAsync(BatchUpdateDetectorRequest request, final AsyncHandler<BatchUpdateDetectorRequest, BatchUpdateDetectorResult> asyncHandler) {
        final BatchUpdateDetectorRequest finalRequest = (BatchUpdateDetectorRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<BatchUpdateDetectorResult>(){

            @Override
            public BatchUpdateDetectorResult call() throws Exception {
                BatchUpdateDetectorResult result = null;
                try {
                    result = AWSIoTEventsDataAsyncClient.this.executeBatchUpdateDetector(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeAlarmResult> describeAlarmAsync(DescribeAlarmRequest request) {
        return this.describeAlarmAsync(request, null);
    }

    @Override
    public Future<DescribeAlarmResult> describeAlarmAsync(DescribeAlarmRequest request, final AsyncHandler<DescribeAlarmRequest, DescribeAlarmResult> asyncHandler) {
        final DescribeAlarmRequest finalRequest = (DescribeAlarmRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeAlarmResult>(){

            @Override
            public DescribeAlarmResult call() throws Exception {
                DescribeAlarmResult result = null;
                try {
                    result = AWSIoTEventsDataAsyncClient.this.executeDescribeAlarm(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeDetectorResult> describeDetectorAsync(DescribeDetectorRequest request) {
        return this.describeDetectorAsync(request, null);
    }

    @Override
    public Future<DescribeDetectorResult> describeDetectorAsync(DescribeDetectorRequest request, final AsyncHandler<DescribeDetectorRequest, DescribeDetectorResult> asyncHandler) {
        final DescribeDetectorRequest finalRequest = (DescribeDetectorRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeDetectorResult>(){

            @Override
            public DescribeDetectorResult call() throws Exception {
                DescribeDetectorResult result = null;
                try {
                    result = AWSIoTEventsDataAsyncClient.this.executeDescribeDetector(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListAlarmsResult> listAlarmsAsync(ListAlarmsRequest request) {
        return this.listAlarmsAsync(request, null);
    }

    @Override
    public Future<ListAlarmsResult> listAlarmsAsync(ListAlarmsRequest request, final AsyncHandler<ListAlarmsRequest, ListAlarmsResult> asyncHandler) {
        final ListAlarmsRequest finalRequest = (ListAlarmsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListAlarmsResult>(){

            @Override
            public ListAlarmsResult call() throws Exception {
                ListAlarmsResult result = null;
                try {
                    result = AWSIoTEventsDataAsyncClient.this.executeListAlarms(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListDetectorsResult> listDetectorsAsync(ListDetectorsRequest request) {
        return this.listDetectorsAsync(request, null);
    }

    @Override
    public Future<ListDetectorsResult> listDetectorsAsync(ListDetectorsRequest request, final AsyncHandler<ListDetectorsRequest, ListDetectorsResult> asyncHandler) {
        final ListDetectorsRequest finalRequest = (ListDetectorsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListDetectorsResult>(){

            @Override
            public ListDetectorsResult call() throws Exception {
                ListDetectorsResult result = null;
                try {
                    result = AWSIoTEventsDataAsyncClient.this.executeListDetectors(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

