/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotevents.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.iotevents.model.AnalysisResultLevel;
import com.amazonaws.services.iotevents.model.AnalysisResultLocation;
import com.amazonaws.services.iotevents.model.transform.AnalysisResultMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AnalysisResult
implements Serializable,
Cloneable,
StructuredPojo {
    private String type;
    private String level;
    private String message;
    private List<AnalysisResultLocation> locations;

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public AnalysisResult withType(String type) {
        this.setType(type);
        return this;
    }

    public void setLevel(String level) {
        this.level = level;
    }

    public String getLevel() {
        return this.level;
    }

    public AnalysisResult withLevel(String level) {
        this.setLevel(level);
        return this;
    }

    public AnalysisResult withLevel(AnalysisResultLevel level) {
        this.level = level.toString();
        return this;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    public AnalysisResult withMessage(String message) {
        this.setMessage(message);
        return this;
    }

    public List<AnalysisResultLocation> getLocations() {
        return this.locations;
    }

    public void setLocations(Collection<AnalysisResultLocation> locations) {
        if (locations == null) {
            this.locations = null;
            return;
        }
        this.locations = new ArrayList<AnalysisResultLocation>(locations);
    }

    public AnalysisResult withLocations(AnalysisResultLocation ... locations) {
        if (this.locations == null) {
            this.setLocations(new ArrayList<AnalysisResultLocation>(locations.length));
        }
        for (AnalysisResultLocation ele : locations) {
            this.locations.add(ele);
        }
        return this;
    }

    public AnalysisResult withLocations(Collection<AnalysisResultLocation> locations) {
        this.setLocations(locations);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType()).append(",");
        }
        if (this.getLevel() != null) {
            sb.append("Level: ").append(this.getLevel()).append(",");
        }
        if (this.getMessage() != null) {
            sb.append("Message: ").append(this.getMessage()).append(",");
        }
        if (this.getLocations() != null) {
            sb.append("Locations: ").append(this.getLocations());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalysisResult)) {
            return false;
        }
        AnalysisResult other = (AnalysisResult)obj;
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getLevel() == null ^ this.getLevel() == null) {
            return false;
        }
        if (other.getLevel() != null && !other.getLevel().equals(this.getLevel())) {
            return false;
        }
        if (other.getMessage() == null ^ this.getMessage() == null) {
            return false;
        }
        if (other.getMessage() != null && !other.getMessage().equals(this.getMessage())) {
            return false;
        }
        if (other.getLocations() == null ^ this.getLocations() == null) {
            return false;
        }
        return other.getLocations() == null || other.getLocations().equals(this.getLocations());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getLevel() == null ? 0 : this.getLevel().hashCode());
        hashCode = 31 * hashCode + (this.getMessage() == null ? 0 : this.getMessage().hashCode());
        hashCode = 31 * hashCode + (this.getLocations() == null ? 0 : this.getLocations().hashCode());
        return hashCode;
    }

    public AnalysisResult clone() {
        try {
            return (AnalysisResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AnalysisResultMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

