/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.iotdeviceadvisor.model.transform;

import java.math.*;

import javax.annotation.Generated;

import com.amazonaws.services.iotdeviceadvisor.model.*;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers.*;
import com.amazonaws.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * SuiteDefinitionConfiguration JSON Unmarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class SuiteDefinitionConfigurationJsonUnmarshaller implements Unmarshaller<SuiteDefinitionConfiguration, JsonUnmarshallerContext> {

    public SuiteDefinitionConfiguration unmarshall(JsonUnmarshallerContext context) throws Exception {
        SuiteDefinitionConfiguration suiteDefinitionConfiguration = new SuiteDefinitionConfiguration();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("suiteDefinitionName", targetDepth)) {
                    context.nextToken();
                    suiteDefinitionConfiguration.setSuiteDefinitionName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("devices", targetDepth)) {
                    context.nextToken();
                    suiteDefinitionConfiguration.setDevices(new ListUnmarshaller<DeviceUnderTest>(DeviceUnderTestJsonUnmarshaller.getInstance())

                    .unmarshall(context));
                }
                if (context.testExpression("intendedForQualification", targetDepth)) {
                    context.nextToken();
                    suiteDefinitionConfiguration.setIntendedForQualification(context.getUnmarshaller(Boolean.class).unmarshall(context));
                }
                if (context.testExpression("isLongDurationTest", targetDepth)) {
                    context.nextToken();
                    suiteDefinitionConfiguration.setIsLongDurationTest(context.getUnmarshaller(Boolean.class).unmarshall(context));
                }
                if (context.testExpression("rootGroup", targetDepth)) {
                    context.nextToken();
                    suiteDefinitionConfiguration.setRootGroup(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("devicePermissionRoleArn", targetDepth)) {
                    context.nextToken();
                    suiteDefinitionConfiguration.setDevicePermissionRoleArn(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("protocol", targetDepth)) {
                    context.nextToken();
                    suiteDefinitionConfiguration.setProtocol(context.getUnmarshaller(String.class).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return suiteDefinitionConfiguration;
    }

    private static SuiteDefinitionConfigurationJsonUnmarshaller instance;

    public static SuiteDefinitionConfigurationJsonUnmarshaller getInstance() {
        if (instance == null)
            instance = new SuiteDefinitionConfigurationJsonUnmarshaller();
        return instance;
    }
}
