/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotdeviceadvisor.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.iotdeviceadvisor.model.TestCaseCategory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ListTestCasesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<TestCaseCategory> categories;
    private Map<String, String> rootGroupConfiguration;
    private Map<String, String> groupConfiguration;
    private String nextToken;

    public List<TestCaseCategory> getCategories() {
        return this.categories;
    }

    public void setCategories(Collection<TestCaseCategory> categories) {
        if (categories == null) {
            this.categories = null;
            return;
        }
        this.categories = new ArrayList<TestCaseCategory>(categories);
    }

    public ListTestCasesResult withCategories(TestCaseCategory ... categories) {
        if (this.categories == null) {
            this.setCategories(new ArrayList<TestCaseCategory>(categories.length));
        }
        for (TestCaseCategory ele : categories) {
            this.categories.add(ele);
        }
        return this;
    }

    public ListTestCasesResult withCategories(Collection<TestCaseCategory> categories) {
        this.setCategories(categories);
        return this;
    }

    public Map<String, String> getRootGroupConfiguration() {
        return this.rootGroupConfiguration;
    }

    public void setRootGroupConfiguration(Map<String, String> rootGroupConfiguration) {
        this.rootGroupConfiguration = rootGroupConfiguration;
    }

    public ListTestCasesResult withRootGroupConfiguration(Map<String, String> rootGroupConfiguration) {
        this.setRootGroupConfiguration(rootGroupConfiguration);
        return this;
    }

    public ListTestCasesResult addRootGroupConfigurationEntry(String key, String value) {
        if (null == this.rootGroupConfiguration) {
            this.rootGroupConfiguration = new HashMap<String, String>();
        }
        if (this.rootGroupConfiguration.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.rootGroupConfiguration.put(key, value);
        return this;
    }

    public ListTestCasesResult clearRootGroupConfigurationEntries() {
        this.rootGroupConfiguration = null;
        return this;
    }

    public Map<String, String> getGroupConfiguration() {
        return this.groupConfiguration;
    }

    public void setGroupConfiguration(Map<String, String> groupConfiguration) {
        this.groupConfiguration = groupConfiguration;
    }

    public ListTestCasesResult withGroupConfiguration(Map<String, String> groupConfiguration) {
        this.setGroupConfiguration(groupConfiguration);
        return this;
    }

    public ListTestCasesResult addGroupConfigurationEntry(String key, String value) {
        if (null == this.groupConfiguration) {
            this.groupConfiguration = new HashMap<String, String>();
        }
        if (this.groupConfiguration.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.groupConfiguration.put(key, value);
        return this;
    }

    public ListTestCasesResult clearGroupConfigurationEntries() {
        this.groupConfiguration = null;
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListTestCasesResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCategories() != null) {
            sb.append("Categories: ").append(this.getCategories()).append(",");
        }
        if (this.getRootGroupConfiguration() != null) {
            sb.append("RootGroupConfiguration: ").append(this.getRootGroupConfiguration()).append(",");
        }
        if (this.getGroupConfiguration() != null) {
            sb.append("GroupConfiguration: ").append(this.getGroupConfiguration()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTestCasesResult)) {
            return false;
        }
        ListTestCasesResult other = (ListTestCasesResult)obj;
        if (other.getCategories() == null ^ this.getCategories() == null) {
            return false;
        }
        if (other.getCategories() != null && !other.getCategories().equals(this.getCategories())) {
            return false;
        }
        if (other.getRootGroupConfiguration() == null ^ this.getRootGroupConfiguration() == null) {
            return false;
        }
        if (other.getRootGroupConfiguration() != null && !other.getRootGroupConfiguration().equals(this.getRootGroupConfiguration())) {
            return false;
        }
        if (other.getGroupConfiguration() == null ^ this.getGroupConfiguration() == null) {
            return false;
        }
        if (other.getGroupConfiguration() != null && !other.getGroupConfiguration().equals(this.getGroupConfiguration())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCategories() == null ? 0 : this.getCategories().hashCode());
        hashCode = 31 * hashCode + (this.getRootGroupConfiguration() == null ? 0 : this.getRootGroupConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getGroupConfiguration() == null ? 0 : this.getGroupConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListTestCasesResult clone() {
        try {
            return (ListTestCasesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

