/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotanalytics.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.iotanalytics.model.ResourceConfiguration;
import com.amazonaws.services.iotanalytics.model.Variable;
import com.amazonaws.services.iotanalytics.model.transform.ContainerDatasetActionMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ContainerDatasetAction
implements Serializable,
Cloneable,
StructuredPojo {
    private String image;
    private String executionRoleArn;
    private ResourceConfiguration resourceConfiguration;
    private List<Variable> variables;

    public void setImage(String image) {
        this.image = image;
    }

    public String getImage() {
        return this.image;
    }

    public ContainerDatasetAction withImage(String image) {
        this.setImage(image);
        return this;
    }

    public void setExecutionRoleArn(String executionRoleArn) {
        this.executionRoleArn = executionRoleArn;
    }

    public String getExecutionRoleArn() {
        return this.executionRoleArn;
    }

    public ContainerDatasetAction withExecutionRoleArn(String executionRoleArn) {
        this.setExecutionRoleArn(executionRoleArn);
        return this;
    }

    public void setResourceConfiguration(ResourceConfiguration resourceConfiguration) {
        this.resourceConfiguration = resourceConfiguration;
    }

    public ResourceConfiguration getResourceConfiguration() {
        return this.resourceConfiguration;
    }

    public ContainerDatasetAction withResourceConfiguration(ResourceConfiguration resourceConfiguration) {
        this.setResourceConfiguration(resourceConfiguration);
        return this;
    }

    public List<Variable> getVariables() {
        return this.variables;
    }

    public void setVariables(Collection<Variable> variables) {
        if (variables == null) {
            this.variables = null;
            return;
        }
        this.variables = new ArrayList<Variable>(variables);
    }

    public ContainerDatasetAction withVariables(Variable ... variables) {
        if (this.variables == null) {
            this.setVariables(new ArrayList<Variable>(variables.length));
        }
        for (Variable ele : variables) {
            this.variables.add(ele);
        }
        return this;
    }

    public ContainerDatasetAction withVariables(Collection<Variable> variables) {
        this.setVariables(variables);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getImage() != null) {
            sb.append("Image: ").append(this.getImage()).append(",");
        }
        if (this.getExecutionRoleArn() != null) {
            sb.append("ExecutionRoleArn: ").append(this.getExecutionRoleArn()).append(",");
        }
        if (this.getResourceConfiguration() != null) {
            sb.append("ResourceConfiguration: ").append(this.getResourceConfiguration()).append(",");
        }
        if (this.getVariables() != null) {
            sb.append("Variables: ").append(this.getVariables());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContainerDatasetAction)) {
            return false;
        }
        ContainerDatasetAction other = (ContainerDatasetAction)obj;
        if (other.getImage() == null ^ this.getImage() == null) {
            return false;
        }
        if (other.getImage() != null && !other.getImage().equals(this.getImage())) {
            return false;
        }
        if (other.getExecutionRoleArn() == null ^ this.getExecutionRoleArn() == null) {
            return false;
        }
        if (other.getExecutionRoleArn() != null && !other.getExecutionRoleArn().equals(this.getExecutionRoleArn())) {
            return false;
        }
        if (other.getResourceConfiguration() == null ^ this.getResourceConfiguration() == null) {
            return false;
        }
        if (other.getResourceConfiguration() != null && !other.getResourceConfiguration().equals(this.getResourceConfiguration())) {
            return false;
        }
        if (other.getVariables() == null ^ this.getVariables() == null) {
            return false;
        }
        return other.getVariables() == null || other.getVariables().equals(this.getVariables());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getImage() == null ? 0 : this.getImage().hashCode());
        hashCode = 31 * hashCode + (this.getExecutionRoleArn() == null ? 0 : this.getExecutionRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.getResourceConfiguration() == null ? 0 : this.getResourceConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getVariables() == null ? 0 : this.getVariables().hashCode());
        return hashCode;
    }

    public ContainerDatasetAction clone() {
        try {
            return (ContainerDatasetAction)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ContainerDatasetActionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

